/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.fileupload;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.Conversation;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentEvent;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.faces.data.WorkflowEvent;

@Named
@ConversationScoped
public class FileUploadController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(FileUploadController.class.getName());
    public static final String FILEUPLOAD_ERROR = "FILEUPLOAD_ERROR";
    private ItemCollection uploadData = new ItemCollection();
    private List<Part> files;
    private ItemCollection workitem = null;
    private boolean isCompleted = true;
    @Inject
    private Conversation conversation;
    @Inject
    private WorkflowController workflowController;

    public List<Part> getFiles() {
        return this.files;
    }

    public void setFiles(List<Part> files) {
        this.files = files;
        this.isCompleted = false;
    }

    public ItemCollection getWorkitem() {
        if (this.workitem == null && this.workflowController.getWorkitem() != null) {
            this.workitem = this.workflowController.getWorkitem();
        }
        return this.workitem;
    }

    public void setWorkitem(ItemCollection workitem) {
        this.workitem = workitem;
    }

    public void onWorkflowEvent(@Observes @Priority(value=1000) WorkflowEvent workflowEvent) throws PluginException {
        int eventType = workflowEvent.getEventType();
        if (22 == eventType) {
            if (this.workitem != null) {
                this.attacheFiles(this.workitem);
            } else {
                this.attacheFiles(workflowEvent.getWorkitem());
            }
        }
    }

    public void onDocumentEvent(@Observes @Priority(value=1000) DocumentEvent documentEvent) throws PluginException {
        int eventType = documentEvent.getEventType();
        if (1 == eventType) {
            if (this.workitem != null) {
                this.attacheFiles(this.workitem);
            } else {
                this.attacheFiles(documentEvent.getDocument());
            }
        }
    }

    public void attacheFiles(ItemCollection workitem) throws PluginException {
        if (this.uploadData != null && this.uploadData.getFileData().size() > 0) {
            for (FileData fileData : this.uploadData.getFileData()) {
                workitem.addFileData(fileData);
            }
            this.uploadData = new ItemCollection();
        }
        if (this.files == null || this.files.size() == 0 || this.isCompleted) {
            return;
        }
        logger.log(Level.FINE, "uploaded file size:{0}", this.files.size());
        for (Part part : this.files) {
            String submittedFilename = part.getSubmittedFileName();
            String name = Paths.get(part.getSubmittedFileName(), new String[0]).getFileName().toString();
            long size = part.getSize();
            String contentType = part.getContentType();
            logger.log(Level.FINE, "uploaded file: submitted filename: {0}, name:{1}, size:{2}, content type: {3}", new Object[]{submittedFilename, name, size, contentType});
            part.getHeaderNames().forEach(headerName -> logger.log(Level.FINE, "header name: {0}, value: {1}", new Object[]{headerName, part.getHeader(headerName)}));
            try {
                byte[] bytes;
                InputStream inputStream;
                try (InputStream inputStream2 = inputStream = part.getInputStream();){
                    bytes = inputStream.readAllBytes();
                }
                FileData filedata = new FileData(name, bytes, contentType, null);
                workitem.addFileData(filedata);
            }
            catch (IOException e) {
                throw new PluginException(FileUploadController.class.getSimpleName(), FILEUPLOAD_ERROR, "failed to uplaod file parts: " + e.getMessage(), (Exception)e);
            }
        }
        this.isCompleted = true;
    }

    public void addAttachedFile(FileData fileData) {
        this.addFileUpload(fileData);
    }

    public void removeAttachedFile(String aFilename) {
        if (this.getWorkitem() != null) {
            this.getWorkitem().removeFile(aFilename);
        }
    }

    public String getUserInfo(String aFilename) {
        FileData fileData;
        Object result = "";
        if (this.getWorkitem() != null && (fileData = this.getWorkitem().getFileData(aFilename)) != null) {
            List createdList;
            List creatorList = (List)fileData.getAttribute("$creator");
            if (creatorList != null && creatorList.size() > 0) {
                result = (String)result + String.valueOf(creatorList.get(0));
            }
            if ((createdList = (List)fileData.getAttribute("$created")) != null && createdList.size() > 0) {
                result = (String)result + " - " + String.valueOf(createdList.get(0));
            }
        }
        return result;
    }

    public String getFileSize(String aFilename) {
        FileData fileData;
        if (this.getWorkitem() != null && (fileData = this.getWorkitem().getFileData(aFilename)) != null) {
            List sizeAttribute;
            double bytes = fileData.getContent().length;
            if (bytes == 0.0 && (sizeAttribute = (List)fileData.getAttribute("size")) != null && sizeAttribute.size() > 0) {
                try {
                    bytes = Double.parseDouble(sizeAttribute.get(0).toString());
                }
                catch (NumberFormatException n) {
                    logger.log(Level.WARNING, "unable to parse size attribute in FileData for file ''{0}''", aFilename);
                }
            }
            if (bytes >= 1.0E9) {
                return FileUploadController.round(bytes /= 1.0E9) + " GB";
            }
            if (bytes >= 1000000.0) {
                return FileUploadController.round(bytes /= 1000000.0) + " MB";
            }
            if (bytes >= 1000.0) {
                return FileUploadController.round(bytes /= 1000.0) + " KB";
            }
            return FileUploadController.round(bytes) + " bytes";
        }
        return "";
    }

    public static double round(double value) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(2, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public String getCID() {
        if (this.conversation != null) {
            return this.conversation.getId();
        }
        return "";
    }

    public List<FileData> getFileUploads() {
        if (this.uploadData == null) {
            this.uploadData = new ItemCollection();
        }
        return this.uploadData.getFileData();
    }

    public FileData getFileUpload(String fileName) {
        if (this.uploadData == null) {
            this.uploadData = new ItemCollection();
        }
        return this.uploadData.getFileData(fileName);
    }

    public void addFileUpload(FileData fileData) {
        this.uploadData.addFileData(fileData);
    }

    public void removeFileUpload(String aFilename) {
        this.uploadData.removeFile(aFilename);
    }
}

