/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.lucene;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.EventLogService;
import org.imixs.workflow.engine.adminp.AdminPService;
import org.imixs.workflow.engine.index.IndexEvent;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.engine.jpa.Document;
import org.imixs.workflow.engine.jpa.EventLog;
import org.imixs.workflow.engine.lucene.LuceneItemAdapter;
import org.imixs.workflow.exceptions.IndexException;

@Stateless
@LocalBean
public class LuceneIndexService {
    public static final int EVENTLOG_ENTRY_FLUSH_COUNT = 16;
    public static final String ANONYMOUS = "ANONYMOUS";
    public static final String DEFAULT_ANALYZER = "org.apache.lucene.analysis.standard.ClassicAnalyzer";
    public static final String DEFAULT_INDEX_DIRECTORY = "imixs-workflow-index";
    public static final String TAXONOMY_INDEXFIELD_PRAFIX = ".taxonomy";
    @PersistenceContext(unitName="org.imixs.workflow.jpa")
    private EntityManager manager;
    private SimpleDateFormat luceneDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    @Inject
    @ConfigProperty(name="lucence.indexDir", defaultValue="imixs-workflow-index")
    private String luceneIndexDir;
    @Inject
    @ConfigProperty(name="lucence.analyzerClass", defaultValue="org.apache.lucene.analysis.standard.ClassicAnalyzer")
    private String luceneAnalyzerClass;
    @Inject
    private LuceneItemAdapter luceneItemAdapter;
    private static Logger logger = Logger.getLogger(LuceneIndexService.class.getName());
    @Inject
    private AdminPService adminPService;
    @Inject
    private EventLogService eventLogService;
    @Inject
    private SchemaService schemaService;
    @Inject
    protected Event<IndexEvent> indexEvents;

    public String getLuceneIndexDir() {
        return this.luceneIndexDir.trim();
    }

    public void setLuceneIndexDir(String luceneIndexDir) {
        if (luceneIndexDir != null) {
            this.luceneIndexDir = luceneIndexDir.trim();
        }
    }

    public String getLuceneAnalyzerClass() {
        return this.luceneAnalyzerClass;
    }

    public void setLuceneAnalyzerClass(String luceneAnalyzerClass) {
        this.luceneAnalyzerClass = luceneAnalyzerClass;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean flushEventLog(int junkSize) {
        long total = 0L;
        long count = 0L;
        boolean dirtyIndex = true;
        long l = System.currentTimeMillis();
        while (dirtyIndex) {
            try {
                dirtyIndex = !this.flushEventLogByCount(16);
                if (!dirtyIndex) continue;
                total += 16L;
                if ((count += 16L) >= 100L) {
                    logger.finest("...flush event log: " + total + " entries in " + (System.currentTimeMillis() - l) + "ms...");
                    count = 0L;
                }
                if (total < (long)junkSize) continue;
                logger.finest("...flush event: Issue #439  -> total count >=" + total + " flushEventLog will be continued...");
                return false;
            }
            catch (IndexException e) {
                logger.warning("...unable to flush lucene event log: " + e.getMessage());
                return true;
            }
        }
        return true;
    }

    public void rebuildIndex(Directory indexDir) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)new ClassicAnalyzer());
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        IndexWriter indexWriter = new IndexWriter(indexDir, indexWriterConfig);
        indexWriter.close();
        logger.info("...rebuild lucene index job created...");
        ItemCollection job = new ItemCollection();
        job.replaceItemValue("numinterval", (Object)2);
        job.replaceItemValue("job", (Object)"JOB_REBUILD_INDEX");
        this.adminPService.createJob(job);
    }

    public void indexDocuments(Collection<ItemCollection> documents) {
        IndexWriter indexWriter = null;
        DirectoryTaxonomyWriter taxonomyWriter = null;
        long ltime = System.currentTimeMillis();
        try {
            indexWriter = this.createIndexWriter();
            taxonomyWriter = this.createTaxonomyWriter();
            for (ItemCollection workitem : documents) {
                if (workitem.getItemValueBoolean("$noindex")) continue;
                Term term = new Term("$uniqueid", workitem.getItemValueString("$uniqueid"));
                logger.finest("......lucene add/update uncommitted workitem '" + workitem.getItemValueString("$uniqueid") + "' to index...");
                org.apache.lucene.document.Document lucenedoc = this.createDocument(workitem);
                this.updateLuceneIndex(term, lucenedoc, indexWriter, taxonomyWriter);
            }
        }
        catch (IOException luceneEx) {
            logger.warning("lucene error: " + luceneEx.getMessage());
            throw new IndexException("INVALID_INDEX", "Unable to update lucene search index", (Exception)luceneEx);
        }
        finally {
            if (indexWriter != null) {
                logger.finest("......lucene close IndexWriter...");
                try {
                    indexWriter.close();
                }
                catch (CorruptIndexException e) {
                    throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)e);
                }
            }
            if (taxonomyWriter != null) {
                logger.finest("......lucene close taxonomyWriter...");
                try {
                    taxonomyWriter.close();
                }
                catch (CorruptIndexException e) {
                    throw new IndexException("INVALID_INDEX", "Unable to close lucene taxonomyWriter: ", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new IndexException("INVALID_INDEX", "Unable to close lucene taxonomyWriter: ", (Exception)e);
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("... update index block in " + (System.currentTimeMillis() - ltime) + " ms (" + documents.size() + " workitems total)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flushEventLogByCount(int count) {
        Date lastEventDate = null;
        boolean cacheIsEmpty = true;
        DirectoryTaxonomyWriter taxonomyWriter = null;
        IndexWriter indexWriter = null;
        long l = System.currentTimeMillis();
        logger.finest("......flush eventlog cache....");
        List events = this.eventLogService.findEventsByTopic(count + 1, new String[]{"index.add", "index.remove"});
        if (events != null && events.size() > 0) {
            try {
                indexWriter = this.createIndexWriter();
                taxonomyWriter = this.createTaxonomyWriter();
                int _counter = 0;
                for (EventLog eventLogEntry : events) {
                    long l2;
                    Term term = new Term("$uniqueid", eventLogEntry.getRef());
                    Document doc = (Document)this.manager.find(Document.class, (Object)eventLogEntry.getRef());
                    if (doc != null && "index.add".equals(eventLogEntry.getTopic())) {
                        l2 = System.currentTimeMillis();
                        ItemCollection workitem = new ItemCollection();
                        workitem.setAllItems(doc.getData());
                        if (!workitem.getItemValueBoolean("$noindex")) {
                            org.apache.lucene.document.Document lucenedoc = this.createDocument(workitem);
                            this.updateLuceneIndex(term, lucenedoc, indexWriter, taxonomyWriter);
                            logger.finest("......lucene add/update workitem '" + doc.getId() + "' to index in " + (System.currentTimeMillis() - l2) + "ms");
                        }
                    } else {
                        l2 = System.currentTimeMillis();
                        indexWriter.deleteDocuments(new Term[]{term});
                        logger.finest("......lucene remove workitem '" + term + "' from index in " + (System.currentTimeMillis() - l2) + "ms");
                    }
                    lastEventDate = eventLogEntry.getCreated().getTime();
                    this.eventLogService.removeEvent(eventLogEntry);
                    if (++_counter < count) continue;
                    cacheIsEmpty = false;
                    break;
                }
            }
            catch (IOException luceneEx) {
                logger.warning("...unable to flush lucene event log: " + luceneEx.getMessage());
                boolean bl = true;
                return bl;
            }
            finally {
                if (indexWriter != null) {
                    logger.finest("......lucene close IndexWriter...");
                    try {
                        indexWriter.close();
                    }
                    catch (CorruptIndexException e) {
                        throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)((Object)e));
                    }
                    catch (IOException e) {
                        throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)e);
                    }
                }
                if (taxonomyWriter != null) {
                    logger.finest("......lucene close taxoWriter...");
                    try {
                        taxonomyWriter.close();
                    }
                    catch (CorruptIndexException e) {
                        throw new IndexException("INVALID_INDEX", "Unable to close lucene taxonomyWriter: ", (Exception)((Object)e));
                    }
                    catch (IOException e) {
                        throw new IndexException("INVALID_INDEX", "Unable to close lucene taxonomyWriter: ", (Exception)e);
                    }
                }
            }
        }
        logger.fine("...flushEventLog - " + events.size() + " events in " + (System.currentTimeMillis() - l) + " ms - last log entry: " + lastEventDate);
        return cacheIsEmpty;
    }

    private void updateLuceneIndex(Term term, org.apache.lucene.document.Document lucenedoc, IndexWriter indexWriter, DirectoryTaxonomyWriter taxoWriter) throws IOException {
        FacetsConfig config = this.getFacetsConfig();
        indexWriter.updateDocument(term, (Iterable)config.build((TaxonomyWriter)taxoWriter, lucenedoc));
    }

    public FacetsConfig getFacetsConfig() {
        FacetsConfig config = new FacetsConfig();
        return config;
    }

    protected org.apache.lucene.document.Document createDocument(ItemCollection document) {
        String sValue = null;
        org.apache.lucene.document.Document doc = new org.apache.lucene.document.Document();
        String textContent = "";
        List searchFieldList = this.schemaService.getFieldList();
        for (String aFieldname : searchFieldList) {
            sValue = "";
            List vValues = document.getItemValue(aFieldname);
            if (vValues.size() == 0) continue;
            Iterator iterator = vValues.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o == null) continue;
                if (o instanceof Calendar || o instanceof Date) {
                    String sDateValue = o instanceof Calendar ? this.luceneDateFormat.format(((Calendar)o).getTime()) : this.luceneDateFormat.format((Date)o);
                    sValue = sValue + sDateValue + ",";
                    continue;
                }
                sValue = sValue + o.toString() + ",";
            }
            if (sValue == null) continue;
            textContent = textContent + sValue + ",";
        }
        if (this.indexEvents != null) {
            IndexEvent indexEvent = new IndexEvent(1, document);
            indexEvent.setTextContent(textContent);
            this.indexEvents.fire((Object)indexEvent);
            textContent = indexEvent.getTextContent();
        } else {
            logger.warning("Missing CDI support for Event<IndexEvent> !");
        }
        logger.finest("......add lucene field content=" + textContent);
        doc.add((IndexableField)new TextField("content", textContent, Field.Store.NO));
        ArrayList _localFieldListStore = new ArrayList();
        _localFieldListStore.addAll(this.schemaService.getFieldListStore());
        List indexFieldListAnalyze = this.schemaService.getFieldListAnalyze();
        for (Object aFieldname : indexFieldListAnalyze) {
            this.addItemValues(doc, document, (String)aFieldname, true, _localFieldListStore.contains(aFieldname));
            _localFieldListStore.remove(aFieldname);
        }
        List indexFieldListNoAnalyze = this.schemaService.getFieldListNoAnalyze();
        for (Object aFieldname : indexFieldListNoAnalyze) {
            this.addItemValues(doc, document, (String)aFieldname, false, _localFieldListStore.contains(aFieldname));
        }
        doc.add((IndexableField)new StringField("$uniqueid", document.getItemValueString("$uniqueid"), Field.Store.YES));
        List vReadAccess = document.getItemValue("$readaccess");
        if (vReadAccess.size() == 0 || vReadAccess.size() == 1 && "".equals(((String)vReadAccess.get(0)).toString())) {
            sValue = ANONYMOUS;
            doc.add((IndexableField)new StringField("$readaccess", sValue, Field.Store.NO));
        } else {
            sValue = "";
            for (String sReader : vReadAccess) {
                doc.add((IndexableField)new StringField("$readaccess", sReader, Field.Store.NO));
            }
        }
        List indexFieldListCategory = this.schemaService.getFieldListCategory();
        for (String aFieldname : indexFieldListCategory) {
            String value = document.getItemValueString(aFieldname);
            if (value == null || value.isEmpty()) continue;
            doc.add((IndexableField)new FacetField(aFieldname + TAXONOMY_INDEXFIELD_PRAFIX, new String[]{value}));
        }
        return doc;
    }

    protected void addItemValues(org.apache.lucene.document.Document doc, ItemCollection workitem, String _itemName, boolean analyzeValue, boolean store) {
        String itemName = _itemName;
        if (itemName == null) {
            return;
        }
        List vValues = workitem.getItemValue(itemName = itemName.toLowerCase().trim());
        if (vValues.size() == 0) {
            return;
        }
        if (vValues.get(0) == null) {
            return;
        }
        boolean firstValue = true;
        for (Object singleValue : vValues) {
            IndexableField indexableField = null;
            indexableField = store ? this.luceneItemAdapter.adaptItemValue(itemName, singleValue, analyzeValue, Field.Store.YES) : this.luceneItemAdapter.adaptItemValue(itemName, singleValue, analyzeValue, Field.Store.NO);
            doc.add(indexableField);
            if (!analyzeValue && firstValue) {
                SortedDocValuesField sortedDocField = this.luceneItemAdapter.adaptSortableItemValue(itemName, singleValue);
                doc.add((IndexableField)sortedDocField);
            }
            firstValue = false;
        }
    }

    protected IndexWriter createIndexWriter() throws IOException {
        IndexWriterConfig indexWriterConfig;
        logger.finest("......createIndexWriter...");
        Directory indexDir = this.createIndexDirectory();
        try {
            indexWriterConfig = new IndexWriterConfig((Analyzer)Class.forName(this.luceneAnalyzerClass).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IndexException("INVALID_INDEX", "Unable to create analyzer '" + this.luceneAnalyzerClass + "'", (Exception)e);
        }
        return new IndexWriter(indexDir, indexWriterConfig);
    }

    protected DirectoryTaxonomyWriter createTaxonomyWriter() throws IOException {
        logger.finest("......createTaxonomyWriter...");
        Directory taxoDir = this.createTaxonomyDirectory();
        return new DirectoryTaxonomyWriter(taxoDir);
    }

    public Directory createIndexDirectory() throws IOException {
        logger.finest("......create lucene Index Directory - path=" + this.getLuceneIndexDir());
        Path luceneIndexDir = Paths.get(this.getLuceneIndexDir(), new String[0]);
        FSDirectory indexDir = FSDirectory.open((Path)luceneIndexDir);
        if (!DirectoryReader.indexExists((Directory)indexDir)) {
            logger.info("...lucene index directory is empty or does not yet exist, initialize the index now....");
            this.rebuildIndex((Directory)indexDir);
        }
        return indexDir;
    }

    public Directory createTaxonomyDirectory() throws IOException {
        String sPath = this.getLuceneIndexDir();
        if (sPath.endsWith("/")) {
            sPath = sPath.substring(0, sPath.lastIndexOf("/"));
        }
        sPath = sPath + "_tax";
        logger.finest("......create lucene taxonomy Directory - path=" + sPath);
        Path luceneIndexDir = Paths.get(sPath, new String[0]);
        FSDirectory indexDir = FSDirectory.open((Path)luceneIndexDir);
        if (!DirectoryReader.indexExists((Directory)indexDir)) {
            logger.info("...lucene taxonomy directory is empty or does not yet exist, initialize the Taxonomy index now....");
            this.rebuildIndex((Directory)indexDir);
        }
        return indexDir;
    }
}

