/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.lucene;

import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.index.Category;
import org.imixs.workflow.engine.index.DefaultOperator;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.engine.index.SearchService;
import org.imixs.workflow.engine.index.SortOrder;
import org.imixs.workflow.engine.lucene.LuceneIndexService;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
public class LuceneSearchService
implements SearchService {
    public static final int DEFAULT_MAX_SEARCH_RESULT = 9999;
    public static final int DEFAULT_PAGE_SIZE = 100;
    @Inject
    private LuceneIndexService luceneIndexService;
    @Inject
    private DocumentService documentService;
    @Inject
    private SchemaService schemaService;
    private static Logger logger = Logger.getLogger(LuceneSearchService.class.getName());

    public List<ItemCollection> search(String searchTerm, int pageSize, int pageIndex, SortOrder sortOrder, DefaultOperator defaultOperator, boolean loadStubs) throws QueryException {
        boolean debug = logger.isLoggable(Level.FINE);
        long ltime = System.currentTimeMillis();
        if (pageSize <= 0) {
            pageSize = 100;
        }
        if (pageIndex < 0) {
            pageIndex = 0;
        }
        if (debug) {
            logger.finest("......lucene search: pageNumber=" + pageIndex + " pageSize=" + pageSize);
        }
        ArrayList<ItemCollection> workitems = new ArrayList<ItemCollection>();
        if ((searchTerm = this.schemaService.getExtendedSearchTerm(searchTerm)) == null || "".equals(searchTerm)) {
            return workitems;
        }
        try {
            IndexSearcher searcher = this.createIndexSearcher();
            QueryParser parser = this.createQueryParser(defaultOperator);
            parser.setAllowLeadingWildcard(true);
            if (defaultOperator == DefaultOperator.OR) {
                parser.setDefaultOperator(QueryParser.Operator.OR);
            } else {
                parser.setDefaultOperator(QueryParser.Operator.AND);
            }
            long lsearchtime = System.currentTimeMillis();
            TopDocs topDocs = null;
            TopScoreDocCollector collector = null;
            int startIndex = pageIndex * pageSize;
            int maxSearchResult = 9999;
            if (startIndex + pageSize > 9999) {
                maxSearchResult = startIndex + 3 * pageSize;
                logger.warning("PageIndex (" + pageSize + "x" + pageIndex + ") exeeded DEFAULT_MAX_SEARCH_RESULT(" + 9999 + ") -> new MAX_SEARCH_RESULT is set to " + maxSearchResult);
            }
            Query query = parser.parse(searchTerm);
            if (sortOrder != null) {
                if (debug) {
                    logger.finest("......lucene result sorted by sortOrder= '" + sortOrder + "' ");
                }
                collector = TopFieldCollector.create((Sort)this.buildLuceneSort(sortOrder), (int)maxSearchResult, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else {
                if (debug) {
                    logger.finest("......lucene result sorted by score ");
                }
                collector = TopScoreDocCollector.create((int)maxSearchResult);
            }
            searcher.search(query, (Collector)collector);
            topDocs = collector.topDocs(startIndex, pageSize);
            ScoreDoc[] scoreDosArray = topDocs.scoreDocs;
            if (debug) {
                logger.finest("...returned " + scoreDosArray.length + " documents in " + (System.currentTimeMillis() - lsearchtime) + " ms - total hits=" + topDocs.totalHits);
            }
            SimpleDateFormat luceneDateformat = new SimpleDateFormat("yyyyMMddHHmmss");
            for (ScoreDoc scoredoc : scoreDosArray) {
                Document luceneDoc = searcher.doc(scoredoc.doc);
                String sID = luceneDoc.get("$uniqueid");
                ItemCollection imixsDoc = null;
                if (loadStubs) {
                    imixsDoc = this.convertLuceneDocument(luceneDoc, luceneDateformat);
                    imixsDoc.replaceItemValue("$uniqueid", (Object)sID);
                } else {
                    logger.finest("......lucene lookup $uniqueid=" + sID);
                    imixsDoc = this.documentService.load(sID);
                }
                if (imixsDoc != null) {
                    workitems.add(imixsDoc);
                    continue;
                }
                logger.warning("lucene index returned unreadable workitem : " + sID);
                this.documentService.removeDocumentFromIndex(sID);
            }
            searcher.getIndexReader().close();
            if (debug) {
                logger.fine("...search result computed in " + (System.currentTimeMillis() - ltime) + " ms - loadStubs=" + loadStubs);
            }
        }
        catch (IOException e) {
            logger.severe("Lucene index error: " + e.getMessage());
            throw new InvalidAccessException("INVALID_INDEX", e.getMessage(), (Exception)e);
        }
        catch (ParseException e) {
            logger.severe("Lucene search error: " + e.getMessage());
            throw new QueryException("QUERY_NOT_UNDERSTANDABLE", e.getMessage(), (Exception)((Object)e));
        }
        return workitems;
    }

    public List<Category> getTaxonomy(String ... categories) {
        ArrayList<Category> results = new ArrayList<Category>();
        try {
            IndexSearcher searcher = this.createIndexSearcher();
            TaxonomyReader taxoReader = this.createTaxonomyReader();
            FacetsConfig config = this.luceneIndexService.getFacetsConfig();
            FacetsCollector fc = new FacetsCollector();
            searcher.search((Query)new MatchAllDocsQuery(), (Collector)fc);
            FastTaxonomyFacetCounts facets = new FastTaxonomyFacetCounts(taxoReader, config, fc);
            for (String cat : categories) {
                FacetResult facetResult = facets.getTopChildren(10, cat + ".taxonomy", new String[0]);
                if (facetResult == null) continue;
                Category category = new Category(cat, facetResult.childCount);
                for (LabelAndValue lav : facetResult.labelValues) {
                    category.setLabel(lav.label, lav.value.intValue());
                }
                results.add(category);
            }
            searcher.getIndexReader().close();
            taxoReader.close();
        }
        catch (IOException e) {
            logger.severe("Lucene index error: " + e.getMessage());
            throw new InvalidAccessException("INVALID_INDEX", e.getMessage(), (Exception)e);
        }
        return results;
    }

    public int getTotalHits(String _searchTerm, int _maxResult, DefaultOperator defaultOperator) throws QueryException {
        int result;
        String sSearchTerm;
        int maxResult = _maxResult;
        if (maxResult <= 0) {
            maxResult = 9999;
        }
        if ((sSearchTerm = this.schemaService.getExtendedSearchTerm(_searchTerm)) == null || "".equals(sSearchTerm)) {
            return 0;
        }
        try {
            IndexSearcher searcher = this.createIndexSearcher();
            QueryParser parser = this.createQueryParser(defaultOperator);
            parser.setAllowLeadingWildcard(true);
            if (defaultOperator == DefaultOperator.OR) {
                parser.setDefaultOperator(QueryParser.Operator.OR);
            } else {
                parser.setDefaultOperator(QueryParser.Operator.AND);
            }
            TopScoreDocCollector collector = null;
            Query query = parser.parse(sSearchTerm);
            collector = TopScoreDocCollector.create((int)maxResult);
            searcher.search(query, (Collector)collector);
            result = collector.getTotalHits();
            logger.finest("......lucene count result = " + result);
        }
        catch (IOException e) {
            logger.severe("Lucene index error: " + e.getMessage());
            throw new InvalidAccessException("INVALID_INDEX", e.getMessage(), (Exception)e);
        }
        catch (ParseException e) {
            logger.severe("Lucene search error: " + e.getMessage());
            throw new QueryException("QUERY_NOT_UNDERSTANDABLE", e.getMessage(), (Exception)((Object)e));
        }
        return result;
    }

    IndexSearcher createIndexSearcher() throws IOException {
        DirectoryReader reader = null;
        logger.finest("......createIndexSearcher...");
        Directory indexDir = this.luceneIndexService.createIndexDirectory();
        try {
            reader = DirectoryReader.open((Directory)indexDir);
        }
        catch (IOException ioe) {
            logger.warning("lucene index can not be opened: " + ioe.getMessage());
            throw ioe;
        }
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        return searcher;
    }

    TaxonomyReader createTaxonomyReader() throws IOException {
        logger.finest("......createTaxonomyReader...");
        Directory taxoDir = this.luceneIndexService.createTaxonomyDirectory();
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(taxoDir);
        return taxoReader;
    }

    QueryParser createQueryParser(DefaultOperator defaultOperator) {
        QueryParser parser = new QueryParser("content", (Analyzer)new KeywordAnalyzer());
        if (defaultOperator == DefaultOperator.OR) {
            logger.finest("......DefaultOperator: OR");
            parser.setDefaultOperator(QueryParser.Operator.OR);
        } else {
            logger.finest("......DefaultOperator: AND");
            parser.setDefaultOperator(QueryParser.Operator.AND);
        }
        parser.setSplitOnWhitespace(true);
        return parser;
    }

    ItemCollection convertLuceneDocument(Document luceneDoc, SimpleDateFormat luceneDateformat) {
        ItemCollection imixsDoc = new ItemCollection();
        List fields = luceneDoc.getFields();
        for (IndexableField indexableField : fields) {
            Object objectValue = null;
            String stringValue = indexableField.stringValue();
            if (LuceneSearchService.isNumeric(stringValue)) {
                if (stringValue.length() == 14 && !stringValue.contains(".")) {
                    try {
                        objectValue = luceneDateformat.parse(stringValue);
                    }
                    catch (java.text.ParseException parseException) {
                        // empty catch block
                    }
                }
                if (objectValue == null) {
                    try {
                        Number number = NumberFormat.getInstance().parse(stringValue);
                        objectValue = number;
                    }
                    catch (java.text.ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            if (objectValue == null) {
                objectValue = stringValue;
            }
            logger.finest(".........append " + indexableField.name() + " = " + objectValue);
            imixsDoc.appendItemValue(indexableField.name(), objectValue);
        }
        imixsDoc.replaceItemValue("$isAuthor", (Object)this.documentService.isAuthor(imixsDoc));
        return imixsDoc;
    }

    private Sort buildLuceneSort(SortOrder sortOrder) {
        Sort sort = null;
        sort = new Sort(new SortField[]{new SortField(sortOrder.getField(), SortField.Type.STRING, sortOrder.isReverse())});
        return sort;
    }

    private static boolean isNumeric(String str) {
        boolean dot = false;
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (c == '.' && !dot) {
                dot = true;
                continue;
            }
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

