/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.lucene;

import jakarta.ejb.Singleton;
import jakarta.inject.Inject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.index.UpdateService;
import org.imixs.workflow.engine.lucene.LuceneIndexService;

@Singleton
public class LuceneUpdateService
implements UpdateService {
    @Inject
    private LuceneIndexService luceneIndexService;
    private static final Logger logger = Logger.getLogger(LuceneUpdateService.class.getName());

    public void updateIndex(List<ItemCollection> documents) {
        this.luceneIndexService.indexDocuments(documents);
    }

    public void updateIndex() {
        long ltime = System.currentTimeMillis();
        int flushCount = 0;
        while (!this.luceneIndexService.flushEventLog(2048)) {
            flushCount = 2048;
            logger.log(Level.INFO, "...flush event log: {0} entries updated in {1}ms ...", new Object[]{flushCount, System.currentTimeMillis() - ltime});
        }
    }
}

