/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.lucene;

import jakarta.inject.Named;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.imixs.workflow.engine.index.UpdateService;

@Named
public class LuceneItemAdapter {
    private static final Logger logger = Logger.getLogger(UpdateService.class.getName());

    public IndexableField adaptItemValue(String itemName, Object itemValue, boolean doAnalyze) {
        return this.adaptItemValue(itemName, itemValue, doAnalyze, Field.Store.NO);
    }

    public IndexableField adaptItemValue(String itemName, Object itemValue, boolean doAnalyze, Field.Store stored) {
        String stringValue = this.convertItemValue(itemValue);
        logger.log(Level.FINEST, "......lucene add IndexField (analyzed={0}): {1}={2}", new Object[]{doAnalyze, itemName, stringValue});
        if (doAnalyze) {
            return new TextField(itemName, stringValue, stored);
        }
        return new StringField(itemName, stringValue, stored);
    }

    public SortedDocValuesField adaptSortableItemValue(String itemName, Object itemValue) {
        String stringValue = this.convertItemValue(itemValue);
        logger.log(Level.FINEST, "......lucene add sortable IndexValue: {0}={1}", new Object[]{itemName, stringValue});
        return new SortedDocValuesField(itemName, new BytesRef((CharSequence)stringValue));
    }

    public String convertItemValue(Object itemValue) {
        String convertedValue = "";
        if (itemValue instanceof Calendar || itemValue instanceof Date) {
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
            String sDateValue = itemValue instanceof Calendar ? dateformat.format(((Calendar)itemValue).getTime()) : dateformat.format((Date)itemValue);
            convertedValue = sDateValue;
        } else {
            convertedValue = itemValue.toString();
        }
        return convertedValue;
    }
}

