/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.solr;

import java.util.List;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.index.UpdateService;
import org.imixs.workflow.engine.solr.SolrIndexService;
import org.imixs.workflow.exceptions.IndexException;
import org.imixs.workflow.services.rest.RestAPIException;

@Stateless
public class SolrUpdateService
implements UpdateService {
    @Inject
    SolrIndexService solrIndexService;
    private static Logger logger = Logger.getLogger(SolrUpdateService.class.getName());

    public void updateIndex(List<ItemCollection> documents) {
        try {
            this.solrIndexService.indexDocuments(documents);
        }
        catch (RestAPIException e) {
            logger.severe("Failed to update document collection: " + e.getMessage());
            throw new IndexException("INVALID_INDEX", "Unable to update solr search index", (Exception)((Object)e));
        }
    }

    public void updateIndex() {
        long ltime = System.currentTimeMillis();
        int flushCount = 0;
        while (!this.solrIndexService.flushEventLog(2048)) {
            flushCount = 2048;
            logger.info("...flush event log: " + flushCount + " entries updated in " + (System.currentTimeMillis() - ltime) + "ms ...");
        }
    }
}

