/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.solr;

import java.io.Reader;
import java.io.StringReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonParser;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.index.DefaultOperator;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.engine.index.SearchService;
import org.imixs.workflow.engine.index.SortOrder;
import org.imixs.workflow.engine.solr.SolrIndexService;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.util.JSONParser;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
public class SolrSearchService
implements SearchService {
    public static final int DEFAULT_MAX_SEARCH_RESULT = 9999;
    public static final int DEFAULT_PAGE_SIZE = 100;
    @Inject
    @ConfigProperty(name="solr.core", defaultValue="imixs-workflow")
    private String core;
    @Inject
    private SchemaService schemaService;
    @Inject
    private SolrIndexService solarIndexService;
    @Inject
    private DocumentService documentService;
    private static Logger logger = Logger.getLogger(SolrSearchService.class.getName());
    private SimpleDateFormat luceneDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    public List<ItemCollection> search(String _searchTerm, int pageSize, int pageIndex, SortOrder sortOrder, DefaultOperator defaultOperator, boolean loadStubs) throws QueryException {
        boolean debug = logger.isLoggable(Level.FINE);
        long ltime = System.currentTimeMillis();
        if (pageSize <= 0) {
            pageSize = 100;
        }
        if (pageIndex < 0) {
            pageIndex = 0;
        }
        if (debug) {
            logger.finest("......solr search: pageNumber=" + pageIndex + " pageSize=" + pageSize);
        }
        ArrayList<ItemCollection> workitems = new ArrayList<ItemCollection>();
        String searchTerm = this.adaptSearchTerm(_searchTerm);
        if (searchTerm == null || "".equals(searchTerm)) {
            return workitems;
        }
        String result = this.solarIndexService.query(searchTerm, pageSize, pageIndex, sortOrder, defaultOperator, loadStubs);
        if (debug) {
            logger.finest("......Result = " + result);
        }
        if (result != null && !result.isEmpty()) {
            List<ItemCollection> documentStubs = this.parseQueryResult(result);
            if (loadStubs) {
                workitems.addAll(documentStubs);
            } else {
                for (ItemCollection stub : documentStubs) {
                    ItemCollection document = this.documentService.load(stub.getUniqueID());
                    if (document == null) continue;
                    workitems.add(document);
                }
            }
        }
        if (debug) {
            logger.fine("...search result computed in " + (System.currentTimeMillis() - ltime) + " ms - loadStubs=" + loadStubs);
        }
        return workitems;
    }

    public int getTotalHits(String _searchTerm, int _maxResult, DefaultOperator defaultOperator) throws QueryException {
        long l = System.currentTimeMillis();
        int hits = 0;
        String searchTerm = this.adaptSearchTerm(_searchTerm);
        if (searchTerm == null || "".equals(searchTerm)) {
            return 0;
        }
        String result = this.solarIndexService.query(searchTerm, 0, 0, null, defaultOperator, true);
        try {
            String response = JSONParser.getKey((String)"response", (String)result);
            hits = Integer.parseInt(JSONParser.getKey((String)"numFound", (String)response));
        }
        catch (NumberFormatException e) {
            logger.severe("getTotalHits - failed to parse solr result object! - " + e.getMessage());
            hits = 0;
        }
        logger.info("......computed totalHits in " + (System.currentTimeMillis() - l) + "ms");
        return hits;
    }

    protected List<ItemCollection> parseQueryResult(String json) {
        boolean debug = logger.isLoggable(Level.FINE);
        long l = System.currentTimeMillis();
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        JsonParser parser = Json.createParser((Reader)new StringReader(json));
        JsonParser.Event event = null;
        try {
            while ((event = parser.next()) != null) {
                String jsonkey;
                if (!event.name().equals(JsonParser.Event.KEY_NAME.toString()) || !"docs".equals(jsonkey = parser.getString()) || !(event = parser.next()).name().equals(JsonParser.Event.START_ARRAY.toString())) continue;
                event = parser.next();
                while (event.name().equals(JsonParser.Event.START_OBJECT.toString())) {
                    if (debug) {
                        logger.finest("......parse doc....");
                    }
                    ItemCollection itemCol = this.parseDoc(parser);
                    result.add(itemCol);
                    event = parser.next();
                }
                if (!event.name().equals(JsonParser.Event.END_ARRAY.toString())) continue;
                break;
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        if (debug) {
            logger.finest("......total parsing time " + (System.currentTimeMillis() - l) + "ms");
        }
        return result;
    }

    private ItemCollection parseDoc(JsonParser parser) {
        boolean debug = logger.isLoggable(Level.FINE);
        ItemCollection document = new ItemCollection();
        JsonParser.Event event = null;
        event = parser.next();
        while (event.name().equals(JsonParser.Event.KEY_NAME.toString())) {
            String itemName = parser.getString();
            if (debug) {
                logger.finest("......found item " + itemName);
            }
            List<Object> itemValue = this.parseItem(parser);
            itemName = this.solarIndexService.adaptSolrFieldName(itemName);
            document.replaceItemValue(itemName, itemValue);
            event = parser.next();
        }
        return document;
    }

    private List<Object> parseItem(JsonParser parser) {
        ArrayList<Object> result = new ArrayList<Object>();
        JsonParser.Event event = null;
        event = parser.next();
        if (event.name().equals(JsonParser.Event.START_ARRAY.toString())) {
            do {
                if ((event = parser.next()).name().equals(JsonParser.Event.VALUE_STRING.toString())) {
                    result.add(this.convertLuceneValue(parser.getString()));
                }
                if (event.name().equals(JsonParser.Event.VALUE_NUMBER.toString())) {
                    result.add(this.convertLuceneValue(parser.getString()));
                }
                if (event.name().equals(JsonParser.Event.VALUE_TRUE.toString())) {
                    result.add(true);
                }
                if (!event.name().equals(JsonParser.Event.VALUE_FALSE.toString())) continue;
                result.add(false);
            } while (!event.name().equals(JsonParser.Event.END_ARRAY.toString()));
        }
        if (event.name().equals(JsonParser.Event.VALUE_STRING.toString())) {
            result.add(parser.getString());
        }
        if (event.name().equals(JsonParser.Event.VALUE_NUMBER.toString())) {
            result.add(parser.getBigDecimal());
        }
        if (event.name().equals(JsonParser.Event.VALUE_TRUE.toString())) {
            result.add(true);
        }
        if (event.name().equals(JsonParser.Event.VALUE_FALSE.toString())) {
            result.add(false);
        }
        return result;
    }

    private Object convertLuceneValue(String stringValue) {
        Object objectValue = null;
        if (SolrSearchService.isNumeric(stringValue)) {
            if (stringValue.length() == 14 && !stringValue.contains(".")) {
                try {
                    objectValue = this.luceneDateFormat.parse(stringValue);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (objectValue == null) {
                try {
                    Number number = NumberFormat.getInstance().parse(stringValue);
                    objectValue = number;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if (objectValue == null) {
            objectValue = stringValue;
        }
        return objectValue;
    }

    private static boolean isNumeric(String str) {
        boolean dot = false;
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (c == '.' && !dot) {
                dot = true;
                continue;
            }
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private String adaptSearchTerm(String _serachTerm) throws QueryException {
        if (_serachTerm == null || "".equals(_serachTerm)) {
            return _serachTerm;
        }
        String searchTerm = this.schemaService.getExtendedSearchTerm(_serachTerm);
        searchTerm = this.adaptQueryFieldNames(searchTerm);
        return searchTerm;
    }

    private String adaptQueryFieldNames(String _query) {
        String result = _query;
        if (this.schemaService == null) {
            return result;
        }
        if (_query == null || !_query.contains("$")) {
            return result;
        }
        for (String imixsItemName : this.schemaService.getUniqueFieldList()) {
            if (imixsItemName.charAt(0) != '$') continue;
            while (result.contains(imixsItemName + ":")) {
                String solrField = "_" + imixsItemName.substring(1);
                result = result.replace(imixsItemName + ":", solrField + ":");
            }
        }
        return result;
    }
}

