/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.solr;

import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.LocalBean;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.engine.solr.SolrUpdateService;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Startup
@Singleton
@LocalBean
public class SolrAutoFlushScheduler {
    public static final String SOLR_AUTOFLUSH_DISABLED = "solr.autoflush.disabled";
    public static final String SOLR_AUTOFLUSH_INTERVAL = "solr.autoflush.interval";
    public static final String SOLR_AUTOFLUSH_INITIALDELAY = "solr.autoflush.initialdelay";
    @Inject
    @ConfigProperty(name="solr.autoflush.disabled", defaultValue="false")
    boolean flushDisabled;
    @Inject
    @ConfigProperty(name="solr.autoflush.interval", defaultValue="2000")
    long interval;
    @Inject
    @ConfigProperty(name="solr.autoflush.initialdelay", defaultValue="0")
    long initialDelay;
    private static Logger logger = Logger.getLogger(SolrAutoFlushScheduler.class.getName());
    @Resource
    ManagedScheduledExecutorService scheduler;
    @Inject
    SolrUpdateService solrUpdateService;

    @PostConstruct
    public void init() {
        if (!this.flushDisabled) {
            logger.info("Starting Solr auto flush - initalDelay=" + this.initialDelay + "  inverval=" + this.interval + " ....");
            this.scheduler.scheduleAtFixedRate(this::run, this.initialDelay, this.interval, TimeUnit.MILLISECONDS);
        }
    }

    public void run() {
        this.solrUpdateService.updateIndex();
    }
}

