/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.solr;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.index.UpdateService;
import org.imixs.workflow.engine.solr.SolrIndexService;
import org.imixs.workflow.exceptions.IndexException;
import org.imixs.workflow.services.rest.RestAPIException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
public class SolrUpdateService
implements UpdateService {
    public static final String SOLR_AUTOFLUSH_DISABLED = "solr.autoflush.disabled";
    public static final String SOLR_AUTOFLUSH_INTERVAL = "solr.autoflush.interval";
    public static final String SOLR_AUTOFLUSH_INITIALDELAY = "solr.autoflush.initialdelay";
    @Inject
    SolrIndexService solrIndexService;
    private static Logger logger = Logger.getLogger(SolrUpdateService.class.getName());

    public void updateIndex(List<ItemCollection> documents) {
        try {
            this.solrIndexService.indexDocuments(documents);
        }
        catch (RestAPIException e) {
            logger.severe("Failed to update document collection: " + e.getMessage());
            throw new IndexException("INVALID_INDEX", "Unable to update solr search index", (Exception)((Object)e));
        }
    }

    public void updateIndex() {
        boolean debug = logger.isLoggable(Level.FINE);
        long ltime = System.currentTimeMillis();
        int flushCount = 0;
        while (!this.solrIndexService.flushEventLog(1024)) {
            flushCount = 1048;
            if (!debug) continue;
            logger.fine("...flush event log: " + flushCount + " entries updated in " + (System.currentTimeMillis() - ltime) + "ms ...");
        }
        if (debug) {
            logger.fine("...flush solr index completed in " + (System.currentTimeMillis() - ltime) + "ms ...");
        }
    }
}

