/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.solr;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.Singleton;
import jakarta.ejb.Startup;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.engine.solr.SolrUpdateService;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Startup
@Singleton
public class SolrAutoFlushScheduler {
    public static final String SOLR_AUTOFLUSH_DISABLED = "solr.autoflush.disabled";
    public static final String SOLR_AUTOFLUSH_INTERVAL = "solr.autoflush.interval";
    public static final String SOLR_AUTOFLUSH_INITIALDELAY = "solr.autoflush.initialdelay";
    @Inject
    @ConfigProperty(name="solr.autoflush.disabled", defaultValue="false")
    boolean flushDisabled;
    @Inject
    @ConfigProperty(name="solr.autoflush.interval", defaultValue="2000")
    long interval;
    @Inject
    @ConfigProperty(name="solr.autoflush.initialdelay", defaultValue="0")
    long initialDelay;
    private static final Logger logger = Logger.getLogger(SolrAutoFlushScheduler.class.getName());
    @Resource
    ManagedScheduledExecutorService scheduler;
    @Inject
    SolrUpdateService solrUpdateService;

    @PostConstruct
    public void init() {
        if (!this.flushDisabled) {
            logger.log(Level.INFO, "Starting Solr auto flush - initalDelay={0}  inverval={1} ....", new Object[]{this.initialDelay, this.interval});
            this.scheduler.scheduleAtFixedRate(this::run, this.initialDelay, this.interval, TimeUnit.MILLISECONDS);
        }
    }

    public void run() {
        this.solrUpdateService.updateIndex();
    }
}

