/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.solr;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.IntPredicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.EventLogService;
import org.imixs.workflow.engine.SetupEvent;
import org.imixs.workflow.engine.adminp.AdminPService;
import org.imixs.workflow.engine.index.DefaultOperator;
import org.imixs.workflow.engine.index.IndexEvent;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.engine.index.SortOrder;
import org.imixs.workflow.engine.jpa.Document;
import org.imixs.workflow.engine.jpa.EventLog;
import org.imixs.workflow.exceptions.IndexException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.services.rest.BasicAuthenticator;
import org.imixs.workflow.services.rest.RequestFilter;
import org.imixs.workflow.services.rest.RestAPIException;
import org.imixs.workflow.services.rest.RestClient;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
public class SolrIndexService {
    public static final String ANONYMOUS = "ANONYMOUS";
    public static final int EVENTLOG_ENTRY_FLUSH_COUNT = 16;
    public static final String DEFAULT_SEARCH_FIELD = "_text_";
    public static final int DEFAULT_MAX_SEARCH_RESULT = 9999;
    public static final int DEFAULT_PAGE_SIZE = 100;
    @Inject
    @ConfigProperty(name="solr.api", defaultValue="http://solr:8983")
    private String api;
    @Inject
    @ConfigProperty(name="solr.core", defaultValue="imixs-workflow")
    private String core;
    @Inject
    @ConfigProperty(name="solr.configset", defaultValue="_default")
    private String configset;
    @Inject
    @ConfigProperty(name="solr.user")
    private Optional<String> user;
    @Inject
    @ConfigProperty(name="solr.password")
    private Optional<String> password;
    @Inject
    private SchemaService schemaService;
    @Inject
    private EventLogService eventLogService;
    @Inject
    private AdminPService adminPService;
    @Inject
    protected Event<IndexEvent> indexEvents;
    @PersistenceContext(unitName="org.imixs.workflow.jpa")
    EntityManager manager;
    private RestClient restClient;
    private static final Logger logger = Logger.getLogger(SolrIndexService.class.getName());

    @PostConstruct
    public void init() {
        this.restClient = new RestClient(this.api);
        if (this.user.isPresent() && !this.user.get().isEmpty()) {
            BasicAuthenticator authenticator = new BasicAuthenticator(this.user.get(), this.password.get());
            this.restClient.registerRequestFilter((RequestFilter)authenticator);
        }
    }

    public void setup(@Observes SetupEvent setupEvent) throws RestAPIException {
        logger.log(Level.INFO, "...verify solr core ''{0}''...", this.core);
        try {
            String existingSchema = this.restClient.get(this.api + "/api/cores/" + this.core + "/schema");
            logger.info("...core   - OK ");
            this.updateSchema(existingSchema);
        }
        catch (RestAPIException e) {
            logger.log(Level.SEVERE, "...no solr core ''{0}'' found - {1}: verify the solr instance!", new Object[]{this.core, e.getMessage()});
            throw e;
        }
    }

    public void updateSchema(String schema) throws RestAPIException {
        boolean debug = logger.isLoggable(Level.FINE);
        String schemaUpdate = this.buildUpdateSchema(schema);
        if (!"{}".equals(schemaUpdate)) {
            String uri = this.api + "/api/cores/" + this.core + "/schema";
            logger.log(Level.INFO, "...updating schema ''{0}'':", this.core);
            if (debug) {
                logger.log(Level.FINEST, "...{0}", schemaUpdate);
            }
            this.restClient.post(uri, schemaUpdate, "application/json");
            logger.info("...schema update - successfull ");
            this.rebuildIndex();
        } else {
            logger.info("...schema - OK ");
        }
    }

    public void indexDocuments(List<ItemCollection> documents) throws RestAPIException {
        long ltime = System.currentTimeMillis();
        boolean debug = logger.isLoggable(Level.FINE);
        if (documents == null || documents.size() == 0) {
            return;
        }
        String xmlRequest = this.buildAddDoc(documents);
        if (debug) {
            logger.finest(xmlRequest);
        }
        String uri = this.api + "/solr/" + this.core + "/update?commit=true";
        this.restClient.post(uri, xmlRequest, "text/xml");
        if (debug) {
            logger.log(Level.FINE, "... update index block in {0} ms ({1} workitems total)", new Object[]{System.currentTimeMillis() - ltime, documents.size()});
        }
    }

    public void indexDocument(ItemCollection document) throws RestAPIException {
        ArrayList<ItemCollection> col = new ArrayList<ItemCollection>();
        col.add(document);
        this.indexDocuments(col);
    }

    public void removeDocuments(List<String> documentIDs) throws RestAPIException {
        boolean debug = logger.isLoggable(Level.FINE);
        long ltime = System.currentTimeMillis();
        if (documentIDs == null || documentIDs.size() == 0) {
            return;
        }
        StringBuffer xmlDelete = new StringBuffer();
        xmlDelete.append("<delete>");
        for (String id : documentIDs) {
            xmlDelete.append("<id>" + id + "</id>");
        }
        xmlDelete.append("</delete>");
        String xmlRequest = xmlDelete.toString();
        String uri = this.api + "/solr/" + this.core + "/update?commit=true";
        if (debug) {
            logger.log(Level.FINEST, "......delete documents ''{0}'':", this.core);
        }
        this.restClient.post(uri, xmlRequest, "text/xml");
        if (debug) {
            logger.log(Level.FINE, "... update index block in {0} ms ({1} workitems total)", new Object[]{System.currentTimeMillis() - ltime, documentIDs.size()});
        }
    }

    public void removeDocument(String id) throws RestAPIException {
        ArrayList<String> col = new ArrayList<String>();
        col.add(id);
        this.removeDocuments(col);
    }

    public void rebuildIndex() {
        logger.info("...rebuild lucene index job created...");
        ItemCollection job = new ItemCollection();
        job.replaceItemValue("numinterval", (Object)2);
        job.replaceItemValue("job", (Object)"JOB_REBUILD_INDEX");
        this.adminPService.createJob(job);
    }

    public String query(String searchTerm, int pageSize, int pageIndex, SortOrder sortOrder, DefaultOperator defaultOperator, boolean loadStubs) throws QueryException {
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug) {
            logger.log(Level.FINE, "...search solr index: {0}...", searchTerm);
        }
        StringBuffer uri = new StringBuffer();
        try {
            uri.append(this.api + "/solr/" + this.core + "/query");
            if (defaultOperator == DefaultOperator.OR) {
                uri.append("?q.op=" + String.valueOf(defaultOperator));
            } else {
                uri.append("?q.op=AND");
            }
            if (sortOrder != null) {
                Object sortField = sortOrder.getField();
                if (((String)sortField).startsWith("$")) {
                    sortField = "_" + ((String)sortField).substring(1);
                }
                if (sortOrder.isReverse()) {
                    uri.append("&sort=" + (String)sortField + "%20desc");
                } else {
                    uri.append("&sort=" + (String)sortField + "%20asc");
                }
            }
            if (pageSize < 0) {
                pageSize = 100;
            }
            if (pageIndex < 0) {
                pageIndex = 0;
            }
            uri.append("&rows=" + pageSize);
            if (pageIndex > 0) {
                uri.append("&start=" + pageIndex * pageSize);
            }
            if (!loadStubs) {
                uri.append("&fl=_uniqueid");
            }
            uri.append("&q=" + URLEncoder.encode(searchTerm, "UTF-8"));
            if (debug) {
                logger.log(Level.FINEST, "...... uri={0}", uri.toString());
            }
            String result = this.restClient.get(uri.toString());
            return result;
        }
        catch (UnsupportedEncodingException | RestAPIException e) {
            logger.log(Level.SEVERE, "Solr search error: {0}", e.getMessage());
            throw new QueryException("QUERY_NOT_UNDERSTANDABLE", e.getMessage(), (Exception)e);
        }
    }

    public String adaptSolrFieldName(String itemName) {
        if (itemName == null || itemName.isEmpty() || this.schemaService == null) {
            return itemName;
        }
        if (itemName.charAt(0) == '_') {
            String adaptedName = "$" + itemName.substring(1);
            if (this.schemaService.getUniqueFieldList().contains(adaptedName)) {
                return adaptedName;
            }
        }
        return itemName;
    }

    public String adaptImixsItemName(String itemName) {
        if (itemName == null || itemName.isEmpty() || this.schemaService == null) {
            return itemName;
        }
        if (itemName.charAt(0) == '$' && this.schemaService.getUniqueFieldList().contains(itemName)) {
            String adaptedName = "_" + itemName.substring(1);
            return adaptedName;
        }
        return itemName;
    }

    protected String buildUpdateSchema(String oldSchema) {
        boolean store;
        boolean debug = logger.isLoggable(Level.FINE);
        StringBuffer updateSchema = new StringBuffer();
        List fieldListStore = this.schemaService.getFieldListStore();
        List fieldListAnalyze = this.schemaService.getFieldListAnalyze();
        List fieldListNoAnalyze = this.schemaService.getFieldListNoAnalyze();
        oldSchema = oldSchema.replace(" ", "");
        if (debug) {
            logger.log(Level.FINEST, "......old schema={0}", oldSchema);
        }
        updateSchema.append("{");
        this.addFieldDefinitionToUpdateSchema(updateSchema, oldSchema, DEFAULT_SEARCH_FIELD, "text_general", false, false);
        for (String field : fieldListAnalyze) {
            store = fieldListStore.contains(field);
            this.addFieldDefinitionToUpdateSchema(updateSchema, oldSchema, field, "text_general", store, false);
        }
        for (String field : fieldListNoAnalyze) {
            store = fieldListStore.contains(field);
            this.addFieldDefinitionToUpdateSchema(updateSchema, oldSchema, field, "strings", store, true);
        }
        this.addFieldDefinitionToUpdateSchema(updateSchema, oldSchema, "$uniqueid", "string", true, false);
        this.addFieldDefinitionToUpdateSchema(updateSchema, oldSchema, "$readaccess", "strings", true, true);
        int lastComma = updateSchema.lastIndexOf(",");
        if (lastComma > -1) {
            updateSchema.deleteCharAt(lastComma);
        }
        updateSchema.append("}");
        return updateSchema.toString();
    }

    protected String buildAddDoc(List<ItemCollection> documents) {
        boolean debug = logger.isLoggable(Level.FINE);
        List fieldList = this.schemaService.getFieldList();
        List fieldListAnalyze = this.schemaService.getFieldListAnalyze();
        List fieldListNoAnalyze = this.schemaService.getFieldListNoAnalyze();
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
        StringBuffer xmlContent = new StringBuffer();
        xmlContent.append("<add overwrite=\"true\">");
        for (ItemCollection document : documents) {
            if (document.getUniqueID().isEmpty()) continue;
            xmlContent.append("<doc>");
            xmlContent.append("<field name=\"id\">" + document.getUniqueID() + "</field>");
            Object textContent = "";
            for (String field : fieldList) {
                Object sValue = "";
                List vValues = document.getItemValue(field);
                if (vValues.size() == 0) continue;
                for (Object o : vValues) {
                    if (o == null) continue;
                    if (o instanceof Calendar || o instanceof Date) {
                        String sDateValue = o instanceof Calendar ? dateformat.format(((Calendar)o).getTime()) : dateformat.format((Date)o);
                        sValue = (String)sValue + sDateValue + ",";
                        continue;
                    }
                    sValue = (String)sValue + o.toString() + ",";
                }
                if (sValue == null) continue;
                textContent = (String)textContent + (String)sValue + ",";
            }
            if (this.indexEvents != null) {
                IndexEvent indexEvent = new IndexEvent(1, document);
                indexEvent.setTextContent((String)textContent);
                this.indexEvents.fire((Object)indexEvent);
                textContent = indexEvent.getTextContent();
            } else {
                logger.warning("Missing CDI support for Event<IndexEvent> !");
            }
            if (debug) {
                logger.log(Level.FINEST, "......add index field _text_={0}", textContent);
            }
            textContent = this.stripCDATA((String)textContent);
            textContent = this.stripControlCodes((String)textContent);
            xmlContent.append("<field name=\"_text_\"><![CDATA[" + (String)textContent + "]]></field>");
            for (String aFieldname : fieldListAnalyze) {
                this.addFieldValuesToUpdateRequest(xmlContent, aFieldname, document.getItemValue(aFieldname));
            }
            for (String aFieldname : fieldListNoAnalyze) {
                this.addFieldValuesToUpdateRequest(xmlContent, aFieldname, document.getItemValue(aFieldname));
            }
            this.addFieldValuesToUpdateRequest(xmlContent, "$uniqueid", document.getItemValue("$uniqueid"));
            ArrayList<String> vReadAccess = document.getItemValue("$readaccess");
            if (vReadAccess.size() == 0 || vReadAccess.size() == 1 && "".equals(((String)vReadAccess.get(0)).toString())) {
                vReadAccess = new ArrayList<String>();
                vReadAccess.add(ANONYMOUS);
            }
            this.addFieldValuesToUpdateRequest(xmlContent, "$readaccess", vReadAccess);
            xmlContent.append("</doc>");
        }
        xmlContent.append("</add>");
        return xmlContent.toString();
    }

    protected String stripControlCodes(String s) {
        IntPredicate include = c -> c > 31 && c != 127;
        return s.codePoints().filter(include::test).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    protected String stripCDATA(String s) {
        if (s.contains("<![CDATA[")) {
            String result = s.replaceAll("<!\\[CDATA\\[", "");
            result = result.replaceAll("]]>", "");
            return result;
        }
        return s;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean flushEventLogByCount(int count) {
        List events;
        boolean debug = logger.isLoggable(Level.FINE);
        Date lastEventDate = null;
        boolean cacheIsEmpty = true;
        long l = System.currentTimeMillis();
        if (debug) {
            logger.finest("......flush eventlog cache....");
        }
        if ((events = this.eventLogService.findEventsByTopic(count + 1, new String[]{"index.add", "index.remove"})) != null && events.size() > 0) {
            try {
                int _counter = 0;
                for (EventLog eventLogEntry : events) {
                    Document doc = (Document)this.manager.find(Document.class, (Object)eventLogEntry.getRef());
                    if (doc != null && "index.add".equals(eventLogEntry.getTopic())) {
                        l2 = System.currentTimeMillis();
                        ItemCollection workitem = new ItemCollection();
                        workitem.setAllItems(doc.getData());
                        if (!workitem.getItemValueBoolean("$noindex")) {
                            this.indexDocument(workitem);
                            if (debug) {
                                logger.log(Level.FINEST, "......solr added workitem ''{0}'' to index in {1}ms", new Object[]{eventLogEntry.getRef(), System.currentTimeMillis() - l2});
                            }
                        }
                    } else {
                        l2 = System.currentTimeMillis();
                        this.removeDocument(eventLogEntry.getRef());
                        if (debug) {
                            logger.log(Level.FINEST, "......solr removed workitem ''{0}'' from index in {1}ms", new Object[]{eventLogEntry.getRef(), System.currentTimeMillis() - l2});
                        }
                    }
                    lastEventDate = eventLogEntry.getCreated().getTime();
                    this.eventLogService.removeEvent(eventLogEntry);
                    if (++_counter < count) continue;
                    cacheIsEmpty = false;
                    break;
                }
            }
            catch (RestAPIException e) {
                logger.log(Level.WARNING, "...unable to flush lucene event log: {0}", e.getMessage());
                return true;
            }
        }
        if (debug) {
            logger.log(Level.FINE, "...flushEventLog - {0} events in {1} ms - last log entry: {2}", new Object[]{events.size(), System.currentTimeMillis() - l, lastEventDate});
        }
        return cacheIsEmpty;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean flushEventLog(int junkSize) {
        boolean debug = logger.isLoggable(Level.FINE);
        long total = 0L;
        long count = 0L;
        boolean dirtyIndex = true;
        long l = System.currentTimeMillis();
        while (dirtyIndex) {
            try {
                dirtyIndex = !this.flushEventLogByCount(16);
                if (!dirtyIndex) continue;
                total += 16L;
                if ((count += 16L) >= 100L && debug) {
                    logger.log(Level.FINEST, "...flush event log: {0} entries in {1}ms...", new Object[]{total, System.currentTimeMillis() - l});
                    count = 0L;
                }
                if (total < (long)junkSize) continue;
                if (debug) {
                    logger.log(Level.FINEST, "...flush event: Issue #439  -> total count >={0} flushEventLog will be continued...", total);
                }
                return false;
            }
            catch (IndexException e) {
                logger.log(Level.WARNING, "...unable to flush lucene event log: {0}", e.getMessage());
                return true;
            }
        }
        return true;
    }

    private void addFieldDefinitionToUpdateSchema(StringBuffer updateSchema, String oldSchema, String _name, String type, boolean store, boolean docvalue) {
        String name = this.adaptImixsItemName(_name);
        String fieldDefinition = "{\"name\":\"" + name + "\",\"type\":\"" + type + "\",\"stored\":" + store + ",\"docValues\":" + docvalue + "}";
        String testSchemaField = "{\"name\":\"" + name + "\",";
        if (oldSchema == null || !oldSchema.contains(testSchemaField)) {
            updateSchema.append("\"add-field\":" + fieldDefinition + ",");
        } else if (!oldSchema.contains(fieldDefinition)) {
            updateSchema.append("\"replace-field\":" + fieldDefinition + ",");
        }
    }

    private void addFieldValuesToUpdateRequest(StringBuffer xmlContent, String _itemName, List<?> vValues) {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
        if (_itemName == null) {
            return;
        }
        if (vValues.size() == 0) {
            return;
        }
        if (vValues.get(0) == null) {
            return;
        }
        String itemName = _itemName.toLowerCase().trim();
        for (Object singleValue : vValues) {
            Object convertedValue = "";
            if (singleValue instanceof Calendar || singleValue instanceof Date) {
                String sDateValue = singleValue instanceof Calendar ? dateformat.format(((Calendar)singleValue).getTime()) : dateformat.format((Date)singleValue);
                convertedValue = sDateValue;
            } else {
                convertedValue = singleValue.toString();
            }
            convertedValue = this.stripCDATA((String)convertedValue);
            convertedValue = this.stripControlCodes((String)convertedValue);
            convertedValue = "<![CDATA[" + this.stripControlCodes((String)convertedValue) + "]]>";
            xmlContent.append("<field name=\"" + this.adaptImixsItemName(itemName) + "\">" + (String)convertedValue + "</field>");
        }
    }
}

