package org.imixs.workflow.jaxrs;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItemCollection;

/**
 * This MessageBodyWriter generates an HTML representation from a Entitycollection
 * 
 * @author rsoika
 *
 */
@Provider
@Produces("text/html")
public class EntityCollectionWriter implements MessageBodyWriter<EntityCollection> {

	public boolean isWriteable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return EntityCollection.class.isAssignableFrom(type);
	}

	public void writeTo(EntityCollection entityCollection, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders,
			OutputStream entityStream) throws IOException,
			WebApplicationException {
		BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(
				entityStream));
		
		
		
		bw.write("<html>");
		XMLItemCollectionWriter.printHead(bw);
		bw.write("<body>");
		try {
			bw.write("<h1>EntityCollection</h1>");
			bw.write("<h2>" + entityCollection.getEntity().length + " Entries</h2>");

			for (XMLItemCollection xmlworkItem : entityCollection.getEntity()) {
				XMLItemCollectionWriter.printXMLItemCollectionHTML(bw, xmlworkItem);

			}
		} catch (Exception e) {
			bw.write("ERROR<br>");
			//e.printStackTrace(bw.);
		}
		

		bw.write("</body>");
		bw.write("</html>");
		
		bw.flush();
	}

	public long getSize(EntityCollection arg0, Class<?> arg1, Type arg2,
			Annotation[] arg3, MediaType arg4) {
		return -1;
	}

	
	
	

	
	
	
}
