package org.imixs.workflow.jaxrs;

import java.util.Collection;
import java.util.List;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItemCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;

/**
 * The WorkflowService Handler supports methods to process different kind of
 * request URIs
 * 
 * @author rsoika
 * 
 */
@Path("/model")
@Produces( { "text/html", "application/xml", "application/json" })
@Stateless
public class ModelRestService {

	@EJB
	org.imixs.workflow.jee.ejb.EntityService entityService;

	@EJB
	org.imixs.workflow.jee.ejb.ModelService modelService;

	@GET
	@Produces("application/xml")
	public String getAllVersions() {
		List<String> col = null;
		StringBuffer sb = new StringBuffer();
		sb.append("<model>");
		try {
			col = modelService.getAllModelVersions();

			for (String aversion : col) {
				sb.append("<version>" + aversion + "</version>");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		sb.append("</model>");
		return sb.toString();
	}

	@GET
	@Path("/{version}")
	public EntityCollection getProcessList(@PathParam("version") String version) {
		Collection<ItemCollection> col = null;
		try {

			col = modelService.getProcessEntityListByVersion(version);
			return XMLItemCollectionAdapter.putCollection(col);

		} catch (Exception e) {
			e.printStackTrace();
		}
		return new EntityCollection();
	}

	@GET
	@Path("/{version}.xml")
	@Produces("application/xml")
	public EntityCollection getProcessListXML(
			@PathParam("version") String version) {
		return getProcessList(version);
	}

	@GET
	@Path("/{version}/{processid}")
	public EntityCollection getActivityList(
			@PathParam("version") String version,
			@PathParam("processid") int processid) {
		Collection<ItemCollection> col = null;
		try {
			col = modelService.getActivityEntityListByVersion(processid,
					version);
			return XMLItemCollectionAdapter.putCollection(col);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return new EntityCollection();
	}

	@GET
	@Path("/{version}/{processid}.xml")
	@Produces("application/xml")
	public EntityCollection getActivityListXML(
			@PathParam("version") String version,
			@PathParam("processid") int processid) {
		return getActivityList(version, processid);
	}

	@DELETE
	@Path("/{version}")
	public void deleteModel(@PathParam("version") String version) {
		try {
			modelService.removeModelVersion(version);
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/**
	 * This method updates a Model provided in a EntityCollection object for a
	 * provided model version. The Method expects a subresource with a
	 * ModelVersion. Next the method updates each Entity object with the
	 * property $ModelVersion. An old version will be automatically removed
	 * before update.
	 * 
	 * @param version
	 *            - $modelversion
	 * @param ecol
	 *            - model data
	 */
	@PUT
	@Path("/{version}")
	@Consumes({"application/xml","text/xml"})
	public void putModelByVersion(@PathParam("version") String sModelVersion,
			EntityCollection ecol) {

		XMLItemCollection entity;
		ItemCollection itemCollection;
		try {
			if (ecol.getEntity().length > 0) {
				/*
				 * first we need to delete the old model if available.
				 */
				if (sModelVersion == null)
					sModelVersion = "";

				// delete old model if a modelversion is available
				if (!"".equals(sModelVersion))
					modelService.removeModelVersion(sModelVersion);

				// save new entities into database and update modelversion.....
				for (int i = 0; i < ecol.getEntity().length; i++) {
					entity = ecol.getEntity()[i];
					itemCollection = XMLItemCollectionAdapter
							.getItemCollection(entity);
					// update model version
					itemCollection.replaceItemValue("$modelVersion",
							sModelVersion);
					// save entity
					entityService.save(itemCollection);
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/**
	 * This method updates a Model provided in a EntityCollection object.
	 * 
	 * The method takes the first entity to get the provided $modelVersion. An
	 * old version will be automatically removed before update.
	 * 
	 * @param ecol
	 */
	@PUT
	@Consumes({"application/xml","text/xml"})
	public void putModel(EntityCollection ecol) {
		String sModelVersion = null;
		XMLItemCollection entity;
		ItemCollection itemCollection;
		try {
			if (ecol.getEntity().length > 0) {
				/*
				 * first we need get model version from first entity
				 */
				entity = ecol.getEntity()[0];
				itemCollection = XMLItemCollectionAdapter
						.getItemCollection(entity);
				sModelVersion = itemCollection
						.getItemValueString("$ModelVersion");

				putModelByVersion(sModelVersion, ecol);

			}

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	@POST
	@Path("/{version}")
	@Consumes({"application/xml","text/xml"})
	public void postModelByVersion(@PathParam("version") String sModelVersion,
			EntityCollection ecol) {
		putModelByVersion(sModelVersion, ecol);
	}

	@POST
	@Consumes({"application/xml","text/xml"})
	public void postModel(EntityCollection ecol) {
		putModel(ecol);
	}

}
