package org.imixs.workflow.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;

import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItemCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;

/**
 * The WorkflowService Handler supports methods to process different kind of
 * request URIs
 * 
 * @author rsoika
 * 
 */
@Path("/workflow")
@Produces( { "text/html", "application/xml", "application/json" })
@Stateless
public class WorkflowRestService {

	@EJB
	org.imixs.workflow.jee.ejb.WorkflowService workflowService;

	@GET
	@Produces("text/html")
	@Path("/")
	public StreamingOutput getHelpHTML() {

		return new StreamingOutput() {
			public void write(OutputStream out) throws IOException,
					WebApplicationException {

				out.write("<html><head>".getBytes());
				out.write("<style>".getBytes());
				out
						.write("table {padding:0px;width: 100%;margin-left: -2px;margin-right: -2px;}"
								.getBytes());
				out
						.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}"
								.getBytes());
				out
						.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}"
								.getBytes());

				out.write("table th,table td {font-size: 12px;}".getBytes());

				out.write("table tr.a {background-color: #ddd;}".getBytes());

				out.write("table tr.b {background-color: #eee;}".getBytes());

				out.write("</style>".getBytes());
				out.write("</head><body>".getBytes());

				// body
				out.write("<h1>Imixs Workflow REST Service</h1>".getBytes());
				out
						.write("<p>Read the Imixs REST Service <a href=\"http://doc.imixs.org/xml/restservice.html\">Online Help</a> for a detailed description of this Service.</p>"
								.getBytes());
				out
						.write("<p>See the <a href=\"http://www.imixs.org\">Imixs Workflow Project Site</a> for general informations.</p>"
								.getBytes());

				// end
				out.write("</body></html>".getBytes());
			}
		};

	}

	/**
	 * Returns a collection of workitems representing the worklist by the
	 * current user
	 * 
	 * @param start
	 * @param count
	 * @param type
	 * @param sortorder
	 */
	@GET
	@Path("/worklist")
	public EntityCollection getWorkList(
			@DefaultValue("0") @QueryParam("start") int start,
			@DefaultValue("10") @QueryParam("count") int count,
			@QueryParam("type") String type,
			@DefaultValue("0") @QueryParam("sortorder") int sortorder) {
		Collection<ItemCollection> col = null;
		try {

			col = workflowService.getWorkList(null, start, count, type,
					sortorder);
			return XMLItemCollectionAdapter.putCollection(col);

		} catch (Exception e) {
			e.printStackTrace();
		}
		return new EntityCollection();
	}

	/**
	 * 
	 * @param start
	 * @param count
	 * @param type
	 * @param sortorder
	 * @return
	 */
	@GET
	@Path("/worklist.xml")
	@Produces("application/xml")
	public EntityCollection getWorkListXML(
			@DefaultValue("0") @QueryParam("start") int start,
			@DefaultValue("10") @QueryParam("count") int count,
			@QueryParam("type") String type,
			@DefaultValue("0") @QueryParam("sortorder") int sortorder) {
		return getWorkList(start, count, type, sortorder);
	}

	@GET
	@Path("/worklistbycreator")
	public EntityCollection getWorkListByCreator(
			@DefaultValue("0") @QueryParam("start") int start,
			@DefaultValue("10") @QueryParam("count") int count,
			@QueryParam("type") String type,
			@DefaultValue("0") @QueryParam("sortorder") int sortorder) {
		Collection<ItemCollection> col = null;
		try {

			col = workflowService.getWorkListByCreator(null, start, count,
					type, sortorder);
			return XMLItemCollectionAdapter.putCollection(col);

		} catch (Exception e) {
			e.printStackTrace();
		}
		return new EntityCollection();
	}

	@GET
	@Path("/worklistbycreator.xml")
	@Produces("application/xml")
	public EntityCollection getWorkListByCreatorXML(
			@DefaultValue("0") @QueryParam("start") int start,
			@DefaultValue("10") @QueryParam("count") int count,
			@QueryParam("type") String type,
			@DefaultValue("0") @QueryParam("sortorder") int sortorder) {
		return getWorkListByCreator(start, count, type, sortorder);
	}

	@GET
	@Path("/worklistbyprocessid/{processid}")
	public EntityCollection getWorkListByProcessID(
			@PathParam("processid") int processid,
			@DefaultValue("0") @QueryParam("start") int start,
			@DefaultValue("10") @QueryParam("count") int count,
			@QueryParam("type") String type,
			@DefaultValue("0") @QueryParam("sortorder") int sortorder) {
		Collection<ItemCollection> col = null;
		try {
			col = workflowService.getWorkListByProcessID(processid, start,
					count, type, sortorder);
			return XMLItemCollectionAdapter.putCollection(col);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return new EntityCollection();
	}

	@GET
	@Path("/worklistbyprocessid/{processid}.xml")
	@Produces("application/xml")
	public EntityCollection getWorkListByProcessIDXML(
			@PathParam("processid") int processid,
			@DefaultValue("0") @QueryParam("start") int start,
			@DefaultValue("10") @QueryParam("count") int count,
			@QueryParam("type") String type,
			@DefaultValue("0") @QueryParam("sortorder") int sortorder) {
		return getWorkListByProcessID(processid, start, count, type, sortorder);
	}

	@GET
	@Path("/worklistbygroup/{processgroup}")
	public EntityCollection getWorkListByGroup(
			@PathParam("processgroup") String processgroup,
			@DefaultValue("0") @QueryParam("start") int start,
			@DefaultValue("10") @QueryParam("count") int count,
			@QueryParam("type") String type,
			@DefaultValue("0") @QueryParam("sortorder") int sortorder) {
		Collection<ItemCollection> col = null;
		try {
			col = workflowService.getWorkListByGroup(processgroup, start,
					count, type, sortorder);
			return XMLItemCollectionAdapter.putCollection(col);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return new EntityCollection();
	}

	@GET
	@Path("/worklistbygroup/{processgroup}.xml")
	@Produces("application/xml")
	public EntityCollection getWorkListByGroupXML(
			@PathParam("processgroup") String processgroup,
			@DefaultValue("0") @QueryParam("start") int start,
			@DefaultValue("10") @QueryParam("count") int count,
			@QueryParam("type") String type,
			@DefaultValue("0") @QueryParam("sortorder") int sortorder) {
		return getWorkListByGroup(processgroup, start, count, type, sortorder);
	}

	@GET
	@Path("/worklistbyowner/{owner}")
	public EntityCollection getWorkListByOwner(
			@PathParam("owner") String owner,
			@DefaultValue("0") @QueryParam("start") int start,
			@DefaultValue("10") @QueryParam("count") int count,
			@QueryParam("type") String type,
			@DefaultValue("0") @QueryParam("sortorder") int sortorder) {
		Collection<ItemCollection> col = null;
		try {
			col = workflowService.getWorkListByOwner(owner, start, count, type,
					sortorder);
			return XMLItemCollectionAdapter.putCollection(col);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return new EntityCollection();
	}

	@GET
	@Path("/worklistbyowner/{owner}.xml")
	@Produces("application/xml")
	public EntityCollection getWorkListByOwnerXML(
			@PathParam("owner") String owner,
			@DefaultValue("0") @QueryParam("start") int start,
			@DefaultValue("10") @QueryParam("count") int count,
			@QueryParam("type") String type,
			@DefaultValue("0") @QueryParam("sortorder") int sortorder) {
		return getWorkListByOwner(owner, start, count, type, sortorder);
	}

	@GET
	@Path("/worklistbywriteaccess")
	public EntityCollection getWorkListByWriteAccess(
			@DefaultValue("0") @QueryParam("start") int start,
			@DefaultValue("10") @QueryParam("count") int count,
			@QueryParam("type") String type,
			@DefaultValue("0") @QueryParam("sortorder") int sortorder) {
		Collection<ItemCollection> col = null;
		try {
			col = workflowService.getWorkListByWriteAccess(start, count, type,
					sortorder);
			return XMLItemCollectionAdapter.putCollection(col);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return new EntityCollection();
	}

	@GET
	@Path("/worklistbywriteaccess.xml")
	@Produces("application/xml")
	public EntityCollection getWorkListByWriteAccessXML(
			@DefaultValue("0") @QueryParam("start") int start,
			@DefaultValue("10") @QueryParam("count") int count,
			@QueryParam("type") String type,
			@DefaultValue("0") @QueryParam("sortorder") int sortorder) {

		return getWorkListByWriteAccess(start, count, type, sortorder);
	}

	@GET
	@Path("/worklistbyref/{uniqueid}")
	public EntityCollection getWorkListByRef(
			@PathParam("uniqueid") String uniqueid,
			@DefaultValue("0") @QueryParam("start") int start,
			@DefaultValue("10") @QueryParam("count") int count,
			@QueryParam("type") String type,
			@DefaultValue("0") @QueryParam("sortorder") int sortorder) {
		Collection<ItemCollection> col = null;
		try {
			col = workflowService.getWorkListByRef(uniqueid, start, count,
					type, sortorder);
			return XMLItemCollectionAdapter.putCollection(col);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return new EntityCollection();
	}

	@GET
	@Path("/worklistbyref/{uniqueid}.xml")
	@Produces("application/xml")
	public EntityCollection getWorkListByRefXML(
			@PathParam("uniqueid") String uniqueid,
			@DefaultValue("0") @QueryParam("start") int start,
			@DefaultValue("10") @QueryParam("count") int count,
			@QueryParam("type") String type,
			@DefaultValue("0") @QueryParam("sortorder") int sortorder) {
		return getWorkListByRef(uniqueid, start, count, type, sortorder);
	}

	/**
	 * returns a singel workitem defined by $uniqueid
	 * 
	 * @param uniqueid
	 * @return
	 */
	@GET
	@Path("/workitem/{uniqueid}")
	public XMLItemCollection getWorkItem(@PathParam("uniqueid") String uniqueid) {
		ItemCollection workitem;
		try {
			workitem = workflowService.getWorkItem(uniqueid);
			return XMLItemCollectionAdapter.putItemCollection(workitem);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	@GET
	@Path("/workitem/{uniqueid}.xml")
	@Produces("application/xml")
	public XMLItemCollection getWorkItemXML(
			@PathParam("uniqueid") String uniqueid) {
		return getWorkItem(uniqueid);
	}

	/**
	 * Returns a file attachment located in the property $file of the spcified
	 * workitem
	 * 
	 * @param uniqueid
	 * @return
	 */
	@GET
	@Path("/workitem/{uniqueid}/file/{file}")
	public Response getWorkItemFile(@PathParam("uniqueid") String uniqueid,
			@PathParam("file") String file) {

		ItemCollection workItem;
		try {
			workItem = workflowService.getWorkItem(uniqueid);

			if (workItem != null) {
				// fetch $file from hashmap....

				HashMap mapFiles = null;
				Vector vFiles = workItem.getItemValue("$file");
				if (vFiles != null && vFiles.size() > 0) {
					mapFiles = (HashMap) vFiles.elementAt(0);

					Vector<Object> vectorFileInfo = new Vector<Object>();
					vectorFileInfo = (Vector) mapFiles.get(file);
					if (vectorFileInfo != null) {
						String sContentType = vectorFileInfo.elementAt(0)
								.toString();
						byte[] fileContent = (byte[]) vectorFileInfo
								.elementAt(1);

						// Set content type in order of the contentType stored
						// in the $file attribute
						Response.ResponseBuilder builder = Response.ok(
								fileContent, sContentType);

						return builder.build();

					} else
						// workitem not found
						return Response.status(Response.Status.NOT_FOUND)
								.build();

				} else
					// workitem not found
					return Response.status(Response.Status.NOT_FOUND).build();

			} else {
				// workitem not found
				return Response.status(Response.Status.NOT_FOUND).build();
			}

		} catch (Exception e) {

			e.printStackTrace();
		}

		return Response.status(Response.Status.NOT_FOUND).build();

	}

}
