/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.util.Collection;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ModelService;
import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItemCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;

@Path(value="/model")
@Produces(value={"text/html", "application/xml", "application/json"})
@Stateless
public class ModelRestService {
    @EJB
    EntityService entityService;
    @EJB
    ModelService modelService;

    @GET
    @Produces(value={"application/xml"})
    public String getAllVersions() {
        List col = null;
        StringBuffer sb = new StringBuffer();
        sb.append("<model>");
        try {
            col = this.modelService.getAllModelVersions();
            for (String aversion : col) {
                sb.append("<version>" + aversion + "</version>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sb.append("</model>");
        return sb.toString();
    }

    @GET
    @Path(value="/{version}")
    public EntityCollection getProcessList(@PathParam(value="version") String version) {
        Collection col = null;
        try {
            col = this.modelService.getProcessEntityListByVersion(version);
            return XMLItemCollectionAdapter.putCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/{version}.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getProcessListXML(@PathParam(value="version") String version) {
        return this.getProcessList(version);
    }

    @GET
    @Path(value="/{version}/{processid}")
    public EntityCollection getActivityList(@PathParam(value="version") String version, @PathParam(value="processid") int processid) {
        Collection col = null;
        try {
            col = this.modelService.getActivityEntityListByVersion(processid, version);
            return XMLItemCollectionAdapter.putCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/{version}/{processid}.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getActivityListXML(@PathParam(value="version") String version, @PathParam(value="processid") int processid) {
        return this.getActivityList(version, processid);
    }

    @DELETE
    @Path(value="/{version}")
    public void deleteModel(@PathParam(value="version") String version) {
        try {
            this.modelService.removeModelVersion(version);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PUT
    @Path(value="/{version}")
    @Consumes(value={"application/xml", "text/xml"})
    public void putModelByVersion(@PathParam(value="version") String sModelVersion, EntityCollection ecol) {
        try {
            if (ecol.getEntity().length > 0) {
                if (sModelVersion == null) {
                    sModelVersion = "";
                }
                if (!"".equals(sModelVersion)) {
                    this.modelService.removeModelVersion(sModelVersion);
                }
                for (int i = 0; i < ecol.getEntity().length; ++i) {
                    XMLItemCollection entity = ecol.getEntity()[i];
                    ItemCollection itemCollection = XMLItemCollectionAdapter.getItemCollection((XMLItemCollection)entity);
                    itemCollection.replaceItemValue("$modelVersion", (Object)sModelVersion);
                    this.entityService.save(itemCollection);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PUT
    @Consumes(value={"application/xml", "text/xml"})
    public void putModel(EntityCollection ecol) {
        String sModelVersion = null;
        try {
            if (ecol.getEntity().length > 0) {
                XMLItemCollection entity = ecol.getEntity()[0];
                ItemCollection itemCollection = XMLItemCollectionAdapter.getItemCollection((XMLItemCollection)entity);
                sModelVersion = itemCollection.getItemValueString("$ModelVersion");
                this.putModelByVersion(sModelVersion, ecol);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @POST
    @Path(value="/{version}")
    @Consumes(value={"application/xml", "text/xml"})
    public void postModelByVersion(@PathParam(value="version") String sModelVersion, EntityCollection ecol) {
        this.putModelByVersion(sModelVersion, ecol);
    }

    @POST
    @Consumes(value={"application/xml", "text/xml"})
    public void postModel(EntityCollection ecol) {
        this.putModel(ecol);
    }
}

