/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.ejb.WorkflowService;
import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItemCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;

@Path(value="/workflow")
@Produces(value={"text/html", "application/xml", "application/json"})
@Stateless
public class WorkflowRestService {
    @EJB
    WorkflowService workflowService;

    @GET
    @Produces(value={"text/html"})
    @Path(value="/")
    public StreamingOutput getHelpHTML() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 100%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs Workflow REST Service</h1>".getBytes());
                out.write("<p>Read the Imixs REST Service <a href=\"http://doc.imixs.org/xml/restservice.html\">Online Help</a> for a detailed description of this Service.</p>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org\">Imixs Workflow Project Site</a> for general informations.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    @GET
    @Path(value="/worklist")
    public EntityCollection getWorkList(@DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder) {
        Collection col = null;
        try {
            col = this.workflowService.getWorkList(null, start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklist.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListXML(@DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder) {
        return this.getWorkList(start, count, type, sortorder);
    }

    @GET
    @Path(value="/worklistbycreator")
    public EntityCollection getWorkListByCreator(@DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder) {
        Collection col = null;
        try {
            col = this.workflowService.getWorkListByCreator(null, start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklistbycreator.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListByCreatorXML(@DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder) {
        return this.getWorkListByCreator(start, count, type, sortorder);
    }

    @GET
    @Path(value="/worklistbyprocessid/{processid}")
    public EntityCollection getWorkListByProcessID(@PathParam(value="processid") int processid, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder) {
        Collection col = null;
        try {
            col = this.workflowService.getWorkListByProcessID(processid, start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklistbyprocessid/{processid}.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListByProcessIDXML(@PathParam(value="processid") int processid, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder) {
        return this.getWorkListByProcessID(processid, start, count, type, sortorder);
    }

    @GET
    @Path(value="/worklistbygroup/{processgroup}")
    public EntityCollection getWorkListByGroup(@PathParam(value="processgroup") String processgroup, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder) {
        Collection col = null;
        try {
            col = this.workflowService.getWorkListByGroup(processgroup, start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklistbygroup/{processgroup}.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListByGroupXML(@PathParam(value="processgroup") String processgroup, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder) {
        return this.getWorkListByGroup(processgroup, start, count, type, sortorder);
    }

    @GET
    @Path(value="/worklistbyowner/{owner}")
    public EntityCollection getWorkListByOwner(@PathParam(value="owner") String owner, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder) {
        Collection col = null;
        try {
            col = this.workflowService.getWorkListByOwner(owner, start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklistbyowner/{owner}.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListByOwnerXML(@PathParam(value="owner") String owner, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder) {
        return this.getWorkListByOwner(owner, start, count, type, sortorder);
    }

    @GET
    @Path(value="/worklistbywriteaccess")
    public EntityCollection getWorkListByWriteAccess(@DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder) {
        Collection col = null;
        try {
            col = this.workflowService.getWorkListByWriteAccess(start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklistbywriteaccess.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListByWriteAccessXML(@DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder) {
        return this.getWorkListByWriteAccess(start, count, type, sortorder);
    }

    @GET
    @Path(value="/worklistbyref/{uniqueid}")
    public EntityCollection getWorkListByRef(@PathParam(value="uniqueid") String uniqueid, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder) {
        Collection col = null;
        try {
            col = this.workflowService.getWorkListByRef(uniqueid, start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklistbyref/{uniqueid}.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListByRefXML(@PathParam(value="uniqueid") String uniqueid, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder) {
        return this.getWorkListByRef(uniqueid, start, count, type, sortorder);
    }

    @GET
    @Path(value="/workitem/{uniqueid}")
    public XMLItemCollection getWorkItem(@PathParam(value="uniqueid") String uniqueid) {
        try {
            ItemCollection workitem = this.workflowService.getWorkItem(uniqueid);
            return XMLItemCollectionAdapter.putItemCollection((ItemCollection)workitem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GET
    @Path(value="/workitem/{uniqueid}.xml")
    @Produces(value={"application/xml"})
    public XMLItemCollection getWorkItemXML(@PathParam(value="uniqueid") String uniqueid) {
        return this.getWorkItem(uniqueid);
    }

    @GET
    @Path(value="/workitem/{uniqueid}/file/{file}")
    public Response getWorkItemFile(@PathParam(value="uniqueid") String uniqueid, @PathParam(value="file") String file) {
        try {
            ItemCollection workItem = this.workflowService.getWorkItem(uniqueid);
            if (workItem != null) {
                HashMap mapFiles = null;
                Vector vFiles = workItem.getItemValue("$file");
                if (vFiles != null && vFiles.size() > 0) {
                    mapFiles = (HashMap)vFiles.elementAt(0);
                    Vector vectorFileInfo = new Vector();
                    vectorFileInfo = (Vector)mapFiles.get(file);
                    if (vectorFileInfo != null) {
                        String sContentType = vectorFileInfo.elementAt(0).toString();
                        byte[] fileContent = (byte[])vectorFileInfo.elementAt(1);
                        Response.ResponseBuilder builder = Response.ok((Object)fileContent, (String)sContentType);
                        return builder.build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

