/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs.plugins;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.jaxrs.ReportRestService;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ReportService;
import org.imixs.workflow.plugins.AbstractPlugin;
import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;

public class ReportPlugin
extends AbstractPlugin {
    private EntityService entityServiceEJB = null;
    private ReportService reportServiceEJB = null;
    private String reportName = null;
    private String reportFilePath = null;
    private String reportTarget = null;
    private String sEQL;
    private String sXSL;
    private String sContentType;
    private String sEncoding;
    private ItemCollection blobWorkitem = null;
    private static Logger logger = Logger.getLogger("org.imixs.workflow");

    public void init(WorkflowContext actx) throws Exception {
        super.init(actx);
    }

    public EntityService getEntityService() throws Exception {
        if (this.entityServiceEJB == null) {
            this.lookupEJBs();
        }
        return this.entityServiceEJB;
    }

    public ReportService getReportService() throws Exception {
        if (this.reportServiceEJB == null) {
            this.lookupEJBs();
        }
        return this.reportServiceEJB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws Exception {
        try {
            this.reportName = adocumentActivity.getItemValueString("txtReportName");
            this.reportFilePath = adocumentActivity.getItemValueString("txtReportFilePath");
            if ("".equals(this.reportFilePath)) {
                this.reportFilePath = this.reportName;
            }
            this.reportFilePath = this.replaceDynamicValues(this.reportFilePath, adocumentContext);
            this.reportTarget = adocumentActivity.getItemValueString("txtReportTarget");
            if ("".equals(this.reportName)) {
                return 0;
            }
            if (!this.reportName.endsWith(".ixr")) {
                this.reportName = this.reportName + ".ixr";
            }
            ItemCollection itemCol = this.getReportService().getReport(this.reportName);
            this.sEQL = itemCol.getItemValueString("txtquery");
            String sParamString = adocumentActivity.getItemValueString("txtReportParams");
            sParamString = this.replaceDynamicValues(sParamString, adocumentContext);
            this.sEQL = this.computeEQLParams(this.sEQL, sParamString);
            logger.info("ReportPlugin JPQL=" + this.sEQL);
            this.sXSL = itemCol.getItemValueString("txtXSL").trim();
            if ("".equals(this.sXSL)) {
                return 0;
            }
            this.sContentType = itemCol.getItemValueString("txtcontenttype");
            if ("".equals(this.sContentType)) {
                this.sContentType = "text/html";
            }
            this.sEncoding = itemCol.getItemValueString("txtencoding");
            if ("".equals(this.sEncoding)) {
                this.sEncoding = "UTF-8";
            }
            Vector<ItemCollection> col = this.getEntityService().findAllEntities(this.sEQL, 0, -1);
            String sUnqiueID = adocumentContext.getItemValueString("$uniqueID");
            if (!"".equals(sUnqiueID)) {
                Vector<ItemCollection> colNew = new Vector<ItemCollection>();
                for (ItemCollection aitemCol : col) {
                    if (sUnqiueID.equals(aitemCol.getItemValueString("$uniqueid"))) {
                        ItemCollection itemTemp = new ItemCollection(adocumentContext.getAllItems());
                        itemTemp.replaceItemValue("$temp", (Object)"true");
                        colNew.add(itemTemp);
                        logger.info(" ReportPlugin - relaced deprecated workitem from collection");
                        continue;
                    }
                    colNew.add(aitemCol);
                }
                col = colNew;
            } else {
                ItemCollection itemTemp = new ItemCollection(adocumentContext.getAllItems());
                itemTemp.replaceItemValue("$temp", (Object)"true");
                col.add(itemTemp);
                logger.info(" ReportPlugin - add current workitem into collection");
            }
            EntityCollection xmlCol = XMLItemCollectionAdapter.putCollection(col);
            StringWriter xmlWriter = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{EntityCollection.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)this.sEncoding);
            m.marshal((Object)xmlCol, (Writer)xmlWriter);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                if ("application/pdf".equals(this.sContentType.toLowerCase())) {
                    ReportRestService.fopTranformation(xmlWriter.toString(), this.sXSL, this.sEncoding, outputStream);
                } else {
                    ReportRestService.xslTranformation(xmlWriter.toString(), this.sXSL, this.sEncoding, outputStream);
                }
            }
            finally {
                outputStream.close();
            }
            if ("0".equals(this.reportTarget)) {
                adocumentContext.addFile(outputStream.toByteArray(), this.reportFilePath, this.sContentType);
            }
            if ("1".equals(this.reportTarget)) {
                this.load(adocumentContext);
                this.blobWorkitem.addFile(outputStream.toByteArray(), this.reportFilePath, this.sContentType);
                this.save(adocumentContext);
            }
            if ("2".equals(this.reportTarget)) {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(this.reportFilePath);
                    fos.write(outputStream.toByteArray());
                    fos.flush();
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 2;
        }
    }

    public void close(int status) throws Exception {
    }

    private void lookupEJBs() throws Exception {
        if (this.entityServiceEJB == null || this.reportServiceEJB == null) {
            String jndiName = null;
            InitialContext ictx = new InitialContext();
            Context ctx = (Context)ictx.lookup("java:comp/env");
            jndiName = "ejb/EntityServiceBean";
            this.entityServiceEJB = (EntityService)ctx.lookup(jndiName);
            jndiName = "ejb/ReportServiceBean";
            this.reportServiceEJB = (ReportService)ctx.lookup(jndiName);
        }
        if (this.entityServiceEJB == null) {
            throw new Exception("Error - unable to load EJB ejb/EntityServiceBean....");
        }
        if (this.reportServiceEJB == null) {
            throw new Exception("Error - unable to load EJB ejb/ReportServiceBean....");
        }
    }

    private String computeEQLParams(String aQuery, String sParamString) {
        if (sParamString.startsWith("?") || sParamString.startsWith("&")) {
            sParamString = sParamString.substring(1);
        }
        StringTokenizer tokenizer = new StringTokenizer(sParamString, "&");
        while (tokenizer.hasMoreTokens()) {
            String aToken = tokenizer.nextToken();
            if (aToken.indexOf(61) == -1) continue;
            String sKeyName = aToken.substring(0, aToken.indexOf(61));
            String sParamValue = aToken.substring(aToken.indexOf(61) + 1);
            if (aQuery.indexOf("?" + sKeyName) <= -1) continue;
            aQuery = aQuery.replace("?" + sKeyName, sParamValue);
        }
        return aQuery;
    }

    private void load(ItemCollection itemCol) throws Exception {
        String sUniqueID = itemCol.getItemValueString("$uniqueid");
        String sQuery = " SELECT lobitem FROM Entity as lobitem join lobitem.textItems as t1 join lobitem.textItems as t2 WHERE t1.itemName = 'type' AND t1.itemValue = 'workitemlob' AND t2.itemName = '$uniqueidref' AND t2.itemValue = '" + sUniqueID + "'";
        Collection itemcol = this.getEntityService().findAllEntities(sQuery, 0, 1);
        if (itemcol != null && itemcol.size() > 0) {
            this.blobWorkitem = (ItemCollection)itemcol.iterator().next();
        } else {
            this.blobWorkitem = new ItemCollection();
            this.blobWorkitem.replaceItemValue("$uniqueidRef", (Object)sUniqueID);
            this.blobWorkitem.replaceItemValue("type", (Object)"workitemlob");
        }
    }

    private void save(ItemCollection parentWorkitem) throws Exception {
        if (this.blobWorkitem != null && parentWorkitem != null) {
            Vector vAccess = parentWorkitem.getItemValue("$ReadAccess");
            this.blobWorkitem.replaceItemValue("$ReadAccess", (Object)vAccess);
            vAccess = parentWorkitem.getItemValue("$WriteAccess");
            this.blobWorkitem.replaceItemValue("$WriteAccess", (Object)vAccess);
            this.blobWorkitem.replaceItemValue("$uniqueidRef", (Object)parentWorkitem.getItemValueString("$uniqueID"));
            this.blobWorkitem.replaceItemValue("type", (Object)"workitemlob");
            this.blobWorkitem = this.getEntityService().save(this.blobWorkitem);
        }
    }
}

