/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLItemCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;

@Provider
@Produces(value={"text/html"})
public class XMLItemCollectionWriter
implements MessageBodyWriter<XMLItemCollection> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return XMLItemCollection.class.isAssignableFrom(type);
    }

    public void writeTo(XMLItemCollection xmlItemCollection, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(entityStream));
        bw.write("<html>");
        XMLItemCollectionWriter.printHead(bw);
        bw.write("<body>");
        try {
            bw.write("<h1>Entity</h1>");
            XMLItemCollectionWriter.printXMLItemCollectionHTML(bw, xmlItemCollection);
        }
        catch (Exception e) {
            bw.write("ERROR<br>");
        }
        bw.write("</body>");
        bw.write("</html>");
        bw.flush();
    }

    public long getSize(XMLItemCollection arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return -1L;
    }

    public static void printXMLItemCollectionHTML(BufferedWriter bw, XMLItemCollection xmlworkItem) throws IOException {
        boolean trClass = false;
        ItemCollection workItem = XMLItemCollectionAdapter.getItemCollection((XMLItemCollection)xmlworkItem);
        bw.write("<table><tbody>");
        bw.write("<tr class=\"a\">");
        bw.write("<th colspan=\"2\"><b>UniqueID: " + workItem.getItemValueString("$uniqueid") + "</b></th></tr>");
        bw.write("<tr class=\"a\">");
        bw.write("<th>Property</th><th>Value</th></tr>");
        for (Map.Entry mapEntry : workItem.getAllItems().entrySet()) {
            String sName = mapEntry.getKey().toString();
            Vector value = (Vector)mapEntry.getValue();
            if (trClass) {
                bw.write("<tr class=\"a\">");
            } else {
                bw.write("<tr class=\"b\">");
            }
            trClass = !trClass;
            bw.write("<td>" + sName + "</td><td>" + XMLItemCollectionWriter.convertValuesToString(value) + "</td></tr>");
        }
        bw.write("</tbody></table>");
        bw.write("<br/><br/>");
    }

    public static String convertValuesToString(Vector values) {
        String convertedValue = "";
        if (values == null) {
            return convertedValue;
        }
        boolean bFirstValue = true;
        for (Object o : values) {
            Date dateValue = null;
            if (o instanceof Date) {
                dateValue = (Date)o;
            }
            if (o instanceof Calendar) {
                Calendar cal = (Calendar)o;
                dateValue = cal.getTime();
            }
            String singleValue = "";
            if (!bFirstValue) {
                convertedValue = convertedValue + "~";
            }
            if (dateValue != null) {
                singleValue = DateFormat.getDateTimeInstance(3, 3).format(dateValue);
            } else if (o != null) {
                singleValue = singleValue + o.toString();
            }
            convertedValue = convertedValue + singleValue;
            bFirstValue = false;
        }
        return convertedValue;
    }

    public static void printHead(BufferedWriter bw) throws IOException {
        bw.write("<head>");
        bw.write("<style>");
        bw.write("table {padding:0px;width: 100%;margin-left: -2px;margin-right: -2px;}");
        bw.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}");
        bw.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}");
        bw.write("table th,table td {font-size: 12px;}");
        bw.write("table tr.a {background-color: #ddd;}");
        bw.write("table tr.b {background-color: #eee;}");
        bw.write("</style>");
        bw.write("</head>");
    }
}

