/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.jee.ejb.WorkflowService;
import org.imixs.workflow.util.JSONParser;
import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItemCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;

@Path(value="/workflow")
@Produces(value={"text/html", "application/xml", "application/json"})
@Stateless
public class WorkflowRestService {
    @EJB
    private WorkflowService workflowService;
    @Context
    private static HttpServletRequest servletRequest;
    private static Logger logger;

    @GET
    @Produces(value={"text/html"})
    @Path(value="/help")
    public StreamingOutput getHelpHTML() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 100%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs Workflow REST Service</h1>".getBytes());
                out.write("<p>Read the Imixs REST Service <a href=\"http://doc.imixs.org/xml/restservice.html\">Online Help</a> for a detailed description of this Service.</p>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org\">Imixs Workflow Project Site</a> for general informations.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    @GET
    @Path(value="/worklist")
    public EntityCollection getWorkList(@DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.workflowService.getWorkList(start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklist.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListXML(@DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkList(start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklist.json")
    @Produces(value={"application/json"})
    public EntityCollection getWorkListJSON(@DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkList(start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklistbyauthor/{user}")
    public EntityCollection getWorkListByAuthor(@PathParam(value="user") String user, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        List col = null;
        try {
            if ("null".equalsIgnoreCase(user)) {
                user = null;
            }
            col = this.workflowService.getWorkListByAuthor(user, start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklistbyauthor/{user}.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListByAuthorXML(@PathParam(value="user") String user, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkListByAuthor(user, start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklistbyauthor/{user}.json")
    @Produces(value={"application/json"})
    public EntityCollection getWorkListByAuthorJSON(@PathParam(value="user") String user, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkListByAuthor(user, start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklistbycreator/{creator}")
    public EntityCollection getWorkListByCreator(@PathParam(value="creator") String creator, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        List col = null;
        try {
            if ("null".equalsIgnoreCase(creator)) {
                creator = null;
            }
            col = this.workflowService.getWorkListByCreator(creator, start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklistbycreator/{creator}.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListByCreatorXML(@PathParam(value="creator") String creator, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkListByCreator(creator, start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklistbycreator/{creator}.json")
    @Produces(value={"application/json"})
    public EntityCollection getWorkListByCreatorJSON(@PathParam(value="creator") String creator, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkListByCreator(creator, start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklistbyprocessid/{processid}")
    public EntityCollection getWorkListByProcessID(@PathParam(value="processid") int processid, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.workflowService.getWorkListByProcessID(processid, start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklistbyprocessid/{processid}.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListByProcessIDXML(@PathParam(value="processid") int processid, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkListByProcessID(processid, start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklistbyprocessid/{processid}.json")
    @Produces(value={"application/json"})
    public EntityCollection getWorkListByProcessIDJSON(@PathParam(value="processid") int processid, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkListByProcessID(processid, start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklistbygroup/{processgroup}")
    public EntityCollection getWorkListByGroup(@PathParam(value="processgroup") String processgroup, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.workflowService.getWorkListByGroup(processgroup, start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklistbygroup/{processgroup}.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListByGroupXML(@PathParam(value="processgroup") String processgroup, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkListByGroup(processgroup, start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklistbygroup/{processgroup}.json")
    @Produces(value={"application/json"})
    public EntityCollection getWorkListByGroupJSON(@PathParam(value="processgroup") String processgroup, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkListByGroup(processgroup, start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklistbyowner/{owner}")
    public EntityCollection getWorkListByOwner(@PathParam(value="owner") String owner, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        List col = null;
        try {
            if ("null".equalsIgnoreCase(owner)) {
                owner = null;
            }
            col = this.workflowService.getWorkListByOwner(owner, start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklistbyowner/{owner}.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListByOwnerXML(@PathParam(value="owner") String owner, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkListByOwner(owner, start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklistbyowner/{owner}.json")
    @Produces(value={"application/json"})
    public EntityCollection getWorkListByOwnerJSON(@PathParam(value="owner") String owner, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkListByOwner(owner, start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklistbywriteaccess")
    public EntityCollection getWorkListByWriteAccess(@DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.workflowService.getWorkListByWriteAccess(start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklistbywriteaccess.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListByWriteAccessXML(@DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkListByWriteAccess(start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklistbywriteaccess.json")
    @Produces(value={"application/json"})
    public EntityCollection getWorkListByWriteAccessJSON(@DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkListByWriteAccess(start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklistbyref/{uniqueid}")
    public EntityCollection getWorkListByRef(@PathParam(value="uniqueid") String uniqueid, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.workflowService.getWorkListByRef(uniqueid, start, count, type, sortorder);
            return XMLItemCollectionAdapter.putCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/worklistbyref/{uniqueid}.xml")
    @Produces(value={"application/xml"})
    public EntityCollection getWorkListByRefXML(@PathParam(value="uniqueid") String uniqueid, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkListByRef(uniqueid, start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/worklistbyref/{uniqueid}.json")
    @Produces(value={"application/json"})
    public EntityCollection getWorkListByRefJSON(@PathParam(value="uniqueid") String uniqueid, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="sortorder") int sortorder, @QueryParam(value="items") String items) {
        return this.getWorkListByRef(uniqueid, start, count, type, sortorder, items);
    }

    @GET
    @Path(value="/workitem/{uniqueid}")
    public XMLItemCollection getWorkItem(@PathParam(value="uniqueid") String uniqueid, @QueryParam(value="items") String items) {
        try {
            ItemCollection workitem = this.workflowService.getWorkItem(uniqueid);
            return XMLItemCollectionAdapter.putItemCollection((ItemCollection)workitem, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GET
    @Path(value="/workitem/{uniqueid}.xml")
    @Produces(value={"application/xml"})
    public XMLItemCollection getWorkItemXML(@PathParam(value="uniqueid") String uniqueid, @QueryParam(value="items") String items) {
        return this.getWorkItem(uniqueid, items);
    }

    @GET
    @Path(value="/workitem/{uniqueid}.json")
    @Produces(value={"application/json"})
    public XMLItemCollection getWorkItemJSON(@PathParam(value="uniqueid") String uniqueid, @QueryParam(value="items") String items) {
        return this.getWorkItem(uniqueid, items);
    }

    @GET
    @Path(value="/workitem/{uniqueid}/file/{file}")
    public Response getWorkItemFile(@PathParam(value="uniqueid") String uniqueid, @PathParam(value="file") @Encoded String file, @Context UriInfo uriInfo) {
        try {
            ItemCollection workItem = this.workflowService.getWorkItem(uniqueid);
            if (workItem != null) {
                String fileNameUTF8 = URLDecoder.decode(file, "UTF-8");
                String fileNameISO = URLDecoder.decode(file, "ISO-8859-1");
                HashMap mapFiles = null;
                List vFiles = workItem.getItemValue("$file");
                if (vFiles != null && vFiles.size() > 0) {
                    mapFiles = (HashMap)vFiles.get(0);
                    Vector vectorFileInfo = new Vector();
                    vectorFileInfo = (Vector)mapFiles.get(fileNameUTF8);
                    if (vectorFileInfo == null) {
                        vectorFileInfo = (Vector)mapFiles.get(fileNameISO);
                    }
                    if (vectorFileInfo == null) {
                        vectorFileInfo = (Vector)mapFiles.get(file);
                    }
                    if (vectorFileInfo != null) {
                        String sContentType = vectorFileInfo.elementAt(0).toString();
                        byte[] fileContent = (byte[])vectorFileInfo.elementAt(1);
                        Response.ResponseBuilder builder = Response.ok((Object)fileContent, (String)sContentType);
                        return builder.build();
                    }
                    logger.warning("WorklfowRestService unable to open file: '" + file + "' in workitem '" + uniqueid + "' - error: Filename not found!");
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                logger.warning("WorklfowRestService unable to open file: '" + file + "' in workitem '" + uniqueid + "' - error: No files available!");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            logger.warning("WorklfowRestService unable to open file: '" + file + "' in workitem '" + uniqueid + "' - error: Workitem not found!");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            logger.severe("WorklfowRestService unable to open file: '" + file + "' in workitem '" + uniqueid + "' - error: " + e.getMessage());
            e.printStackTrace();
            logger.severe("WorklfowRestService unable to open file: '" + file + "' in workitem '" + uniqueid + "'");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @PUT
    @Path(value="/workitem")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response putWorkitem(InputStream requestBodyStream, @QueryParam(value="action") String action, @QueryParam(value="error") String error) {
        String unid;
        logger.fine("[WorkflowRestService] @PUT /workitem  method:putWorkitem....");
        ItemCollection workitem = WorkflowRestService.parseWorkitem(requestBodyStream);
        if (workitem != null && !"".equals(unid = workitem.getItemValueString("$uniqueID"))) {
            logger.fine("[WorkflowRestService] putWorkitem $uniqueid=" + unid);
            ItemCollection oldWorkitem = this.workflowService.getWorkItem(unid);
            if (oldWorkitem != null) {
                oldWorkitem.getAllItems().putAll(workitem.getAllItems());
                workitem = oldWorkitem;
            }
        }
        if (workitem == null) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        try {
            workitem = this.workflowService.processWorkItem(workitem);
        }
        catch (AccessDeniedException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        catch (ProcessingErrorException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        catch (PluginException e) {
            e.printStackTrace();
            if (error != null && !"".equals(error)) {
                try {
                    error = error.indexOf(63) == -1 ? error + "?" : error + "&";
                    error = error + "error_context=" + e.getErrorContext() + "&error_code=" + e.getErrorCode();
                    Object[] params = e.getErrorParameters();
                    if (params != null) {
                        for (int j = 0; j < params.length; ++j) {
                            error = error + "&error_param" + j + "=" + params[j].toString();
                        }
                    }
                    return Response.seeOther((URI)new URI(error)).build();
                }
                catch (URISyntaxException errorEx) {
                    errorEx.printStackTrace();
                    return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
                }
            }
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        if (action == null || "".equals(action)) {
            action = workitem.getItemValueString("action");
        }
        if (action != null && !"".equals(action)) {
            try {
                return Response.seeOther((URI)new URI(action)).build();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/workitem")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postWorkitem(InputStream requestBodyStream, @QueryParam(value="action") String action, @QueryParam(value="error") String error) {
        logger.fine("[WorkflowRestService] @POST /workitem  method:putWorkitem....");
        return this.putWorkitem(requestBodyStream, action, error);
    }

    @PUT
    @Path(value="/workitem")
    @Consumes(value={"application/xml", "text/xml"})
    public Response putWorkitemXML(XMLItemCollection workitem, @QueryParam(value="action") String action) {
        logger.fine("[WorkflowRestService] @PUT /workitem  method:putWorkitemXML....");
        try {
            ItemCollection itemCollection = XMLItemCollectionAdapter.getItemCollection((XMLItemCollection)workitem);
            itemCollection = this.workflowService.processWorkItem(itemCollection);
            if (action == null || "".equals(action)) {
                action = itemCollection.getItemValueString("action");
            }
            if (action != null && !"".equals(action)) {
                try {
                    return Response.seeOther((URI)new URI(action)).build();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
                }
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }

    @POST
    @Path(value="/workitem")
    @Consumes(value={"application/xml", "text/xml"})
    public Response postWorkitemXML(XMLItemCollection workitem, @QueryParam(value="action") String action) {
        logger.fine("[WorkflowRestService] @POST /workitem  method:putWorkitemXML....");
        return this.putWorkitemXML(workitem, action);
    }

    @POST
    @Path(value="/workitem.json2")
    @Consumes(value={"application/json"})
    public Response postWorkitemJSON(XMLItemCollection workitem, @QueryParam(value="action") String action) {
        logger.fine("[WorkflowRestService] @POST /workitem  method:putWorkitemJSON....");
        return this.putWorkitemXML(workitem, action);
    }

    @POST
    @Path(value="/workitem.json")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response postWorkitemJSON(InputStream requestBodyStream, @QueryParam(value="action") String action, @QueryParam(value="error") String error) {
        ItemCollection oldWorkitem;
        String unid;
        logger.fine("[WorkflowRestService] @PUT /workitem  method:putWorkitemJSON....");
        ItemCollection workitem = null;
        XMLItemCollection responseWorkitem = null;
        try {
            workitem = JSONParser.parseWorkitem((InputStream)requestBodyStream);
        }
        catch (ParseException e) {
            logger.severe("postWorkitemJSON wrong json format!");
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        if (workitem != null && !"".equals(unid = workitem.getItemValueString("$uniqueID")) && (oldWorkitem = this.workflowService.getWorkItem(unid)) != null) {
            oldWorkitem.getAllItems().putAll(workitem.getAllItems());
            workitem = oldWorkitem;
        }
        if (workitem == null) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        try {
            workitem = this.workflowService.processWorkItem(workitem);
            try {
                responseWorkitem = XMLItemCollectionAdapter.putItemCollection((ItemCollection)workitem);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                logger.warning("[WorkflowRestService] PostWorkitem failed: " + e1.getMessage());
                return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).type("application/json").build();
            }
        }
        catch (AccessDeniedException e) {
            logger.warning("[WorkflowRestService] PostWorkitem failed: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).type("application/json").entity((Object)responseWorkitem).build();
        }
        catch (ProcessingErrorException e) {
            logger.warning("[WorkflowRestService] PostWorkitem failed: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).type("application/json").entity((Object)responseWorkitem).build();
        }
        catch (PluginException e) {
            logger.warning("[WorkflowRestService] PostWorkitem failed: " + e.getMessage());
            if (error != null && !"".equals(error)) {
                workitem.replaceItemValue("error_context", (Object)e.getErrorContext());
                workitem.replaceItemValue("error_code", (Object)e.getErrorCode());
                Object[] params = e.getErrorParameters();
                if (params != null) {
                    Vector<String> vParams = new Vector<String>();
                    for (int j = 0; j < params.length; ++j) {
                        vParams.add(params[j].toString());
                    }
                    workitem.replaceItemValue("error_params", vParams);
                }
                return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).type("application/json").entity((Object)responseWorkitem).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).type("application/json").entity((Object)responseWorkitem).build();
        }
        return Response.ok((Object)responseWorkitem, (String)"application/json").build();
    }

    @PUT
    @Path(value="/workitems")
    @Consumes(value={"application/xml", "text/xml"})
    public Response putWorkitemsXML(EntityCollection worklist) {
        logger.fine("[WorkflowRestService] @PUT /workitems  method:putWorkitemsXML....");
        try {
            for (int i = 0; i < worklist.getEntity().length; ++i) {
                XMLItemCollection entity = worklist.getEntity()[i];
                ItemCollection itemCollection = XMLItemCollectionAdapter.getItemCollection((XMLItemCollection)entity);
                this.workflowService.processWorkItem(itemCollection);
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }

    @POST
    @Path(value="/workitems")
    @Consumes(value={"application/xml", "text/xml"})
    public Response postWorkitemsXML(EntityCollection worklist) {
        logger.fine("[WorkflowRestService] @POST /workitems  method:putWorkitemsXML....");
        return this.putWorkitemsXML(worklist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ItemCollection parseWorkitem(InputStream requestBodyStream) {
        Vector<String> vMultiValueFieldNames = new Vector<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(requestBodyStream));
        ItemCollection workitem = new ItemCollection();
        logger.fine("[WorkflowRestService] parseWorkitem....");
        try {
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(inputLine, "&", false);
                while (st.hasMoreTokens()) {
                    String fieldValue = st.nextToken();
                    logger.finest("[WorkflowRestService] parse line:" + fieldValue + "");
                    try {
                        fieldValue = URLDecoder.decode(fieldValue, "UTF-8");
                        if (!fieldValue.contains("=")) {
                            logger.finest("[WorkflowRestService] line will be skipped");
                            continue;
                        }
                        String fieldName = fieldValue.substring(0, fieldValue.indexOf(61));
                        if (fieldName.contains(":") || fieldName.contains(" ") || fieldName.contains(";")) {
                            logger.finest("[WorkflowRestService] line will be skipped");
                            continue;
                        }
                        if (fieldValue.indexOf(61) == fieldValue.length()) {
                            workitem.replaceItemValue(fieldName, (Object)"");
                            logger.fine("[WorkflowRestService] no value for '" + fieldName + "'");
                            continue;
                        }
                        fieldValue = fieldValue.substring(fieldValue.indexOf(61) + 1);
                        if (vMultiValueFieldNames.indexOf(fieldName = fieldName.toLowerCase()) > -1) {
                            List v = workitem.getItemValue(fieldName);
                            v.add(fieldValue);
                            logger.fine("[WorkflowRestService] multivalue for '" + fieldName + "' = '" + fieldValue + "'");
                            workitem.replaceItemValue(fieldName, (Object)v);
                            continue;
                        }
                        logger.fine("[WorkflowRestService] value for '" + fieldName + "' = '" + fieldValue + "'");
                        workitem.replaceItemValue(fieldName, (Object)fieldValue);
                        vMultiValueFieldNames.add(fieldName);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e1) {
            logger.severe("[WorkflowRestService] Unable to parse workitem data!");
            e1.printStackTrace();
            ItemCollection itemCollection = null;
            return itemCollection;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return workitem;
    }

    private List<String> getItemList(String items) {
        if (items == null || "".equals(items)) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(items, ",");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    static {
        logger = Logger.getLogger(WorkflowRestService.class.getName());
    }
}

