/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs.plugins;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.jaxrs.ReportRestService;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ReportService;
import org.imixs.workflow.jee.ejb.WorkflowService;
import org.imixs.workflow.plugins.jee.AbstractPlugin;
import org.imixs.workflow.plugins.jee.VersionPlugin;
import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;

public class ReportPlugin
extends AbstractPlugin {
    public static final String INVALID_CONTEXT = "INVALID_CONTEXT";
    public static final String REPORT_UNDEFINED = "REPORT_UNDEFINED";
    public static final String INVALID_REPORT_DEFINITION = "INVALID_REPORT_DEFINITION";
    private EntityService entityService = null;
    private WorkflowService workflowService = null;
    private ReportService reportService = null;
    private String reportName = null;
    private String reportFilePath = null;
    private String reportTarget = null;
    private String sEQL;
    private String sXSL;
    private String sContentType;
    private String sEncoding;
    private ItemCollection blobWorkitem = null;
    private static Logger logger = Logger.getLogger(ReportPlugin.class.getName());

    public void init(WorkflowContext actx) throws PluginException {
        super.init(actx);
        if (actx instanceof WorkflowService) {
            this.workflowService = (WorkflowService)actx;
            if (this.workflowService == null) {
                throw new PluginException(VersionPlugin.class.getSimpleName(), INVALID_CONTEXT, "VersionPlugin unable to access WorkflowSerive");
            }
            this.entityService = this.workflowService.getEntityService();
            this.reportService = this.workflowService.getReportService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        List vAttributList;
        ItemCollection itemCol;
        this.reportName = adocumentActivity.getItemValueString("txtReportName");
        this.reportFilePath = adocumentActivity.getItemValueString("txtReportFilePath");
        if ("".equals(this.reportFilePath)) {
            this.reportFilePath = this.reportName;
        }
        this.reportFilePath = this.replaceDynamicValues(this.reportFilePath, adocumentContext);
        this.reportTarget = adocumentActivity.getItemValueString("txtReportTarget");
        if ("".equals(this.reportName)) {
            return 0;
        }
        if (!this.reportName.endsWith(".ixr")) {
            this.reportName = this.reportName + ".ixr";
        }
        if ((itemCol = this.reportService.getReport(this.reportName)) == null) {
            throw new PluginException(ReportPlugin.class.getSimpleName(), REPORT_UNDEFINED, "Report '" + this.reportName + " is undefined", new Object[]{this.reportName});
        }
        this.sEQL = itemCol.getItemValueString("txtquery");
        String sParamString = adocumentActivity.getItemValueString("txtReportParams");
        sParamString = this.replaceDynamicValues(sParamString, adocumentContext);
        this.sEQL = this.computeEQLParams(this.sEQL, sParamString);
        logger.info("ReportPlugin JPQL=" + this.sEQL);
        this.sXSL = itemCol.getItemValueString("txtXSL").trim();
        if ("".equals(this.sXSL)) {
            return 0;
        }
        this.sContentType = itemCol.getItemValueString("txtcontenttype");
        if ("".equals(this.sContentType)) {
            this.sContentType = "text/html";
        }
        if ((vAttributList = itemCol.getItemValue("txtAttributeList")).size() == 0) {
            vAttributList = null;
        }
        this.sEncoding = itemCol.getItemValueString("txtencoding");
        if ("".equals(this.sEncoding)) {
            this.sEncoding = "UTF-8";
        }
        Vector<ItemCollection> col = this.entityService.findAllEntities(this.sEQL, 0, -1);
        String sUnqiueID = adocumentContext.getItemValueString("$uniqueID");
        if (!"".equals(sUnqiueID)) {
            Vector<ItemCollection> colNew = new Vector<ItemCollection>();
            for (ItemCollection aitemCol : col) {
                if (sUnqiueID.equals(aitemCol.getItemValueString("$uniqueid"))) {
                    ItemCollection itemTemp = new ItemCollection(adocumentContext.getAllItems());
                    itemTemp.replaceItemValue("$temp", (Object)"true");
                    colNew.add(itemTemp);
                    logger.info(" ReportPlugin - relaced deprecated workitem from collection");
                    continue;
                }
                colNew.add(aitemCol);
            }
            col = colNew;
        } else {
            ItemCollection itemTemp = new ItemCollection(adocumentContext.getAllItems());
            itemTemp.replaceItemValue("$temp", (Object)"true");
            col.add(itemTemp);
            logger.info(" ReportPlugin - add current workitem into collection");
        }
        try {
            EntityCollection xmlCol = XMLItemCollectionAdapter.putCollection(col, (List)vAttributList);
            StringWriter xmlWriter = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{EntityCollection.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)this.sEncoding);
            m.marshal((Object)xmlCol, (Writer)xmlWriter);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            String xmlContent = xmlWriter.toString();
            String xmlContentExtended = this.unescapeXMLContent(xmlContent, vAttributList, col);
            try {
                if ("application/pdf".equals(this.sContentType.toLowerCase())) {
                    ReportRestService.fopTranformation(xmlContentExtended, this.sXSL, this.sEncoding, outputStream);
                } else {
                    ReportRestService.xslTranformation(xmlContentExtended, this.sXSL, this.sEncoding, outputStream);
                }
            }
            finally {
                outputStream.close();
            }
            if ("0".equals(this.reportTarget)) {
                adocumentContext.addFile(outputStream.toByteArray(), this.reportFilePath, this.sContentType);
            }
            if ("1".equals(this.reportTarget)) {
                this.loadBlobWorkItem(adocumentContext);
                this.blobWorkitem.addFile(outputStream.toByteArray(), this.reportFilePath, this.sContentType);
                this.saveBlobWorkitem(adocumentContext);
                byte[] empty = new byte[]{0};
                adocumentContext.addFile(empty, this.reportFilePath, "");
            }
            if ("2".equals(this.reportTarget)) {
                try (FileOutputStream fos = null;){
                    fos = new FileOutputStream(this.reportFilePath);
                    fos.write(outputStream.toByteArray());
                    fos.flush();
                }
            }
            return 0;
        }
        catch (Exception e) {
            throw new PluginException(ReportPlugin.class.getSimpleName(), INVALID_REPORT_DEFINITION, "Unable to process report '" + this.reportName + "' ", new Object[]{this.reportName});
        }
    }

    private String unescapeXMLContent(String aContent, List<String> vAttributList, Collection<ItemCollection> col) {
        int entityPos = aContent.indexOf("<entity>");
        for (ItemCollection entity : col) {
            for (String fieldname : vAttributList) {
                int end;
                int start;
                int iPos;
                if (!fieldname.toLowerCase().startsWith("html") && !fieldname.toLowerCase().startsWith("xml")) continue;
                String tag = "<name>" + fieldname + "</name>";
                String sOriginValue = entity.getItemValueString(fieldname);
                if (sOriginValue.isEmpty() || (iPos = aContent.indexOf(tag, entityPos)) <= -1 || (start = aContent.indexOf(62, iPos + tag.length())) <= -1 || (end = aContent.indexOf("</value>", start)) <= -1) continue;
                aContent = aContent.substring(0, start + 1) + sOriginValue + aContent.substring(end);
            }
            entityPos = aContent.indexOf("<entity>", entityPos + 1);
        }
        return aContent;
    }

    public void close(int status) throws PluginException {
    }

    private String computeEQLParams(String aQuery, String sParamString) {
        if (sParamString.startsWith("?") || sParamString.startsWith("&")) {
            sParamString = sParamString.substring(1);
        }
        StringTokenizer tokenizer = new StringTokenizer(sParamString, "&");
        while (tokenizer.hasMoreTokens()) {
            String aToken = tokenizer.nextToken();
            if (aToken.indexOf(61) == -1) continue;
            String sKeyName = aToken.substring(0, aToken.indexOf(61));
            String sParamValue = aToken.substring(aToken.indexOf(61) + 1);
            if (aQuery.indexOf("?" + sKeyName) <= -1) continue;
            aQuery = aQuery.replace("?" + sKeyName, sParamValue);
        }
        return aQuery;
    }

    private void loadBlobWorkItem(ItemCollection itemCol) throws Exception {
        String sUniqueID = itemCol.getItemValueString("$uniqueid");
        String sQuery = " SELECT lobitem FROM Entity as lobitem join lobitem.textItems as t1 join lobitem.textItems as t2 WHERE t1.itemName = 'type' AND t1.itemValue = 'workitemlob' AND t2.itemName = '$uniqueidref' AND t2.itemValue = '" + sUniqueID + "'";
        List itemcol = this.entityService.findAllEntities(sQuery, 0, 1);
        if (itemcol != null && itemcol.size() > 0) {
            this.blobWorkitem = (ItemCollection)itemcol.iterator().next();
        } else {
            this.blobWorkitem = new ItemCollection();
            this.blobWorkitem.replaceItemValue("$uniqueidRef", (Object)sUniqueID);
            this.blobWorkitem.replaceItemValue("type", (Object)"workitemlob");
        }
    }

    private void saveBlobWorkitem(ItemCollection parentWorkitem) throws Exception {
        if (this.blobWorkitem != null && parentWorkitem != null) {
            List vAccess = parentWorkitem.getItemValue("$ReadAccess");
            this.blobWorkitem.replaceItemValue("$ReadAccess", (Object)vAccess);
            vAccess = parentWorkitem.getItemValue("$WriteAccess");
            this.blobWorkitem.replaceItemValue("$WriteAccess", (Object)vAccess);
            this.blobWorkitem.replaceItemValue("$uniqueidRef", (Object)parentWorkitem.getItemValueString("$uniqueID"));
            this.blobWorkitem.replaceItemValue("type", (Object)"workitemlob");
            this.blobWorkitem = ((WorkflowService)this.getEjbSessionContext().getBusinessObject(WorkflowService.class)).getEntityService().saveByNewTransaction(this.blobWorkitem);
        }
    }
}

