/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jaxrs.XMLItemCollectionWriter;
import org.imixs.workflow.plugins.AbstractPlugin;
import org.imixs.workflow.xml.EntityTable;
import org.imixs.workflow.xml.XMLItemCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;

@Provider
@Produces(value={"text/html"})
public class EntityTableWriter
implements MessageBodyWriter<EntityTable> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return EntityTable.class.isAssignableFrom(type);
    }

    public void writeTo(EntityTable entityCollection, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        boolean trClass = true;
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(entityStream));
        bw.write("<html>");
        XMLItemCollectionWriter.printHead(bw);
        bw.write("<body>");
        bw.write("<table><tbody>");
        if (trClass) {
            bw.write("<tr class=\"a\">");
        } else {
            bw.write("<tr class=\"b\">");
        }
        trClass = !trClass;
        for (String attr : entityCollection.getAttributeList()) {
            String sLabel = this.extractAttribute(attr, "label");
            if (sLabel != null) {
                bw.write("<th>" + sLabel + "</th>");
                continue;
            }
            bw.write("<th>" + attr + "</th>");
        }
        bw.write("</tr>");
        try {
            for (XMLItemCollection xmlworkItem : entityCollection.getEntity()) {
                if (trClass) {
                    bw.write("<tr class=\"a\">");
                } else {
                    bw.write("<tr class=\"b\">");
                }
                trClass = !trClass;
                ItemCollection itemCol = XMLItemCollectionAdapter.getItemCollection((XMLItemCollection)xmlworkItem);
                for (String attr : entityCollection.getAttributeList()) {
                    ArrayList<String> vValues = null;
                    int open = attr.toLowerCase().indexOf("<format");
                    int close = attr.toLowerCase().indexOf("</format>");
                    if (open != -1 && close != -1) {
                        String fieldName = attr.substring(0, open);
                        String format = attr.substring(open + 8, close);
                        String sLocale = this.extractAttribute(format, "locale");
                        format = format.substring(format.indexOf(">") + 1);
                        vValues = new ArrayList<String>();
                        List rawValues = itemCol.getItemValue(fieldName);
                        for (Object rawValue : rawValues) {
                            vValues.add(EntityTableWriter.formatObjectValue(rawValue, format, this.getLocaleFromString(sLocale)));
                        }
                    } else {
                        vValues = itemCol.getItemValue(attr);
                    }
                    bw.write("<td>" + XMLItemCollectionWriter.convertValuesToString(vValues) + "</td>");
                }
                bw.write("</tr>");
            }
            bw.write("</tbody></table>");
        }
        catch (Exception e) {
            bw.write("ERROR<br>");
        }
        bw.write("</body>");
        bw.write("</html>");
        bw.flush();
    }

    public long getSize(EntityTable arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return -1L;
    }

    private static String formatObjectValue(Object o, String format, Locale locale) {
        Date dateValue = null;
        if (o instanceof Date) {
            dateValue = (Date)o;
        }
        if (o instanceof Calendar) {
            Calendar cal = (Calendar)o;
            dateValue = cal.getTime();
        }
        if (dateValue != null) {
            String singleValue = "";
            if (format != null && !"".equals(format)) {
                try {
                    SimpleDateFormat formatter = null;
                    formatter = locale != null ? new SimpleDateFormat(format, locale) : new SimpleDateFormat(format);
                    singleValue = formatter.format(dateValue);
                }
                catch (Exception ef) {
                    Logger logger = Logger.getLogger(AbstractPlugin.class.getName());
                    logger.warning("EntityTableWriter: Invalid format String '" + format + "'");
                    logger.warning("EntityTableWriter: Can not format value - error: " + ef.getMessage());
                    return "" + dateValue;
                }
            } else {
                singleValue = DateFormat.getDateTimeInstance(3, 3).format(dateValue);
            }
            return singleValue;
        }
        return o.toString();
    }

    private String extractAttribute(String aString, String attributeName) {
        int iTagStartPos = -1;
        String sAttributeValue = null;
        int iAttributeStartPos = aString.toLowerCase().indexOf(attributeName + "=", iTagStartPos);
        if (iAttributeStartPos > -1) {
            iAttributeStartPos = aString.indexOf("\"", iAttributeStartPos) + 1;
            int iAttributEndPos = aString.indexOf("\"", iAttributeStartPos + 1);
            sAttributeValue = aString.substring(iAttributeStartPos, iAttributEndPos);
        }
        return sAttributeValue;
    }

    private Locale getLocaleFromString(String sLocale) {
        Locale locale = null;
        if (sLocale != null && !sLocale.isEmpty()) {
            StringTokenizer stLocale = new StringTokenizer(sLocale, "_");
            if (stLocale.countTokens() == 1) {
                String sLang = stLocale.nextToken();
                String sCount = sLang.toUpperCase();
                locale = new Locale(sLang, sCount);
            } else {
                String sLang = stLocale.nextToken();
                String sCount = stLocale.nextToken();
                locale = new Locale(sLang, sCount);
            }
        }
        return locale;
    }
}

