/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jaxrs.XMLItemCollectionWriter;
import org.imixs.workflow.util.XMLParser;
import org.imixs.workflow.xml.EntityTable;
import org.imixs.workflow.xml.XMLItemCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;

@Provider
@Produces(value={"text/html"})
public class EntityTableWriter
implements MessageBodyWriter<EntityTable> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return EntityTable.class.isAssignableFrom(type);
    }

    public void writeTo(EntityTable entityCollection, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        boolean trClass = true;
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(entityStream));
        bw.write("<html>");
        XMLItemCollectionWriter.printHead(bw);
        bw.write("<body>");
        bw.write("<table><tbody>");
        if (trClass) {
            bw.write("<tr class=\"a\">");
        } else {
            bw.write("<tr class=\"b\">");
        }
        trClass = !trClass;
        for (String attr : entityCollection.getAttributeList()) {
            String sLabel = null;
            int fPos = attr.toLowerCase().indexOf("<format");
            if (fPos > -1) {
                sLabel = XMLParser.findAttribute((String)attr, (String)"label");
                if (sLabel != null) {
                    bw.write("<th>" + sLabel + "</th>");
                    continue;
                }
                bw.write("<th>" + attr.substring(0, fPos) + "</th>");
                continue;
            }
            bw.write("<th>" + attr + "</th>");
        }
        bw.write("</tr>");
        try {
            for (XMLItemCollection xmlworkItem : entityCollection.getEntity()) {
                if (trClass) {
                    bw.write("<tr class=\"a\">");
                } else {
                    bw.write("<tr class=\"b\">");
                }
                trClass = !trClass;
                ItemCollection itemCol = XMLItemCollectionAdapter.getItemCollection((XMLItemCollection)xmlworkItem);
                for (String itemName : entityCollection.getAttributeList()) {
                    int i = itemName.toLowerCase().indexOf("<format");
                    if (i > -1) {
                        itemName = itemName.substring(0, i);
                    }
                    if ((i = itemName.toLowerCase().indexOf("<convert")) > -1) {
                        itemName = itemName.substring(0, i);
                    }
                    List vValues = itemCol.getItemValue(itemName);
                    bw.write("<td>" + XMLItemCollectionWriter.convertValuesToString(vValues) + "</td>");
                }
                bw.write("</tr>");
            }
            bw.write("</tbody></table>");
        }
        catch (Exception e) {
            bw.write("ERROR<br>");
        }
        bw.write("</body>");
        bw.write("</html>");
        bw.flush();
    }

    public long getSize(EntityTable arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return -1L;
    }
}

