/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.bpmn.BPMNModel;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ModelService;
import org.imixs.workflow.xml.EntityCollection;
import org.imixs.workflow.xml.XMLItemCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;

@Path(value="/model")
@Produces(value={"text/html", "application/xhtml+xml", "application/xml", "application/json", "text/xml"})
@Stateless
public class ModelRestService {
    private static Logger logger = Logger.getLogger(ModelRestService.class.getName());
    static List<String> modelEntityTypes = Arrays.asList("WorkflowEnvironmentEntity", "processentity", "activityentity");
    @EJB
    EntityService entityService;
    @EJB
    ModelService modelService;

    @GET
    @Produces(value={"text/html"})
    public StreamingOutput getModelOverview() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 75%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs-Workflow REST Service</h1>".getBytes());
                out.write("<p>".getBytes());
                ModelRestService.this.printVersionTable(out);
                out.write("</p>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org/xml/restservice/modelservice.html\" target=\"_bank\">Imixs REST Service API</a> for more information about this Service.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    private void printVersionTable(OutputStream out) {
        try {
            StringBuffer buffer = new StringBuffer();
            List col = this.modelService.getAllModelVersions();
            buffer.append("<table>");
            buffer.append("<tr><th>Version</th><th>Workflow Group</th><th>Updated</th></tr>");
            for (String aversion : col) {
                List groupList = this.modelService.getAllWorkflowGroups(aversion);
                for (String group : groupList) {
                    buffer.append("<tr>");
                    buffer.append("<td>" + aversion + "</td>");
                    buffer.append("<td><a href=\"./model/" + aversion + "/groups/" + group + "\">" + group + "</a></td>");
                    List processList = this.modelService.getAllProcessEntitiesByGroup(group, aversion);
                    if (processList.size() > 0) {
                        ItemCollection process = (ItemCollection)processList.get(0);
                        Date dat = process.getItemValueDate("$Modified");
                        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        buffer.append("<td>" + formater.format(dat) + "</td>");
                    }
                    buffer.append("</tr>");
                }
            }
            buffer.append("</table>");
            out.write(buffer.toString().getBytes());
        }
        catch (Exception e) {
            try {
                out.write("No model definition found.".getBytes());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @GET
    @Produces(value={"application/xml", "text/xml"})
    public String getModelXML() {
        List col = null;
        StringBuffer sb = new StringBuffer();
        sb.append("<model>");
        try {
            col = this.modelService.getAllModelVersions();
            for (String aversion : col) {
                sb.append("<version>" + aversion + "</version>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sb.append("</model>");
        return sb.toString();
    }

    @GET
    @Path(value="/{version}")
    public EntityCollection getProcessList(@PathParam(value="version") String version, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.modelService.getProcessEntityList(version);
            return XMLItemCollectionAdapter.putCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/{version}/process/{processid}")
    public XMLItemCollection getProcessEntity(@PathParam(value="version") String version, @PathParam(value="processid") int processid, @QueryParam(value="items") String items) {
        ItemCollection process = null;
        try {
            process = this.modelService.getProcessEntity(processid, version);
            return XMLItemCollectionAdapter.putItemCollection((ItemCollection)process, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLItemCollection();
        }
    }

    @GET
    @Path(value="/{version}/groups")
    public EntityCollection getStartProcessList(@PathParam(value="version") String version, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.modelService.getAllStartProcessEntities(version);
            return XMLItemCollectionAdapter.putCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/{version}/groups/{group}")
    public EntityCollection getProcessListByGroup(@PathParam(value="version") String version, @PathParam(value="group") String group, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.modelService.getAllProcessEntitiesByGroup(group, version);
            return XMLItemCollectionAdapter.putCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/{version}/activities/{processid}")
    public EntityCollection getActivityList(@PathParam(value="version") String version, @PathParam(value="processid") int processid, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.modelService.getActivityEntityList(processid, version);
            return XMLItemCollectionAdapter.putCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @DELETE
    @Path(value="/{version}")
    public void deleteModel(@PathParam(value="version") String version) {
        try {
            this.modelService.removeModel(version);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @DELETE
    @Path(value="/{version}/{group}")
    public void deleteModelGroup(@PathParam(value="group") String group, @PathParam(value="version") String version) {
        try {
            this.modelService.removeModelGroup(group, version);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PUT
    @Path(value="/bpmn")
    @Consumes(value={"application/xml", "application/octet-stream", "text/plain"})
    public Response putBPMNModel(BPMNModel bpmnmodel) {
        try {
            logger.info("updating BPMN model... ");
            this.modelService.importBPMNModel(bpmnmodel);
        }
        catch (ModelException e) {
            logger.warning("Unable to update model: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        logger.fine("update finished! ");
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/bpmn")
    @Consumes(value={"application/xml", "application/octet-stream", "text/plain"})
    public Response postBPMNModel(BPMNModel bpmnmodel) {
        return this.putBPMNModel(bpmnmodel);
    }

    @PUT
    @Path(value="/{version}")
    @Consumes(value={"application/xml", "text/xml"})
    public void putModelByVersion(@PathParam(value="version") String sModelVersion, EntityCollection ecol) {
        try {
            if (ecol.getEntity().length > 0) {
                if (sModelVersion == null) {
                    sModelVersion = "";
                }
                if (!"".equals(sModelVersion)) {
                    this.modelService.removeModel(sModelVersion);
                }
                for (int i = 0; i < ecol.getEntity().length; ++i) {
                    XMLItemCollection entity = ecol.getEntity()[i];
                    ItemCollection itemCollection = XMLItemCollectionAdapter.getItemCollection((XMLItemCollection)entity);
                    itemCollection.replaceItemValue("$modelVersion", (Object)sModelVersion);
                    this.entityService.save(itemCollection);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @POST
    @Path(value="/{version}")
    @Consumes(value={"application/xml", "text/xml"})
    public void postModelByVersion(@PathParam(value="version") String sModelVersion, EntityCollection ecol) {
        this.putModelByVersion(sModelVersion, ecol);
    }

    @PUT
    @Consumes(value={"application/xml", "text/xml"})
    public void putModel(EntityCollection ecol) {
        String sModelVersion = null;
        try {
            if (ecol.getEntity().length > 0) {
                XMLItemCollection entity = ecol.getEntity()[0];
                ItemCollection itemCollection = XMLItemCollectionAdapter.getItemCollection((XMLItemCollection)entity);
                sModelVersion = itemCollection.getItemValueString("$ModelVersion");
                this.putModelByVersion(sModelVersion, ecol);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @POST
    @Consumes(value={"application/xml", "text/xml"})
    public void postModel(EntityCollection ecol) {
        this.putModel(ecol);
    }

    private List<String> getItemList(String items) {
        if (items == null || "".equals(items)) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(items, ",");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }
}

