/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs.v3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jaxrs.v3.EntityCollection;
import org.imixs.workflow.jaxrs.v3.XMLItem;
import org.imixs.workflow.jaxrs.v3.XMLItemCollection;
import org.imixs.workflow.jaxrs.v3.XMLItemComparator;

public class XMLItemCollectionAdapter {
    private static Logger logger = Logger.getLogger(XMLItemCollectionAdapter.class.getName());

    public static ItemCollection getItemCollection(XMLItemCollection entity) {
        ItemCollection itemCol = new ItemCollection();
        if (entity == null) {
            return itemCol;
        }
        try {
            XMLItem[] items = entity.getItem();
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    XMLItem it = items[i];
                    if (it == null) continue;
                    String key = it.getName();
                    if (it.getValue() == null) {
                        itemCol.replaceItemValue(key, new Vector());
                        continue;
                    }
                    ArrayList<Object> valueList = new ArrayList<Object>(Arrays.asList(it.getValue(true)));
                    itemCol.replaceItemValue(key, valueList);
                }
            }
        }
        catch (Exception e) {
            logger.warning("[XMLItemCollectionAdapter] getItemCollection - can't convert XMLItem value - error: " + e.toString());
            itemCol = null;
        }
        return itemCol;
    }

    public static XMLItemCollection putItemCollection(ItemCollection aItemCollection, List<String> itemNames) throws Exception {
        XMLItemCollection entity;
        block6: {
            String sName = null;
            entity = new XMLItemCollection();
            int i = 0;
            XMLItem[] items = null;
            try {
                if (aItemCollection == null) break block6;
                if (itemNames != null && itemNames.size() > 0) {
                    items = new XMLItem[itemNames.size()];
                    Iterator<String> iterator = itemNames.iterator();
                    while (iterator.hasNext()) {
                        String aField;
                        sName = aField = iterator.next();
                        XMLItem item = new XMLItem();
                        List vOrg = aItemCollection.getItemValue(aField);
                        item.setName(sName);
                        item.setValue(vOrg.toArray());
                        items[i] = item;
                        ++i;
                    }
                } else {
                    Iterator it = aItemCollection.getAllItems().entrySet().iterator();
                    int max = aItemCollection.getAllItems().entrySet().size();
                    items = new XMLItem[max];
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        XMLItem item = null;
                        item = new XMLItem();
                        item.setName((String)entry.getKey());
                        item.setValue(((List)entry.getValue()).toArray());
                        if (item == null) continue;
                        items[i] = item;
                        ++i;
                    }
                }
                entity.setItem(items);
            }
            catch (Exception e) {
                System.out.println("[XMLItemCollectionAdapter] Error putItemCollection (" + sName + ")");
                throw e;
            }
        }
        entity = XMLItemCollectionAdapter.sortItemsByName(entity);
        return entity;
    }

    public static XMLItemCollection sortItemsByName(XMLItemCollection xmlItemCol) {
        XMLItem[] items = xmlItemCol.getItem();
        Arrays.sort(items, new XMLItemComparator());
        xmlItemCol.setItem(items);
        return xmlItemCol;
    }

    public static XMLItemCollection putItemCollection(ItemCollection aItemCollection) throws Exception {
        return XMLItemCollectionAdapter.putItemCollection(aItemCollection, null);
    }

    public static EntityCollection putCollection(Collection<ItemCollection> col) throws Exception {
        return XMLItemCollectionAdapter.putCollection(col, null);
    }

    public static EntityCollection putCollection(Collection<ItemCollection> col, List<String> itemNames) throws Exception {
        EntityCollection entiCol = new EntityCollection();
        Iterator<ItemCollection> it = col.iterator();
        int max = col.size();
        int i = 0;
        XMLItemCollection[] entities = new XMLItemCollection[max];
        while (it.hasNext()) {
            XMLItemCollection entity;
            ItemCollection icw = it.next();
            entities[i] = entity = XMLItemCollectionAdapter.putItemCollection(icw, itemNames);
            ++i;
        }
        if (max > 0) {
            entiCol.setEntity(entities);
        }
        return entiCol;
    }

    public static List<ItemCollection> readCollectionFromInputStream(InputStream inputStream) throws JAXBException, IOException {
        byte[] byteInput = null;
        if (inputStream == null) {
            return null;
        }
        byteInput = XMLItemCollectionAdapter.getBytesFromStream(inputStream);
        return XMLItemCollectionAdapter.readCollection(byteInput);
    }

    public static List<ItemCollection> readCollection(byte[] byteInput) throws JAXBException, IOException {
        ArrayList<ItemCollection> resultList = new ArrayList<ItemCollection>();
        if (byteInput == null) {
            return null;
        }
        EntityCollection ecol = null;
        logger.fine("[XMLItemCollectionAdapter] importXmlEntityData - verifing  content....");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{EntityCollection.class});
        Unmarshaller m = context.createUnmarshaller();
        ByteArrayInputStream input = new ByteArrayInputStream(byteInput);
        Object jaxbObject = m.unmarshal((InputStream)input);
        if (jaxbObject == null) {
            throw new RuntimeException("[XMLItemCollectionAdapter] error - wrong xml file format - unable to read content!");
        }
        ecol = (EntityCollection)jaxbObject;
        if (ecol.getEntity().length > 0) {
            for (XMLItemCollection aentity : ecol.getEntity()) {
                resultList.add(XMLItemCollectionAdapter.getItemCollection(aentity));
            }
            logger.fine("[XMLItemCollectionAdapter] " + ecol.getEntity().length + " entries sucessfull imported");
        }
        return resultList;
    }

    public static ItemCollection readItemCollection(byte[] byteInput) throws JAXBException, IOException {
        if (byteInput == null) {
            return null;
        }
        XMLItemCollection ecol = null;
        logger.fine("[XMLItemCollectionAdapter] importXmlEntityData - verifing content....");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLItemCollection.class});
        Unmarshaller m = context.createUnmarshaller();
        ByteArrayInputStream input = new ByteArrayInputStream(byteInput);
        Object jaxbObject = m.unmarshal((InputStream)input);
        if (jaxbObject == null) {
            throw new RuntimeException("[XMLItemCollectionAdapter] error - wrong xml file format - unable to read content!");
        }
        ecol = (XMLItemCollection)jaxbObject;
        ItemCollection itemCol = XMLItemCollectionAdapter.getItemCollection(ecol);
        return itemCol;
    }

    private static byte[] getBytesFromStream(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        is.close();
        return buffer.toByteArray();
    }
}

