/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.jaxrs.DocumentRestService;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.xml.DocumentCollection;
import org.imixs.workflow.xml.XMLCount;
import org.imixs.workflow.xml.XMLIndexList;
import org.imixs.workflow.xml.XMLItemCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;

@Path(value="/entity")
@Produces(value={"text/html", "application/xml", "application/json", "text/xml"})
@Stateless
public class EntityRestService {
    @EJB
    private EntityService entityService;
    @Context
    private static HttpServletRequest servletRequest;
    private static Logger logger;

    @GET
    @Produces(value={"text/html"})
    @Path(value="/help")
    public StreamingOutput getHelpHTML() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 100%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs-Entity REST Service</h1>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org/xml/restservice/entityservice.html\" target=\"_blank\">Imixs REST Service API</a> for more information about this Service.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    @GET
    @Path(value="/query/{query}")
    public DocumentCollection getEntitiesByQuery(@PathParam(value="query") String query, @DefaultValue(value="0") @QueryParam(value="start") int start, @DefaultValue(value="10") @QueryParam(value="count") int count, @QueryParam(value="items") String items) {
        List col = null;
        try {
            logger.fine("Query=" + query);
            String decodedQuery = URLDecoder.decode(query, "UTF-8");
            col = this.entityService._findAllEntities(decodedQuery, start, count);
            return XMLItemCollectionAdapter.putCollection((Collection)col, EntityRestService.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DocumentCollection();
        }
    }

    @GET
    @Path(value="/entities/{uniqueid}")
    public XMLItemCollection getEntity(@PathParam(value="uniqueid") String uniqueid, @QueryParam(value="items") String items) {
        try {
            ItemCollection entity = this.entityService._load(uniqueid);
            return XMLItemCollectionAdapter.putItemCollection((ItemCollection)entity, DocumentRestService.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GET
    @Path(value="/count/query/{query}")
    @Produces(value={"application/xml", "application/json"})
    public XMLCount countEntitiesByQuery(@PathParam(value="query") String query) {
        logger.fine("Query=" + query);
        XMLCount result = new XMLCount();
        result.count = -1L;
        try {
            String decodedQuery = URLDecoder.decode(query, "UTF-8");
            int size = this.entityService.countAllEntities(decodedQuery);
            result.count = size;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @GET
    @Path(value="/indexlist")
    public Response getIndexList() {
        if (!servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Map result = this.entityService.getIndices();
        return Response.ok((Object)new XMLIndexList(result)).build();
    }

    @PUT
    @Path(value="/index/{name}/{type}")
    public Response addIndex(@PathParam(value="name") String name, @PathParam(value="type") int type) {
        if (!servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.entityService.addIndex(name, type);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/index/{name}")
    public Response deleteIndex(@PathParam(value="name") String name) {
        if (!servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.entityService.removeIndex(name);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml", "text/xml"})
    public Response putEntity(XMLItemCollection xmlworkitem) {
        if (!servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ItemCollection workitem = XMLItemCollectionAdapter.getItemCollection((XMLItemCollection)xmlworkitem);
        if (workitem == null) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        try {
            ItemCollection currentInstance = this.entityService._load(workitem.getItemValueString("$uniqueid"));
            if (currentInstance != null) {
                currentInstance.replaceAllItems(workitem.getAllItems());
                workitem = currentInstance;
            }
            workitem.removeItem("$error_code");
            workitem.removeItem("$error_message");
            workitem = this.entityService._save(workitem);
        }
        catch (AccessDeniedException e) {
            logger.severe(e.getMessage());
            workitem = this.addErrorMessage((Exception)((Object)e), workitem);
        }
        catch (RuntimeException e) {
            logger.severe(e.getMessage());
            workitem = this.addErrorMessage(e, workitem);
        }
        try {
            if (workitem.hasItem("$error_code")) {
                return Response.ok((Object)XMLItemCollectionAdapter.putItemCollection((ItemCollection)workitem), (String)"application/xml").status(Response.Status.NOT_ACCEPTABLE).build();
            }
            return Response.ok((Object)XMLItemCollectionAdapter.putItemCollection((ItemCollection)workitem), (String)"application/xml").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }

    @DELETE
    @Path(value="/{uniqueid}")
    public Response deleteEntity(@PathParam(value="uniqueid") String uniqueid) {
        if (!servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ItemCollection entity = this.entityService._load(uniqueid);
        if (entity != null) {
            this.entityService._remove(entity);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PUT
    @Path(value="/backup/{query}")
    public Response backup(@PathParam(value="query") String query, @QueryParam(value="filepath") String filepath) {
        if (!servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.entityService.backup(query, filepath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/backup")
    public Response restore(@QueryParam(value="filepath") String filepath) {
        if (!servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.entityService.restore(filepath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    static List<String> getItemList(String items) {
        if (items == null || "".equals(items)) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(items, ",");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    private ItemCollection addErrorMessage(Exception pe, ItemCollection aworkitem) {
        if (pe instanceof RuntimeException && pe.getCause() != null) {
            pe = (RuntimeException)pe.getCause();
        }
        if (pe instanceof AccessDeniedException) {
            aworkitem.replaceItemValue("$error_code", (Object)((AccessDeniedException)((Object)pe)).getErrorCode());
            aworkitem.replaceItemValue("$error_message", (Object)pe.getMessage());
        }
        return aworkitem;
    }

    static {
        logger = Logger.getLogger(EntityRestService.class.getName());
    }
}

