/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs.v3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.datatype.XMLGregorianCalendar;

@XmlRootElement(name="item")
public class XMLItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(XMLItem.class.getName());
    private String name;
    private Object[] value;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object[] getValue() {
        return this.value;
    }

    public Object[] getValue(boolean forceConversion) {
        if (forceConversion && this.isArrayOfXMLItem(this.value)) {
            ArrayList<Object> convertedValue = new ArrayList<Object>();
            for (Object object : this.value) {
                XMLItem singleValue = (XMLItem)object;
                String key = singleValue.getName();
                if (key != null && !key.isEmpty()) {
                    HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
                    map.put(key, Arrays.asList(singleValue.getValue()));
                    convertedValue.add(map);
                    continue;
                }
                convertedValue.add(Arrays.asList(singleValue.getValue()));
            }
            return convertedValue.toArray();
        }
        return this.value;
    }

    public void setValue(Object[] values) {
        if (values == null || values.length == 0) {
            Vector vOrg = new Vector();
            vOrg.add(null);
            this.value = vOrg.toArray();
            return;
        }
        if (XMLItem.isBasicType(values = XMLItem.convertXMLGregorianCalendar(values))) {
            this.value = values;
        } else {
            logger.fine("[XMLItem] test values for map intefaces");
            if (this.isListOfMap(values)) {
                ArrayList<XMLItem> mapData = new ArrayList<XMLItem>();
                for (Object singleValue : values) {
                    Map map = (Map)singleValue;
                    for (Map.Entry mapentry : map.entrySet()) {
                        String key = (String)mapentry.getKey();
                        Object value = mapentry.getValue();
                        XMLItem mapValueItem = new XMLItem();
                        mapValueItem.setName(key);
                        if (value instanceof List) {
                            mapValueItem.setValue(((List)value).toArray());
                        } else {
                            ArrayList<String> simpleValueList = new ArrayList<String>();
                            simpleValueList.add(value.toString());
                            mapValueItem.setValue(simpleValueList.toArray());
                        }
                        mapData.add(mapValueItem);
                    }
                }
                this.value = mapData.toArray();
            } else if (this.isListOfList(values)) {
                logger.fine("[XMLItem] convert List intefaces into list of XMLItem elements");
                ArrayList<XMLItem> mapData = new ArrayList<XMLItem>();
                for (Object singleValue : values) {
                    XMLItem mapValueItem = new XMLItem();
                    mapValueItem.setValue(((List)singleValue).toArray());
                    mapData.add(mapValueItem);
                }
                this.value = mapData.toArray();
            } else {
                String classNames = "";
                for (Object singleValue : values) {
                    classNames = classNames + singleValue.getClass().getName() + "; ";
                }
                logger.warning("WARNING : XMLItem - property '" + this.name + "' contains unsupported java types: " + classNames);
            }
        }
    }

    private boolean isListOfMap(Object[] values) {
        for (Object singleValue : values) {
            if (singleValue instanceof Map) continue;
            return false;
        }
        return true;
    }

    private boolean isListOfList(Object[] values) {
        for (Object singleValue : values) {
            if (singleValue instanceof List) continue;
            return false;
        }
        return true;
    }

    private boolean isArrayOfXMLItem(Object[] values) {
        for (Object singleValue : values) {
            if (singleValue instanceof XMLItem) continue;
            return false;
        }
        return true;
    }

    private static boolean isBasicType(Object[] v) {
        for (Object o : v) {
            Class<?> c;
            String name;
            if (o instanceof byte[] || o instanceof boolean[] || o instanceof short[] || o instanceof char[] || o instanceof int[] || o instanceof long[] || o instanceof float[] || o instanceof double[] || (name = (c = o.getClass()).getName()).startsWith("java.lang.") || name.startsWith("java.math.") || "java.util.Date".equals(name) || "org.imixs.workflow.xml.XMLItem".equals(name)) continue;
            return false;
        }
        return true;
    }

    private static Object[] convertXMLGregorianCalendar(Object[] objectArray) {
        for (int j = 0; j < objectArray.length; ++j) {
            if (!(objectArray[j] instanceof XMLGregorianCalendar)) continue;
            XMLGregorianCalendar xmlCal = (XMLGregorianCalendar)objectArray[j];
            objectArray[j] = xmlCal.toGregorianCalendar().getTime();
        }
        return objectArray;
    }
}

