/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs.v3;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.jaxrs.v3.XMLItemCollection;
import org.imixs.workflow.jaxrs.v3.XMLItemCollectionAdapter;

@Path(value="/v3/entity")
@Produces(value={"text/html", "application/xml", "application/json", "text/xml"})
@Stateless
public class EntityRestServiceV3 {
    @EJB
    private DocumentService documentService;
    @Context
    private static HttpServletRequest servletRequest;
    private static Logger logger;

    @GET
    @Produces(value={"text/html"})
    @Path(value="/help")
    public StreamingOutput getHelpHTML() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 100%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs-Entity REST Service</h1>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org/xml/restservice/entityservice.html\" target=\"_blank\">Imixs REST Service API</a> for more information about this Service.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    @POST
    @Path(value="/")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml", "text/xml"})
    public Response putEntity(XMLItemCollection xmlworkitem) {
        if (!servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ItemCollection workitem = XMLItemCollectionAdapter.getItemCollection(xmlworkitem);
        if (workitem == null) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        try {
            ItemCollection currentInstance = this.documentService.load(workitem.getItemValueString("$uniqueid"));
            if (currentInstance != null) {
                currentInstance.replaceAllItems(workitem.getAllItems());
                workitem = currentInstance;
            }
            workitem.removeItem("$error_code");
            workitem.removeItem("$error_message");
            workitem = this.documentService.save(workitem);
        }
        catch (AccessDeniedException e) {
            logger.severe(e.getMessage());
            workitem = this.addErrorMessage((Exception)((Object)e), workitem);
        }
        catch (RuntimeException e) {
            logger.severe(e.getMessage());
            workitem = this.addErrorMessage(e, workitem);
        }
        try {
            if (workitem.hasItem("$error_code")) {
                return Response.ok((Object)XMLItemCollectionAdapter.putItemCollection(workitem), (String)"application/xml").status(Response.Status.NOT_ACCEPTABLE).build();
            }
            return Response.ok((Object)XMLItemCollectionAdapter.putItemCollection(workitem), (String)"application/xml").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }

    @DELETE
    @Path(value="/{uniqueid}")
    public Response deleteEntity(@PathParam(value="uniqueid") String uniqueid) {
        if (!servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ItemCollection entity = this.documentService.load(uniqueid);
        if (entity != null) {
            this.documentService.remove(entity);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    static List<String> getItemList(String items) {
        if (items == null || "".equals(items)) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(items, ",");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    private ItemCollection addErrorMessage(Exception pe, ItemCollection aworkitem) {
        if (pe instanceof RuntimeException && pe.getCause() != null) {
            pe = (RuntimeException)pe.getCause();
        }
        if (pe instanceof AccessDeniedException) {
            aworkitem.replaceItemValue("$error_code", (Object)((AccessDeniedException)((Object)pe)).getErrorCode());
            aworkitem.replaceItemValue("$error_message", (Object)pe.getMessage());
        }
        return aworkitem;
    }

    static {
        logger = Logger.getLogger(EntityRestServiceV3.class.getName());
    }
}

