/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.xml.DocumentCollection;
import org.imixs.workflow.xml.DocumentTable;
import org.imixs.workflow.xml.XMLItemCollection;
import org.imixs.workflow.xml.XMLItemCollectionAdapter;

@Path(value="/report")
@Produces(value={"application/xml", "application/json", "text/html", "text/xml"})
@Stateless
public class ReportRestService {
    @EJB
    DocumentService entityService;
    @EJB
    ReportService reportService;
    @Context
    private static HttpServletRequest servletRequest;
    private static Logger logger;

    @GET
    @Produces(value={"text/html"})
    @Path(value="/help")
    public StreamingOutput getHelpHTML() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 100%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs Workflow Report Service</h1>".getBytes());
                out.write("<p>Read the Imixs REST Service <a href=\"http://doc.imixs.org/xml/restservice.html\">Online Help</a> for a detailed description of this Service.</p>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org\">Imixs Workflow Project Site</a> for general informations.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    @GET
    @Path(value="/definitions")
    public DocumentCollection getReportsDefinitions() {
        try {
            List col = null;
            col = this.reportService.getReportList();
            return XMLItemCollectionAdapter.putCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DocumentCollection();
        }
    }

    @GET
    @Path(value="/definitions/{name}")
    public XMLItemCollection getReportDefinition(@PathParam(value="name") String name) {
        try {
            ItemCollection itemCol = this.reportService.getReport(name);
            return XMLItemCollectionAdapter.putItemCollection((ItemCollection)itemCol);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{name}.imixs-report")
    public Response getExcecuteReport(@PathParam(value="name") String reportName, @DefaultValue(value="1000") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortReverse") boolean sortReverse, @DefaultValue(value="") @QueryParam(value="encoding") String encoding, @Context UriInfo uriInfo) {
        List col = null;
        try {
            ItemCollection itemCol = this.reportService.getReport(reportName);
            if (itemCol == null) {
                logger.severe("Report '" + reportName + "' not defined!");
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            String sXSL = itemCol.getItemValueString("XSL").trim();
            String sContentType = itemCol.getItemValueString("contenttype");
            if ("".equals(sContentType)) {
                sContentType = "text/html";
            }
            if ("".equals(encoding)) {
                encoding = itemCol.getItemValueString("encoding");
            }
            if ("".equals(encoding)) {
                encoding = "UTF-8";
            }
            Map<String, String> params = this.getQueryParams(uriInfo);
            col = this.reportService.executeReport(reportName, pageSize, pageIndex, sortBy, sortReverse, params);
            if ("".equals(sXSL)) {
                Response.ResponseBuilder builder = Response.ok((Object)XMLItemCollectionAdapter.putCollection((Collection)col), (String)"text/html");
                return builder.build();
            }
            DocumentCollection xmlCol = XMLItemCollectionAdapter.putCollection((Collection)col);
            StringWriter writer = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DocumentCollection.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)encoding);
            m.marshal((Object)xmlCol, (Writer)writer);
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                if ("application/pdf".equals(sContentType.toLowerCase())) {
                    ReportRestService.fopTranformation(writer.toString(), sXSL, encoding, outputStream);
                } else {
                    ReportRestService.xslTranformation(writer.toString(), sXSL, encoding, outputStream);
                }
            }
            Response.ResponseBuilder builder = Response.ok((Object)outputStream.toByteArray(), (String)sContentType);
            return builder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{name}.pdf")
    public Response getPdfReport(@PathParam(value="name") String reportName, @DefaultValue(value="1000") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortReverse") boolean sortReverse, @DefaultValue(value="") @QueryParam(value="encoding") String encoding, @Context UriInfo uriInfo) {
        return this.getExcecuteReport(reportName, pageSize, pageIndex, sortBy, sortReverse, encoding, uriInfo);
    }

    @GET
    @Produces(value={"text/html", "application/xhtml+xml"})
    @Path(value="/{name}.html")
    public DocumentTable getHTMLResult(@PathParam(value="name") String reportName, @DefaultValue(value="1000") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortReverse") boolean sortReverse, @DefaultValue(value="") @QueryParam(value="encoding") String encoding, @Context UriInfo uriInfo, @Context HttpServletResponse servlerResponse) {
        List col = null;
        try {
            ItemCollection report = this.reportService.getReport(reportName);
            List attributes = report.getItemValue("attributes");
            ArrayList items = new ArrayList();
            ArrayList<String> labels = new ArrayList<String>();
            for (List attribute : attributes) {
                items.add(attribute.get(0));
                String label = (String)attribute.get(0);
                if (attribute.size() >= 2 && !((String)attribute.get(1)).isEmpty()) {
                    label = (String)attribute.get(1);
                }
                labels.add(label);
            }
            Map<String, String> params = this.getQueryParams(uriInfo);
            col = this.reportService.executeReport(reportName, pageSize, pageIndex, sortBy, sortReverse, params);
            DocumentCollection documentCollection = XMLItemCollectionAdapter.putCollection((Collection)col);
            DocumentTable documentTable = new DocumentTable(documentCollection.getDocument(), items, labels);
            if (encoding == null || encoding.isEmpty()) {
                encoding = "UTF-8";
            }
            logger.fine("set encoding :" + encoding);
            servlerResponse.setContentType("text/html; charset=" + encoding);
            return documentTable;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GET
    @Produces(value={"application/xml", "text/xml"})
    @Path(value="/{name}.xml")
    public DocumentCollection getXMLResult(@PathParam(value="name") String reportName, @DefaultValue(value="100") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortReverse") boolean sortReverse, @DefaultValue(value="") @QueryParam(value="encoding") String encoding, @Context UriInfo uriInfo, @Context HttpServletResponse servlerResponse) throws Exception {
        List col = null;
        try {
            Map<String, String> params = this.getQueryParams(uriInfo);
            col = this.reportService.executeReport(reportName, pageSize, pageIndex, sortBy, sortReverse, params);
            if (encoding == null || encoding.isEmpty()) {
                encoding = "UTF-8";
            }
            logger.fine("set encoding :" + encoding);
            servlerResponse.setContentType("application/xml; charset=" + encoding);
            return XMLItemCollectionAdapter.putCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{name}.json")
    public DocumentCollection getJSONResult(@PathParam(value="name") String name, @DefaultValue(value="-1") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortReverse") boolean sortReverse, @DefaultValue(value="") @QueryParam(value="encoding") String encoding, @Context UriInfo uriInfo, @Context HttpServletResponse servlerResponse) throws Exception {
        DocumentCollection result = this.getXMLResult(name, pageSize, pageIndex, sortBy, sortReverse, encoding, uriInfo, servlerResponse);
        if (encoding == null || encoding.isEmpty()) {
            encoding = "UTF-8";
        }
        logger.fine("set encoding :" + encoding);
        servlerResponse.setContentType("application/json; charset=" + encoding);
        return result;
    }

    @DELETE
    @Path(value="/reports/{name}")
    public void deleteReport(@PathParam(value="name") String name) {
        try {
            ItemCollection itemCol = this.reportService.getReport(name);
            this.entityService.remove(itemCol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PUT
    @Consumes(value={"application/xml", "application/octet-stream", "text/plain", "text/xml"})
    public void putReport(XMLItemCollection reportCol) {
        try {
            ItemCollection itemCollection = XMLItemCollectionAdapter.getItemCollection((XMLItemCollection)reportCol);
            this.reportService.updateReport(itemCollection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @POST
    @Consumes(value={"application/xml", "application/octet-stream", "text/plain", "text/xml"})
    public void postReport(XMLItemCollection reportCol) {
        this.putReport(reportCol);
    }

    public static void xslTranformation(String xmlSource, String xslSource, String aEncoding, OutputStream output) throws Exception {
        TransformerFactory transFact = TransformerFactory.newInstance();
        logger.fine("xslTransformation: encoding=" + aEncoding);
        ByteArrayInputStream baisXML = new ByteArrayInputStream(xmlSource.getBytes());
        InputStreamReader isreaderXML = new InputStreamReader((InputStream)baisXML, aEncoding);
        StreamSource xmlSrc = new StreamSource(isreaderXML);
        ByteArrayInputStream baisXSL = new ByteArrayInputStream(xslSource.getBytes());
        InputStreamReader isreaderXSL = new InputStreamReader((InputStream)baisXSL, aEncoding);
        StreamSource xslSrc = new StreamSource(isreaderXSL);
        Transformer trans = transFact.newTransformer(xslSrc);
        trans.transform(xmlSrc, new StreamResult(output));
    }

    public static void fopTranformation(String xmlSource, String xslSource, String aEncoding, OutputStream output) throws Exception {
        FopFactory fopFactory = FopFactory.newInstance();
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        foUserAgent.setBaseURL(fopFactory.getBaseURL());
        Fop fop = fopFactory.newFop("application/pdf", foUserAgent, output);
        TransformerFactory factory = TransformerFactory.newInstance();
        ByteArrayInputStream baisXSL = new ByteArrayInputStream(xslSource.getBytes());
        InputStreamReader isreaderXSL = new InputStreamReader((InputStream)baisXSL, aEncoding);
        StreamSource xslSrc = new StreamSource(isreaderXSL);
        Transformer transformer = factory.newTransformer(xslSrc);
        ByteArrayInputStream baisXML = new ByteArrayInputStream(xmlSource.getBytes());
        InputStreamReader isreaderXML = new InputStreamReader((InputStream)baisXML, aEncoding);
        StreamSource xmlSrc = new StreamSource(isreaderXML);
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        transformer.transform(xmlSrc, res);
    }

    private Map<String, String> getQueryParams(UriInfo uriInfo) {
        MultivaluedMap mvm = uriInfo.getQueryParameters();
        HashMap<String, String> result = new HashMap<String, String>();
        Set keys = mvm.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String sKeyName = ((String)iter.next()).toString();
            result.put(sKeyName, (String)mvm.getFirst((Object)sKeyName));
        }
        return result;
    }

    static {
        logger = Logger.getLogger(ReportRestService.class.getName());
    }
}

