/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs.v3;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.bpmn.BPMNModel;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.jaxrs.v3.EntityCollection;
import org.imixs.workflow.jaxrs.v3.WorkflowRestServiceV3;
import org.imixs.workflow.jaxrs.v3.XMLItemCollection;
import org.imixs.workflow.jaxrs.v3.XMLItemCollectionAdapter;
import org.imixs.workflow.jee.ejb.EntityService;

@Path(value="/v3/model")
@Produces(value={"text/html", "application/xhtml+xml", "application/xml", "application/json", "text/xml"})
@Stateless
public class ModelRestServiceV3 {
    private static Logger logger = Logger.getLogger(ModelRestServiceV3.class.getName());
    static List<String> modelEntityTypes = Arrays.asList("WorkflowEnvironmentEntity", "processentity", "activityentity");
    @EJB
    EntityService entityService;
    @EJB
    WorkflowRestServiceV3 workflowRestService;
    @EJB
    ModelService modelService;

    @GET
    @Produces(value={"text/html"})
    public StreamingOutput getModelOverview() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 75%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs-Workflow REST Service</h1>".getBytes());
                out.write("<p>".getBytes());
                ModelRestServiceV3.this.printVersionTable(out);
                out.write("</p>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org/xml/restservice/modelservice.html\" target=\"_bank\">Imixs-Workflow RestFull Service API</a> for more information.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    private void printVersionTable(OutputStream out) {
        try {
            StringBuffer buffer = new StringBuffer();
            List modelVersionList = this.modelService.getVersions();
            buffer.append("<table>");
            buffer.append("<tr><th>Version</th><th>Uploaded</th><th>Workflow Groups</th></tr>");
            for (String modelVersion : modelVersionList) {
                Model model = this.modelService.getModel(modelVersion);
                ItemCollection modelEntity = this.modelService.loadModelEntity(modelVersion);
                List groupList = model.getGroups();
                buffer.append("<tr>");
                if (modelEntity != null) {
                    buffer.append("<td><a href=\"./model/" + modelVersion + "/bpmn\">" + modelVersion + "</a></td>");
                    if (modelEntity != null) {
                        Date dat = modelEntity.getItemValueDate("$Modified");
                        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        buffer.append("<td>" + formater.format(dat) + "</td>");
                    }
                } else {
                    buffer.append("<td>" + modelVersion + "</td>");
                    buffer.append("<td> - </td>");
                }
                buffer.append("<td>");
                for (String group : groupList) {
                    buffer.append("<a href=\"./model/" + modelVersion + "/groups/" + group + "\">" + group + "</a></br>");
                }
                buffer.append("</td>");
                buffer.append("</tr>");
            }
            buffer.append("</table>");
            out.write(buffer.toString().getBytes());
        }
        catch (IOException | ModelException e) {
            try {
                out.write("No model definition found.".getBytes());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @GET
    @Produces(value={"application/xml", "text/xml"})
    public String getModelXML() {
        List col = null;
        StringBuffer sb = new StringBuffer();
        sb.append("<model>");
        try {
            col = this.modelService.getVersions();
            for (String aversion : col) {
                sb.append("<version>" + aversion + "</version>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sb.append("</model>");
        return sb.toString();
    }

    @GET
    @Path(value="/{version}/tasks/")
    public EntityCollection findAllTasks(@PathParam(value="version") String version, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.modelService.getModel(version).findAllTasks();
            return XMLItemCollectionAdapter.putCollection(col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/{version}/bpmn")
    public Response getModelFile(@PathParam(value="version") String version, @Context UriInfo uriInfo) {
        ItemCollection modelEntity = this.modelService.loadModelEntity(version);
        if (modelEntity != null) {
            return this.workflowRestService.getWorkItemFile(modelEntity.getUniqueID(), (String)modelEntity.getFileNames().get(0), uriInfo);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{version}/tasks/{taskid}")
    public XMLItemCollection getTask(@PathParam(value="version") String version, @PathParam(value="taskid") int processid, @QueryParam(value="items") String items) {
        ItemCollection process = null;
        try {
            process = this.modelService.getModel(version).getTask(processid);
            return XMLItemCollectionAdapter.putItemCollection(process, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLItemCollection();
        }
    }

    @GET
    @Path(value="/{version}/tasks/{taskid}/events")
    public EntityCollection findAllEventsByTask(@PathParam(value="version") String version, @PathParam(value="taskid") int processid, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.modelService.getModel(version).findAllEventsByTask(processid);
            return XMLItemCollectionAdapter.putCollection(col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @GET
    @Path(value="/{version}/groups")
    public List<String> getGroups(@PathParam(value="version") String version, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.modelService.getModel(version).getGroups();
            return col;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GET
    @Path(value="/{version}/groups/{group}")
    public EntityCollection findTasksByGroup(@PathParam(value="version") String version, @PathParam(value="group") String group, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.modelService.getModel(version).findTasksByGroup(group);
            return XMLItemCollectionAdapter.putCollection(col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EntityCollection();
        }
    }

    @DELETE
    @Path(value="/{version}")
    public void deleteModel(@PathParam(value="version") String version) {
        try {
            this.modelService.deleteModel(version);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PUT
    @Path(value="/bpmn")
    @Consumes(value={"application/xml", "application/octet-stream", "text/plain"})
    public Response putBPMNModel(BPMNModel bpmnmodel) {
        try {
            logger.fine("BPMN Model posted... ");
            this.modelService.saveModel(bpmnmodel);
        }
        catch (ModelException e) {
            logger.warning("Unable to update model: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        logger.fine("putBPMNModel finished! ");
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/bpmn")
    @Consumes(value={"application/xml", "application/octet-stream", "text/plain"})
    public Response postBPMNModel(BPMNModel bpmnmodel) {
        return this.putBPMNModel(bpmnmodel);
    }

    @PUT
    @Path(value="/{version}")
    @Consumes(value={"application/xml", "text/xml"})
    public void putModelByVersion(@PathParam(value="version") String sModelVersion, EntityCollection ecol) {
        try {
            if (ecol.getEntity().length > 0) {
                if (sModelVersion == null) {
                    sModelVersion = "";
                }
                if (!"".equals(sModelVersion)) {
                    this.modelService.removeModel(sModelVersion);
                }
                for (int i = 0; i < ecol.getEntity().length; ++i) {
                    XMLItemCollection entity = ecol.getEntity()[i];
                    ItemCollection itemCollection = XMLItemCollectionAdapter.getItemCollection(entity);
                    itemCollection.replaceItemValue("$modelVersion", (Object)sModelVersion);
                    this.entityService._save(itemCollection);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @POST
    @Path(value="/{version}")
    @Consumes(value={"application/xml", "text/xml"})
    public void postModelByVersion(@PathParam(value="version") String sModelVersion, EntityCollection ecol) {
        this.putModelByVersion(sModelVersion, ecol);
    }

    @PUT
    @Consumes(value={"application/xml", "text/xml"})
    public void putModel(EntityCollection ecol) {
        String sModelVersion = null;
        try {
            if (ecol.getEntity().length > 0) {
                XMLItemCollection entity = ecol.getEntity()[0];
                ItemCollection itemCollection = XMLItemCollectionAdapter.getItemCollection(entity);
                sModelVersion = itemCollection.getItemValueString("$ModelVersion");
                this.putModelByVersion(sModelVersion, ecol);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @POST
    @Consumes(value={"application/xml", "text/xml"})
    public void postModel(EntityCollection ecol) {
        this.putModel(ecol);
    }

    private List<String> getItemList(String items) {
        if (items == null || "".equals(items)) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(items, ",");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }
}

