/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.WorkflowException;
import org.imixs.workflow.jaxrs.DocumentRestService;
import org.imixs.workflow.util.JSONParser;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Path(value="/workflow")
@Produces(value={"text/html", "application/xml", "application/json", "text/xml"})
@Stateless
public class WorkflowRestService {
    @EJB
    private WorkflowService workflowService;
    @Context
    private HttpServletRequest servletRequest;
    private static Logger logger = Logger.getLogger(WorkflowRestService.class.getName());

    @GET
    @Produces(value={"text/html"})
    public StreamingOutput getHelpHTML() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 100%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs-Workflow REST Service</h1>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org/doc/restapi/workflowservice.html\" target=\"_blank\">Imixs-Workflow REST API</a> for more information about this Service.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    @GET
    @Path(value="/workitem/{uniqueid}")
    public Response getWorkItem(@PathParam(value="uniqueid") String uniqueid, @QueryParam(value="items") String items) {
        try {
            ItemCollection workitem = this.workflowService.getWorkItem(uniqueid);
            if (workitem == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem, DocumentRestService.getItemList(items))).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GET
    @Path(value="/workitem/{uniqueid}/file/{file}")
    public Response getWorkItemFile(@PathParam(value="uniqueid") String uniqueid, @PathParam(value="file") @Encoded String file, @Context UriInfo uriInfo) {
        try {
            ItemCollection workItem = this.workflowService.getWorkItem(uniqueid);
            if (workItem != null) {
                String fileNameUTF8 = URLDecoder.decode(file, "UTF-8");
                String fileNameISO = URLDecoder.decode(file, "ISO-8859-1");
                Map mapFiles = workItem.getFiles();
                if (mapFiles != null) {
                    Object fileInfoObject = null;
                    fileInfoObject = mapFiles.get(fileNameUTF8);
                    if (fileInfoObject == null) {
                        fileInfoObject = mapFiles.get(fileNameISO);
                    }
                    if (fileInfoObject == null) {
                        fileInfoObject = mapFiles.get(file);
                    }
                    if (fileInfoObject != null) {
                        String sContentType = null;
                        byte[] fileContent = null;
                        if (fileInfoObject instanceof List) {
                            sContentType = ((List)fileInfoObject).get(0).toString();
                            fileContent = (byte[])((List)fileInfoObject).get(1);
                        } else {
                            sContentType = ((Object[])fileInfoObject)[0].toString();
                            fileContent = (byte[])((Object[])fileInfoObject)[1];
                        }
                        Response.ResponseBuilder builder = Response.ok((Object)fileContent, (String)sContentType);
                        return builder.build();
                    }
                    logger.warning("WorklfowRestService unable to open file: '" + file + "' in workitem '" + uniqueid + "' - error: Filename not found!");
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                logger.warning("WorklfowRestService unable to open file: '" + file + "' in workitem '" + uniqueid + "' - error: No files available!");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            logger.warning("WorklfowRestService unable to open file: '" + file + "' in workitem '" + uniqueid + "' - error: Workitem not found!");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            logger.severe("WorklfowRestService unable to open file: '" + file + "' in workitem '" + uniqueid + "' - error: " + e.getMessage());
            e.printStackTrace();
            logger.severe("WorklfowRestService unable to open file: '" + file + "' in workitem '" + uniqueid + "'");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="/workitem/events/{uniqueid}")
    public XMLDataCollection getEvents(@PathParam(value="uniqueid") String uniqueid) {
        List eventList = null;
        try {
            eventList = this.workflowService.getEvents(this.workflowService.getDocumentService().load(uniqueid));
            return XMLDataCollectionAdapter.getDataCollection((Collection)eventList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/worklist")
    public XMLDataCollection getWorkList(@QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @DefaultValue(value="10") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="false") @QueryParam(value="sortReverse") Boolean sortReverse, @QueryParam(value="items") String items) {
        return this.getTaskListByOwner(null, type, pageSize, pageIndex, sortBy, sortReverse, items);
    }

    @GET
    @Path(value="/tasklist/owner/{owner}")
    public XMLDataCollection getTaskListByOwner(@PathParam(value="owner") String owner, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @DefaultValue(value="10") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="false") @QueryParam(value="sortReverse") Boolean sortReverse, @QueryParam(value="items") String items) {
        List col = null;
        try {
            if ("null".equalsIgnoreCase(owner)) {
                owner = null;
            }
            if (owner != null) {
                owner = URLDecoder.decode(owner, "UTF-8");
            }
            col = this.workflowService.getWorkListByOwner(owner, type, pageSize, pageIndex, sortBy, sortReverse.booleanValue());
            return XMLDataCollectionAdapter.getDataCollection((Collection)col, DocumentRestService.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/tasklist/author/{user}")
    public XMLDataCollection getTaskListByAuthor(@PathParam(value="user") String user, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @DefaultValue(value="10") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="false") @QueryParam(value="sortReverse") Boolean sortReverse, @QueryParam(value="items") String items) {
        List col = null;
        try {
            if ("null".equalsIgnoreCase(user)) {
                user = null;
            }
            if (user != null) {
                user = URLDecoder.decode(user, "UTF-8");
            }
            col = this.workflowService.getWorkListByAuthor(user, type, pageSize, pageIndex, sortBy, sortReverse.booleanValue());
            return XMLDataCollectionAdapter.getDataCollection((Collection)col, DocumentRestService.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/tasklist/creator/{creator}")
    public XMLDataCollection getTaskListByCreator(@PathParam(value="creator") String creator, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @DefaultValue(value="10") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="false") @QueryParam(value="sortReverse") Boolean sortReverse, @QueryParam(value="items") String items) {
        List col = null;
        try {
            if ("null".equalsIgnoreCase(creator)) {
                creator = null;
            }
            if (creator != null) {
                creator = URLDecoder.decode(creator, "UTF-8");
            }
            col = this.workflowService.getWorkListByCreator(creator, type, pageSize, pageIndex, sortBy, sortReverse.booleanValue());
            return XMLDataCollectionAdapter.getDataCollection((Collection)col, DocumentRestService.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/tasklist/processid/{processid}")
    public XMLDataCollection getTaskListByProcessID(@PathParam(value="processid") int processid, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @DefaultValue(value="10") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="false") @QueryParam(value="sortReverse") Boolean sortReverse, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.workflowService.getWorkListByProcessID(processid, type, pageSize, pageIndex, sortBy, sortReverse.booleanValue());
            return XMLDataCollectionAdapter.getDataCollection((Collection)col, DocumentRestService.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/tasklist/group/{processgroup}")
    public XMLDataCollection getTaskListByGroup(@PathParam(value="processgroup") String processgroup, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @DefaultValue(value="10") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="false") @QueryParam(value="sortReverse") Boolean sortReverse, @QueryParam(value="items") String items) {
        List col = null;
        try {
            if (processgroup != null) {
                processgroup = URLDecoder.decode(processgroup, "UTF-8");
            }
            col = this.workflowService.getWorkListByGroup(processgroup, type, pageSize, pageIndex, sortBy, sortReverse.booleanValue());
            return XMLDataCollectionAdapter.getDataCollection((Collection)col, DocumentRestService.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/tasklist/ref/{uniqueid}")
    public XMLDataCollection getTaskListByRef(@PathParam(value="uniqueid") String uniqueid, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @DefaultValue(value="10") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="false") @QueryParam(value="sortReverse") Boolean sortReverse, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.workflowService.getWorkListByRef(uniqueid, type, pageSize, pageIndex, sortBy, sortReverse.booleanValue());
            return XMLDataCollectionAdapter.getDataCollection((Collection)col, DocumentRestService.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @POST
    @Path(value="/workitem")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postFormWorkitem(InputStream requestBodyStream) {
        logger.fine("postFormWorkitem @POST /workitem  method:postWorkitem....");
        ItemCollection workitem = WorkflowRestService.parseWorkitem(requestBodyStream);
        return this.processWorkitem(workitem, null);
    }

    @POST
    @Path(value="/workitem/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postFormWorkitemByUnqiueID(@PathParam(value="uniqueid") String uid, InputStream requestBodyStream) {
        logger.finest("......postFormWorkitem @POST /workitem  method:postWorkitem....");
        ItemCollection workitem = WorkflowRestService.parseWorkitem(requestBodyStream);
        return this.processWorkitem(workitem, uid);
    }

    @PUT
    @Path(value="/workitem")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response putFormWorkitem(InputStream requestBodyStream) {
        logger.fine("putFormWorkitem @POST /workitem  delegate to POST....");
        return this.postFormWorkitem(requestBodyStream);
    }

    @POST
    @Path(value="/workitem")
    @Consumes(value={"application/xml", "text/xml"})
    public Response postXMLWorkitem(XMLDocument xmlworkitem) {
        logger.fine("postXMLWorkitem @POST /workitem  method:postWorkitemXML....");
        ItemCollection workitem = XMLDocumentAdapter.putDocument((XMLDocument)xmlworkitem);
        return this.processWorkitem(workitem, null);
    }

    @PUT
    @Path(value="/workitem")
    @Consumes(value={"application/xml", "text/xml"})
    public Response putXMLWorkitem(XMLDocument workitem) {
        logger.fine("putXMLWorkitem @PUT /workitem  delegate to POST....");
        return this.postXMLWorkitem(workitem);
    }

    @POST
    @Path(value="/workitem/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    @Consumes(value={"application/xml", "text/xml"})
    public Response postXMLWorkitemByUniqueID(@PathParam(value="uniqueid") String uniqueid, XMLDocument xmlworkitem) {
        logger.fine("postXMLWorkitemByUniqueID @POST /workitem/" + uniqueid + "  method:postWorkitemXML....");
        ItemCollection workitem = XMLDocumentAdapter.putDocument((XMLDocument)xmlworkitem);
        return this.processWorkitem(workitem, uniqueid);
    }

    @PUT
    @Path(value="/workitem/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    @Consumes(value={"application/xml", "text/xml"})
    public Response putXMLWorkitemByUniqueID(@PathParam(value="uniqueid") String uniqueid, XMLDocument xmlworkitem) {
        logger.fine("putXMLWorkitem @PUT /workitem/{uniqueid}  delegate to POST....");
        return this.postXMLWorkitemByUniqueID(uniqueid, xmlworkitem);
    }

    @POST
    @Path(value="/workitem")
    @Consumes(value={"application/json"})
    public Response postJSONWorkitem(InputStream requestBodyStream, @QueryParam(value="error") String error, @QueryParam(value="encoding") String encoding) {
        logger.fine("postWorkitem_JSON @POST workitem  postWorkitemJSON....");
        if (encoding == null || encoding.isEmpty()) {
            encoding = this.servletRequest.getCharacterEncoding();
            logger.fine("postJSONWorkitem using request econding=" + encoding);
        } else {
            logger.fine("postJSONWorkitem set econding=" + encoding);
        }
        ItemCollection workitem = null;
        try {
            workitem = JSONParser.parseWorkitem((InputStream)requestBodyStream, (String)encoding);
        }
        catch (ParseException e) {
            logger.severe("postJSONWorkitem wrong json format!");
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        catch (UnsupportedEncodingException e) {
            logger.severe("postJSONWorkitem wrong json format!");
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        if (workitem == null) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        return this.processWorkitem(workitem, null);
    }

    @PUT
    @Path(value="/workitem")
    @Consumes(value={"application/json"})
    public Response putJSONWorkitem(InputStream requestBodyStream, @QueryParam(value="error") String error, @QueryParam(value="encoding") String encoding) {
        logger.fine("putJSONWorkitem @PUT /workitem/{uniqueid}  delegate to POST....");
        return this.postJSONWorkitem(requestBodyStream, error, encoding);
    }

    @POST
    @Path(value="/workitem/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    @Consumes(value={"application/json"})
    public Response postJSONWorkitemByUniqueID(@PathParam(value="uniqueid") String uniqueid, InputStream requestBodyStream, @QueryParam(value="error") String error, @QueryParam(value="encoding") String encoding) {
        logger.fine("postJSONWorkitemByUniqueID @POST /workitem/" + uniqueid + "....");
        if (encoding == null || encoding.isEmpty()) {
            encoding = this.servletRequest.getCharacterEncoding();
            logger.fine("postJSONWorkitemByUniqueID using request econding=" + encoding);
        } else {
            logger.fine("postJSONWorkitemByUniqueID set econding=" + encoding);
        }
        ItemCollection workitem = null;
        try {
            workitem = JSONParser.parseWorkitem((InputStream)requestBodyStream, (String)encoding);
        }
        catch (ParseException e) {
            logger.severe("postJSONWorkitemByUniqueID wrong json format!");
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        catch (UnsupportedEncodingException e) {
            logger.severe("postJSONWorkitemByUniqueID wrong json format!");
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        return this.processWorkitem(workitem, uniqueid);
    }

    @PUT
    @Path(value="/workitem/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    @Consumes(value={"application/json"})
    public Response putJSONWorkitemByUniqueID(@PathParam(value="uniqueid") String uniqueid, InputStream requestBodyStream, @QueryParam(value="error") String error, @QueryParam(value="encoding") String encoding) {
        logger.fine("postJSONWorkitemByUniqueID @PUT /workitem/{uniqueid}  delegate to POST....");
        return this.postJSONWorkitemByUniqueID(uniqueid, requestBodyStream, error, encoding);
    }

    @POST
    @Path(value="/workitems")
    @Consumes(value={"application/xml", "text/xml"})
    public Response postWorkitems_XML(XMLDataCollection worklist) {
        logger.fine("postWorkitems_XML @POST /workitems  method:postWorkitemsXML....");
        try {
            for (int i = 0; i < worklist.getDocument().length; ++i) {
                XMLDocument entity = worklist.getDocument()[i];
                ItemCollection itemCollection = XMLDocumentAdapter.putDocument((XMLDocument)entity);
                this.workflowService.processWorkItem(itemCollection);
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }

    @PUT
    @Path(value="/workitems")
    @Consumes(value={"application/xml", "text/xml"})
    public Response putWorkitems_XML(XMLDataCollection worklist) {
        logger.fine("pupWorkitems_XML @PUT /workitems  delegate to @POST....");
        return this.postWorkitems_XML(worklist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemCollection parseWorkitem(InputStream requestBodyStream) {
        Vector<String> vMultiValueFieldNames = new Vector<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(requestBodyStream));
        ItemCollection workitem = new ItemCollection();
        logger.fine("[WorkflowRestService] parseWorkitem....");
        try {
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(inputLine, "&", false);
                while (st.hasMoreTokens()) {
                    String fieldValue = st.nextToken();
                    logger.finest("[WorkflowRestService] parse line:" + fieldValue + "");
                    try {
                        fieldValue = URLDecoder.decode(fieldValue, "UTF-8");
                        if (!fieldValue.contains("=")) {
                            logger.finest("[WorkflowRestService] line will be skipped");
                            continue;
                        }
                        String fieldName = fieldValue.substring(0, fieldValue.indexOf(61));
                        if (fieldName.contains(":") || fieldName.contains(" ") || fieldName.contains(";")) {
                            logger.finest("[WorkflowRestService] line will be skipped");
                            continue;
                        }
                        if (fieldValue.indexOf(61) == fieldValue.length()) {
                            workitem.replaceItemValue(fieldName, (Object)"");
                            logger.fine("[WorkflowRestService] no value for '" + fieldName + "'");
                            continue;
                        }
                        fieldValue = fieldValue.substring(fieldValue.indexOf(61) + 1);
                        if (vMultiValueFieldNames.indexOf(fieldName = fieldName.toLowerCase()) > -1) {
                            List v = workitem.getItemValue(fieldName);
                            v.add(fieldValue);
                            logger.fine("[WorkflowRestService] multivalue for '" + fieldName + "' = '" + fieldValue + "'");
                            workitem.replaceItemValue(fieldName, (Object)v);
                            continue;
                        }
                        logger.fine("[WorkflowRestService] value for '" + fieldName + "' = '" + fieldValue + "'");
                        workitem.replaceItemValue(fieldName, (Object)fieldValue);
                        vMultiValueFieldNames.add(fieldName);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e1) {
            logger.severe("[WorkflowRestService] Unable to parse workitem data!");
            e1.printStackTrace();
            ItemCollection itemCollection = null;
            return itemCollection;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return workitem;
    }

    @Deprecated
    @POST
    @Path(value="/workitem.json/{uniqueid}")
    @Consumes(value={"application/json"})
    public Response postWorkitemByUniqueIDJSONDeprecated(@PathParam(value="uniqueid") String uniqueid, InputStream requestBodyStream, @QueryParam(value="error") String error, @QueryParam(value="encoding") String encoding) {
        return this.postJSONWorkitemByUniqueID(uniqueid, requestBodyStream, error, encoding);
    }

    @Deprecated
    @POST
    @Path(value="/workitem.json")
    @Consumes(value={"application/json"})
    public Response postWorkitemJSONDeprecated(InputStream requestBodyStream, @QueryParam(value="error") String error, @QueryParam(value="encoding") String encoding) {
        return this.postJSONWorkitem(requestBodyStream, error, encoding);
    }

    private Response processWorkitem(ItemCollection workitem, String uid) {
        if (workitem == null) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        if (uid != null && !uid.equals(workitem.getUniqueID())) {
            logger.severe("@POST/@PUT workitem/" + uid + " : $UNIQUEID did not match, remove $uniqueid to create a new instnace!");
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        if (uid != null && !uid.isEmpty()) {
            workitem.replaceItemValue("$uniqueid", (Object)uid);
        }
        try {
            workitem.removeItem("$error_code");
            workitem.removeItem("$error_message");
            workitem = this.workflowService.processWorkItem(workitem);
        }
        catch (AccessDeniedException e) {
            workitem = this.addErrorMessage((Exception)((Object)e), workitem);
        }
        catch (PluginException e) {
            workitem = this.addErrorMessage((Exception)((Object)e), workitem);
        }
        catch (RuntimeException e) {
            workitem = this.addErrorMessage(e, workitem);
        }
        catch (ModelException e) {
            workitem = this.addErrorMessage((Exception)((Object)e), workitem);
        }
        try {
            if (workitem.hasItem("$error_code")) {
                return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem)).status(Response.Status.NOT_ACCEPTABLE).build();
            }
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }

    private ItemCollection addErrorMessage(Exception pe, ItemCollection aworkitem) {
        if (pe instanceof RuntimeException && pe.getCause() != null) {
            pe = (RuntimeException)pe.getCause();
        }
        if (pe instanceof WorkflowException) {
            PluginException p;
            String message = ((WorkflowException)pe).getErrorCode();
            if (pe instanceof PluginException && (p = (PluginException)((Object)pe)).getErrorParameters() != null && p.getErrorParameters().length > 0) {
                for (int i = 0; i < p.getErrorParameters().length; ++i) {
                    message = message.replace("{" + i + "}", p.getErrorParameters()[i].toString());
                }
            }
            aworkitem.replaceItemValue("$error_code", (Object)((WorkflowException)pe).getErrorCode());
            aworkitem.replaceItemValue("$error_message", (Object)message);
        } else if (pe instanceof InvalidAccessException) {
            aworkitem.replaceItemValue("$error_code", (Object)((InvalidAccessException)pe).getErrorCode());
            aworkitem.replaceItemValue("$error_message", (Object)pe.getMessage());
        } else {
            aworkitem.replaceItemValue("$error_code", (Object)"INTERNAL ERROR");
            aworkitem.replaceItemValue("$error_message", (Object)pe.getMessage());
        }
        return aworkitem;
    }
}

