/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs.v40;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jaxrs.v40.DocumentCollection;
import org.imixs.workflow.jaxrs.v40.XMLItem;
import org.imixs.workflow.jaxrs.v40.XMLItemCollection;
import org.imixs.workflow.jaxrs.v40.XMLItemComparator;

public class XMLItemCollectionAdapter {
    private static Logger logger = Logger.getLogger(XMLItemCollectionAdapter.class.getName());

    public static ItemCollection getItemCollection(XMLItemCollection entity) {
        ItemCollection itemCol = new ItemCollection();
        if (entity == null) {
            return itemCol;
        }
        XMLItem[] items = entity.getItem();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                XMLItem it = items[i];
                if (it == null) continue;
                String key = it.getName();
                if (it.getValue() == null) {
                    itemCol.replaceItemValue(key, new Vector());
                    continue;
                }
                ArrayList<Object> valueList = new ArrayList<Object>(Arrays.asList(it.getValue(true)));
                itemCol.replaceItemValue(key, valueList);
            }
        }
        return itemCol;
    }

    public static List<ItemCollection> getCollection(DocumentCollection doccol) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        if (doccol != null && doccol.getDocument() != null) {
            for (int i = 0; i < doccol.getDocument().length; ++i) {
                XMLItemCollection xmlItemCol = doccol.getDocument()[i];
                result.add(XMLItemCollectionAdapter.getItemCollection(xmlItemCol));
            }
        }
        return result;
    }

    public static XMLItemCollection putItemCollection(ItemCollection sourceItemCollection, List<String> itemNames) {
        ItemCollection aItemCollection = (ItemCollection)sourceItemCollection.clone();
        String itemName = null;
        XMLItemCollection entity = new XMLItemCollection();
        int i = 0;
        XMLItem[] items = null;
        if (aItemCollection != null) {
            if (itemNames != null && itemNames.size() > 0) {
                items = new XMLItem[itemNames.size()];
                Iterator<String> iterator = itemNames.iterator();
                while (iterator.hasNext()) {
                    String aField;
                    itemName = aField = iterator.next();
                    XMLItem item = new XMLItem();
                    List vOrg = aItemCollection.getItemValue(aField);
                    item.setName(itemName);
                    item.setValue(vOrg.toArray());
                    items[i] = item;
                    ++i;
                }
            } else {
                Iterator it = aItemCollection.getAllItems().entrySet().iterator();
                int max = aItemCollection.getAllItems().entrySet().size();
                items = new XMLItem[max];
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    itemName = (String)entry.getKey();
                    XMLItem item = null;
                    item = new XMLItem();
                    item.setName(itemName);
                    if (entry.getValue() != null) {
                        item.setValue(((List)entry.getValue()).toArray());
                        if (item == null) continue;
                        items[i] = item;
                        ++i;
                        continue;
                    }
                    logger.warning("putItemCollection - itemName=" + itemName + " has null value");
                }
            }
            entity.setItem(items);
        }
        entity = XMLItemCollectionAdapter.sortItemsByName(entity);
        return entity;
    }

    public static XMLItemCollection sortItemsByName(XMLItemCollection xmlItemCol) {
        XMLItem[] items = xmlItemCol.getItem();
        Arrays.sort(items, new XMLItemComparator());
        xmlItemCol.setItem(items);
        return xmlItemCol;
    }

    public static XMLItemCollection putItemCollection(ItemCollection aItemCollection) {
        return XMLItemCollectionAdapter.putItemCollection(aItemCollection, null);
    }

    public static DocumentCollection putCollection(Collection<ItemCollection> col) {
        return XMLItemCollectionAdapter.putCollection(col, null);
    }

    public static DocumentCollection putCollection(Collection<ItemCollection> col, List<String> itemNames) {
        DocumentCollection entiCol = new DocumentCollection();
        Iterator<ItemCollection> it = col.iterator();
        int max = col.size();
        int i = 0;
        XMLItemCollection[] entities = new XMLItemCollection[max];
        while (it.hasNext()) {
            XMLItemCollection entity;
            ItemCollection icw = it.next();
            entities[i] = entity = XMLItemCollectionAdapter.putItemCollection(icw, itemNames);
            ++i;
        }
        if (max > 0) {
            entiCol.setDocument(entities);
        }
        return entiCol;
    }

    public static List<ItemCollection> readCollectionFromInputStream(InputStream inputStream) throws JAXBException, IOException {
        byte[] byteInput = null;
        if (inputStream == null) {
            return null;
        }
        byteInput = XMLItemCollectionAdapter.getBytesFromStream(inputStream);
        return XMLItemCollectionAdapter.readCollection(byteInput);
    }

    public static ItemCollection readItemCollectionFromInputStream(InputStream inputStream) throws JAXBException, IOException {
        byte[] byteInput = null;
        if (inputStream == null) {
            return null;
        }
        byteInput = XMLItemCollectionAdapter.getBytesFromStream(inputStream);
        return XMLItemCollectionAdapter.readItemCollection(byteInput);
    }

    public static List<ItemCollection> readCollection(byte[] byteInput) throws JAXBException, IOException {
        ArrayList<ItemCollection> resultList = new ArrayList<ItemCollection>();
        if (byteInput == null) {
            return null;
        }
        DocumentCollection ecol = null;
        logger.finest("......readCollection importXmlEntityData - verifing  content....");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DocumentCollection.class});
        Unmarshaller m = context.createUnmarshaller();
        ByteArrayInputStream input = new ByteArrayInputStream(byteInput);
        Object jaxbObject = m.unmarshal((InputStream)input);
        if (jaxbObject == null) {
            throw new RuntimeException("readCollection error - wrong xml file format - unable to read content!");
        }
        ecol = (DocumentCollection)jaxbObject;
        if (ecol.getDocument().length > 0) {
            for (XMLItemCollection aentity : ecol.getDocument()) {
                resultList.add(XMLItemCollectionAdapter.getItemCollection(aentity));
            }
            logger.fine("readCollection" + ecol.getDocument().length + " entries sucessfull imported");
        }
        return resultList;
    }

    public static ItemCollection readItemCollection(byte[] byteInput) throws JAXBException, IOException {
        if (byteInput == null) {
            return null;
        }
        XMLItemCollection ecol = null;
        logger.finest("......importXmlEntityData - verifing content....");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLItemCollection.class});
        Unmarshaller m = context.createUnmarshaller();
        ByteArrayInputStream input = new ByteArrayInputStream(byteInput);
        Object jaxbObject = m.unmarshal((InputStream)input);
        if (jaxbObject == null) {
            throw new RuntimeException("readItemCollection error - wrong xml file format - unable to read content!");
        }
        ecol = (XMLItemCollection)jaxbObject;
        ItemCollection itemCol = XMLItemCollectionAdapter.getItemCollection(ecol);
        return itemCol;
    }

    public static byte[] writeItemCollection(ItemCollection document) throws JAXBException, IOException {
        if (document == null) {
            return null;
        }
        XMLItemCollection ecol = XMLItemCollectionAdapter.putItemCollection(document);
        StringWriter writer = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLItemCollection.class});
        Marshaller m = context.createMarshaller();
        m.marshal((Object)ecol, (Writer)writer);
        return writer.toString().getBytes();
    }

    private static byte[] getBytesFromStream(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        is.close();
        return buffer.toByteArray();
    }
}

