/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs.v40;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.datatype.XMLGregorianCalendar;

@XmlSeeAlso(value={XMLItem[].class})
@XmlRootElement(name="item")
public class XMLItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(XMLItem.class.getName());
    private String name;
    private Object[] value;

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object[] getValue() {
        return this.getValue(false);
    }

    public Object[] getValue(boolean forceConversion) {
        if (forceConversion && this.isArrayOfXMLItemArray(this.value)) {
            ArrayList<Map<String, List<Object>>> convertedValue = new ArrayList<Map<String, List<Object>>>();
            for (Object object : this.value) {
                XMLItem[] innerlist = (XMLItem[])object;
                Map<String, List<Object>> map = XMLItem.convertXMLItemArray(innerlist);
                convertedValue.add(map);
            }
            return convertedValue.toArray();
        }
        if (forceConversion && this.isArrayOfXMLItem(this.value)) {
            ArrayList<List<Object>> convertedValue = new ArrayList<List<Object>>();
            for (Object object : this.value) {
                convertedValue.add(XMLItem.convertXMLItemValues((XMLItem)object));
            }
            return convertedValue.toArray();
        }
        return this.value;
    }

    public void setValue(Object[] values) {
        if (values == null || values.length == 0) {
            Vector vOrg = new Vector();
            vOrg.add(null);
            this.value = vOrg.toArray();
            return;
        }
        if (XMLItem.isBasicType(values = XMLItem.convertXMLGregorianCalendar(values))) {
            this.value = values;
        } else {
            logger.finest("......test values for map intefaces");
            if (this.isListOfMap(values)) {
                ArrayList<XMLItem[]> listOfXMLItems = new ArrayList<XMLItem[]>();
                for (Object singleMapEntry : values) {
                    Map map = (Map)singleMapEntry;
                    XMLItem[] xmlVal = XMLItem.convertMap(map);
                    listOfXMLItems.add(xmlVal);
                }
                this.value = listOfXMLItems.toArray();
            } else if (this.isListOfList(values)) {
                XMLItem[] result = new XMLItem[values.length];
                int j = 0;
                for (Object aSingleValueList : values) {
                    XMLItem xmlVal = new XMLItem();
                    List aList = (List)aSingleValueList;
                    xmlVal.setValue(aList.toArray());
                    result[j] = xmlVal;
                    ++j;
                }
                this.value = result;
            } else {
                String classNames = "";
                for (Object singleValue : values) {
                    classNames = classNames + singleValue.getClass().getName() + "; ";
                }
                logger.warning("WARNING : XMLItem - property '" + this.name + "' contains unsupported java types: " + classNames);
            }
        }
    }

    private static XMLItem[] convertMap(Map<String, Object> map) {
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        XMLItem[] result = new XMLItem[entrySet.size()];
        int i = 0;
        for (Map.Entry<String, Object> mapentry : entrySet) {
            XMLItem singleXMLItem = new XMLItem();
            singleXMLItem.setName(mapentry.getKey());
            if (mapentry.getValue() instanceof List) {
                singleXMLItem.setValue(((List)mapentry.getValue()).toArray());
            } else {
                ArrayList<String> aList = new ArrayList<String>();
                aList.add(mapentry.getValue().toString());
                singleXMLItem.setValue(aList.toArray());
            }
            result[i] = singleXMLItem;
            ++i;
        }
        return result;
    }

    private static Map<String, List<Object>> convertXMLItemArray(XMLItem[] xmlItems) {
        HashMap<String, List<Object>> resultMap = new HashMap<String, List<Object>>();
        for (XMLItem x : xmlItems) {
            resultMap.put(x.getName(), Arrays.asList(x.getValue()));
        }
        return resultMap;
    }

    private static List<Object> convertXMLItemValues(XMLItem axmlItem) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (Object o : axmlItem.getValue()) {
            resultList.add(o);
        }
        return resultList;
    }

    public boolean equals(Object o) {
        if (!(o instanceof XMLItem)) {
            return false;
        }
        XMLItem _xmlItem = (XMLItem)o;
        return this.name != null && this.name.equals(_xmlItem.name) && this.value != null && Arrays.equals(this.value, _xmlItem.value);
    }

    private boolean isListOfMap(Object[] values) {
        for (Object singleValue : values) {
            if (singleValue instanceof Map) continue;
            return false;
        }
        return true;
    }

    private boolean isListOfList(Object[] values) {
        for (Object singleValue : values) {
            if (singleValue instanceof List) continue;
            return false;
        }
        return true;
    }

    private boolean isArrayOfXMLItemArray(Object[] values) {
        for (Object singleValue : values) {
            Object[] embededList;
            if (!(singleValue instanceof Object[])) {
                return false;
            }
            for (Object embeddedValue : embededList = (Object[])singleValue) {
                if (embeddedValue instanceof XMLItem) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isArrayOfXMLItem(Object[] values) {
        for (Object singleValue : values) {
            if (singleValue instanceof XMLItem) continue;
            return false;
        }
        return true;
    }

    private static boolean isBasicType(Object[] v) {
        for (Object o : v) {
            Class<?> c;
            String name;
            if (o == null || o instanceof byte[] || o instanceof boolean[] || o instanceof short[] || o instanceof char[] || o instanceof int[] || o instanceof long[] || o instanceof float[] || o instanceof double[] || o instanceof XMLItem[] || (name = (c = o.getClass()).getName()).startsWith("java.lang.") || name.startsWith("java.math.") || "java.util.Date".equals(name) || "org.imixs.workflow.xml.XMLItem".equals(name)) continue;
            return false;
        }
        return true;
    }

    private static Object[] convertXMLGregorianCalendar(Object[] objectArray) {
        for (int j = 0; j < objectArray.length; ++j) {
            if (!(objectArray[j] instanceof XMLGregorianCalendar)) continue;
            XMLGregorianCalendar xmlCal = (XMLGregorianCalendar)objectArray[j];
            objectArray[j] = xmlCal.toGregorianCalendar().getTime();
        }
        return objectArray;
    }
}

