/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.adminp.AdminPService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.WorkflowException;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Path(value="/adminp")
@Produces(value={"text/html", "application/xml", "application/json", "text/xml"})
@Stateless
public class AdminPRestService {
    @EJB
    private DocumentService documentService;
    @EJB
    private AdminPService adminPService;
    @Context
    private HttpServletRequest servletRequest;
    private static Logger logger = Logger.getLogger(AdminPRestService.class.getName());

    @GET
    @Produces(value={"text/html"})
    @Path(value="/help")
    public StreamingOutput getHelpHTML() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 100%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs-AdminP REST Service</h1>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org/xml/restservice/adminpservice.html\" target=\"_blank\">Imixs REST Service API</a> for more information about this Service.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    @GET
    @Path(value="/jobs")
    public XMLDataCollection getAllJobs() {
        List col = null;
        try {
            col = this.documentService.getDocumentsByType("adminp");
            return XMLDataCollectionAdapter.getDataCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @POST
    @Path(value="/jobs/")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml", "text/xml"})
    public Response putJob(XMLDocument xmlworkitem) {
        if (!this.servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ItemCollection workitem = XMLDocumentAdapter.putDocument((XMLDocument)xmlworkitem);
        if (workitem == null) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        try {
            this.adminPService.createJob(workitem);
        }
        catch (AccessDeniedException e) {
            logger.severe(e.getMessage());
            workitem = this.addErrorMessage((Exception)((Object)e), workitem);
        }
        catch (RuntimeException e) {
            logger.severe(e.getMessage());
            workitem = this.addErrorMessage(e, workitem);
        }
        try {
            if (workitem.hasItem("$error_code")) {
                return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem), (String)"application/xml").status(Response.Status.NOT_ACCEPTABLE).build();
            }
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem), (String)"application/xml").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }

    @DELETE
    @Path(value="/jobs/{uniqueid}")
    public Response deleteJob(@PathParam(value="uniqueid") String uniqueid) {
        if (!this.servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.adminPService.deleteJob(uniqueid);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private ItemCollection addErrorMessage(Exception pe, ItemCollection aworkitem) {
        if (pe instanceof RuntimeException && pe.getCause() != null) {
            pe = (RuntimeException)pe.getCause();
        }
        if (pe instanceof InvalidAccessException) {
            aworkitem.replaceItemValue("$error_code", (Object)((InvalidAccessException)pe).getErrorCode());
            aworkitem.replaceItemValue("$error_message", (Object)pe.getMessage());
        } else if (pe instanceof WorkflowException) {
            aworkitem.replaceItemValue("$error_code", (Object)((WorkflowException)pe).getErrorCode());
            aworkitem.replaceItemValue("$error_message", (Object)pe.getMessage());
        } else {
            aworkitem.replaceItemValue("$error_code", (Object)"INTERNAL ERROR");
            aworkitem.replaceItemValue("$error_message", (Object)pe.getMessage());
        }
        return aworkitem;
    }
}

