/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.lucene.LuceneUpdateService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.xml.XMLCount;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Path(value="/documents")
@Produces(value={"text/html", "application/xml", "application/json", "text/xml"})
@Stateless
public class DocumentRestService {
    @EJB
    private DocumentService documentService;
    @EJB
    private LuceneUpdateService lucenUpdateService;
    @Context
    private HttpServletRequest servletRequest;
    private static Logger logger = Logger.getLogger(DocumentRestService.class.getName());

    @GET
    @Produces(value={"application/xhtml+xml"})
    public StreamingOutput getRoot() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<div class=\"root\">".getBytes());
                out.write("<a href=\"/{uniqueid}\" type=\"application/xml\" rel=\"{uniqueid}\"/>".getBytes());
                out.write("</div>".getBytes());
            }
        };
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/help")
    public StreamingOutput getHelpHTML() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 100%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs-Document REST Service</h1>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org/xml/restservice/documentservice.html\" target=\"_blank\">Imixs REST Service API</a> for more information about this Service.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    @GET
    @Path(value="/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    public Response getDocument(@PathParam(value="uniqueid") String uniqueid, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        ItemCollection document = null;
        try {
            document = this.documentService.load(uniqueid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.convertResult(document, items, format);
    }

    @GET
    @Path(value="/search/{query}")
    public Response findDocumentsByQuery(@PathParam(value="query") String query, @DefaultValue(value="-1") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortReverse") boolean sortReverse, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        List result = null;
        try {
            String decodedQuery = URLDecoder.decode(query, "UTF-8");
            result = this.documentService.find(decodedQuery, pageSize, pageIndex, sortBy, sortReverse);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.convertResultList(result, items, format);
    }

    @GET
    @Path(value="/jpql/{query}")
    public Response findDocumentsByJPQL(@PathParam(value="query") String query, @DefaultValue(value="100") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        List result = null;
        try {
            String decodedQuery = URLDecoder.decode(query, "UTF-8");
            int firstResult = pageIndex * pageSize;
            result = this.documentService.getDocumentsByQuery(decodedQuery, firstResult, pageSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.convertResultList(result, items, format);
    }

    @GET
    @Path(value="/count/{query}")
    public Response countTotalHitsByQuery(@PathParam(value="query") String query, @DefaultValue(value="-1") @QueryParam(value="maxResult") int maxResult, @QueryParam(value="format") String format) {
        XMLCount xmlcount = new XMLCount();
        try {
            String decodedQuery = URLDecoder.decode(query, "UTF-8");
            xmlcount.count = this.documentService.count(decodedQuery, maxResult);
        }
        catch (UnsupportedEncodingException | QueryException e) {
            xmlcount.count = 0L;
            logger.severe(e.getMessage());
        }
        if ("json".equals(format)) {
            return Response.ok((Object)xmlcount).header("Content-Type", (Object)"application/json").build();
        }
        if ("xml".equals(format)) {
            return Response.ok((Object)xmlcount).header("Content-Type", (Object)"application/xml").build();
        }
        return Response.ok((Object)xmlcount).build();
    }

    @GET
    @Path(value="/countpages/{query}")
    public Response countTotalPagesByQuery(@PathParam(value="query") String query, @DefaultValue(value="-1") @QueryParam(value="pageSize") int pageSize, @QueryParam(value="format") String format) {
        XMLCount xmlcount = new XMLCount();
        try {
            String decodedQuery = URLDecoder.decode(query, "UTF-8");
            xmlcount.count = this.documentService.countPages(decodedQuery, pageSize);
        }
        catch (UnsupportedEncodingException | QueryException e) {
            xmlcount.count = 0L;
            logger.severe(e.getMessage());
        }
        if ("json".equals(format)) {
            return Response.ok((Object)xmlcount).header("Content-Type", (Object)"application/json").build();
        }
        if ("xml".equals(format)) {
            return Response.ok((Object)xmlcount).header("Content-Type", (Object)"application/xml").build();
        }
        return Response.ok((Object)xmlcount).build();
    }

    @POST
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml", "text/xml"})
    public Response postEntity(XMLDocument xmlworkitem) {
        if (!this.servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ItemCollection workitem = XMLDocumentAdapter.putDocument((XMLDocument)xmlworkitem);
        if (workitem == null) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        try {
            ItemCollection currentInstance = this.documentService.load(workitem.getItemValueString("$uniqueid"));
            if (currentInstance != null) {
                currentInstance.replaceAllItems(workitem.getAllItems());
                workitem = currentInstance;
            }
            workitem.removeItem("$error_code");
            workitem.removeItem("$error_message");
            workitem = this.documentService.save(workitem);
        }
        catch (AccessDeniedException e) {
            logger.severe(e.getMessage());
            workitem = this.addErrorMessage((Exception)((Object)e), workitem);
        }
        catch (RuntimeException e) {
            logger.severe(e.getMessage());
            workitem = this.addErrorMessage(e, workitem);
        }
        try {
            if (workitem.hasItem("$error_code")) {
                return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem), (String)"application/xml").status(Response.Status.NOT_ACCEPTABLE).build();
            }
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem), (String)"application/xml").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }

    @PUT
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml", "text/xml"})
    public Response putEntity(XMLDocument xmlworkitem) {
        logger.finest("putEntity @PUT /  delegate to POST....");
        return this.postEntity(xmlworkitem);
    }

    @DELETE
    @Path(value="/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    public Response deleteEntity(@PathParam(value="uniqueid") String uniqueid) {
        if (!this.servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ItemCollection entity = this.documentService.load(uniqueid);
        if (entity != null) {
            this.documentService.remove(entity);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PUT
    @Path(value="/backup/{query}")
    public Response backup(@PathParam(value="query") String query, @QueryParam(value="filepath") String filepath) {
        if (!this.servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.documentService.backup(query, filepath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (QueryException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/restore")
    public Response restore(@QueryParam(value="filepath") String filepath) {
        if (!this.servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.documentService.restore(filepath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/configuration")
    @Produces(value={"application/xml", "application/json"})
    public Response getConfiguration(@QueryParam(value="format") String format) throws Exception {
        if (!this.servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return null;
        }
        ItemCollection config = this.lucenUpdateService.getConfiguration();
        return this.convertResult(config, null, format);
    }

    static List<String> getItemList(String items) {
        if (items == null || "".equals(items)) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(items, ",");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    private ItemCollection addErrorMessage(Exception pe, ItemCollection aworkitem) {
        if (pe instanceof RuntimeException && pe.getCause() != null) {
            pe = (RuntimeException)pe.getCause();
        }
        if (pe instanceof InvalidAccessException) {
            aworkitem.replaceItemValue("$error_code", (Object)((InvalidAccessException)pe).getErrorCode());
            aworkitem.replaceItemValue("$error_message", (Object)pe.getMessage());
        } else {
            aworkitem.replaceItemValue("$error_code", (Object)"INTERNAL ERROR");
            aworkitem.replaceItemValue("$error_message", (Object)pe.getMessage());
        }
        return aworkitem;
    }

    public Response convertResult(ItemCollection workitem, String items, String format) {
        if (workitem == null) {
            workitem = new ItemCollection();
        }
        if ("json".equals(format)) {
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem, DocumentRestService.getItemList(items))).header("Content-Type", (Object)"application/json").build();
        }
        if ("xml".equals(format)) {
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem, DocumentRestService.getItemList(items))).header("Content-Type", (Object)"application/xml").build();
        }
        return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem, DocumentRestService.getItemList(items))).build();
    }

    public Response convertResultList(List<ItemCollection> result, String items, String format) {
        if (result == null) {
            result = new ArrayList<ItemCollection>();
        }
        if ("json".equals(format)) {
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection(result, DocumentRestService.getItemList(items))).header("Content-Type", (Object)"application/json").build();
        }
        if ("xml".equals(format)) {
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection(result, DocumentRestService.getItemList(items))).header("Content-Type", (Object)"application/xml").build();
        }
        return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection(result, DocumentRestService.getItemList(items))).build();
    }
}

