/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.bpmn.BPMNModel;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.jaxrs.WorkflowRestService;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Path(value="/model")
@Produces(value={"text/html", "application/xhtml+xml", "application/xml", "application/json", "text/xml"})
@Stateless
public class ModelRestService {
    private static Logger logger = Logger.getLogger(ModelRestService.class.getName());
    static List<String> modelEntityTypes = Arrays.asList("WorkflowEnvironmentEntity", "processentity", "activityentity");
    @Inject
    private DocumentService documentService;
    @Inject
    private WorkflowRestService workflowRestService;
    @Inject
    private ModelService modelService;
    @Context
    private HttpServletRequest servletRequest;

    @GET
    @Produces(value={"text/html"})
    public StreamingOutput getModelOverview() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 75%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs-Workflow Model Service</h1>".getBytes());
                out.write("<p>".getBytes());
                ModelRestService.this.printVersionTable(out);
                out.write("</p>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org/doc/restapi/modelservice.html\" target=\"_bank\">Imixs-Workflow REST API</a> for more information.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    private void printVersionTable(OutputStream out) {
        try {
            StringBuffer buffer = new StringBuffer();
            List modelVersionList = this.modelService.getVersions();
            String rootContext = this.servletRequest.getContextPath() + this.servletRequest.getServletPath();
            buffer.append("<table>");
            buffer.append("<tr><th>Version</th><th>Uploaded</th><th>Workflow Groups</th></tr>");
            for (String modelVersion : modelVersionList) {
                Model model = this.modelService.getModel(modelVersion);
                ItemCollection modelEntity = this.modelService.loadModelEntity(modelVersion);
                List groupList = model.getGroups();
                buffer.append("<tr>");
                if (modelEntity != null) {
                    buffer.append("<td><a href=\"" + rootContext + "/model/" + modelVersion + "/bpmn\">" + modelVersion + "</a></td>");
                    if (modelEntity != null) {
                        Date dat = modelEntity.getItemValueDate("$Modified");
                        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        buffer.append("<td>" + formater.format(dat) + "</td>");
                    }
                } else {
                    buffer.append("<td>" + modelVersion + "</td>");
                    buffer.append("<td> - </td>");
                }
                buffer.append("<td>");
                for (String group : groupList) {
                    buffer.append("<a href=\"" + rootContext + "/model/" + modelVersion + "/groups/" + group + "\">" + group + "</a></br>");
                }
                buffer.append("</td>");
                buffer.append("</tr>");
            }
            buffer.append("</table>");
            out.write(buffer.toString().getBytes());
        }
        catch (IOException | ModelException e) {
            try {
                out.write("No model definition found.".getBytes());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @GET
    @Produces(value={"application/xml", "text/xml"})
    public String getModelXML() {
        List col = null;
        StringBuffer sb = new StringBuffer();
        sb.append("<model>");
        try {
            col = this.modelService.getVersions();
            for (String aversion : col) {
                sb.append("<version>" + aversion + "</version>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sb.append("</model>");
        return sb.toString();
    }

    @GET
    @Path(value="/{version}/tasks/")
    public XMLDataCollection findAllTasks(@PathParam(value="version") String version, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.modelService.getModel(version).findAllTasks();
            return XMLDataCollectionAdapter.getDataCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/{version}/bpmn")
    public Response getModelFile(@PathParam(value="version") String version, @Context UriInfo uriInfo) {
        ItemCollection modelEntity = this.modelService.loadModelEntity(version);
        if (modelEntity != null) {
            return this.workflowRestService.getWorkItemFile(modelEntity.getUniqueID(), (String)modelEntity.getFileNames().get(0), uriInfo);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{version}/definition")
    public XMLDataCollection getDefiniton(@PathParam(value="version") String version, @QueryParam(value="items") String items) {
        ItemCollection definition = null;
        try {
            definition = this.modelService.getModel(version).getDefinition();
            return XMLDataCollectionAdapter.getDataCollection((ItemCollection)definition, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/{version}/tasks/{taskid}")
    public XMLDataCollection getTask(@PathParam(value="version") String version, @PathParam(value="taskid") int processid, @QueryParam(value="items") String items) {
        ItemCollection process = null;
        try {
            process = this.modelService.getModel(version).getTask(processid);
            return XMLDataCollectionAdapter.getDataCollection((ItemCollection)process, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/{version}/tasks/{taskid}/events")
    public XMLDataCollection findAllEventsByTask(@PathParam(value="version") String version, @PathParam(value="taskid") int processid, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.modelService.getModel(version).findAllEventsByTask(processid);
            return XMLDataCollectionAdapter.getDataCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/{version}/groups")
    public List<String> getGroups(@PathParam(value="version") String version, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.modelService.getModel(version).getGroups();
            return col;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GET
    @Path(value="/{version}/groups/{group}")
    public XMLDataCollection findTasksByGroup(@PathParam(value="version") String version, @PathParam(value="group") String group, @QueryParam(value="items") String items) {
        List col = null;
        try {
            col = this.modelService.getModel(version).findTasksByGroup(group);
            return XMLDataCollectionAdapter.getDataCollection((Collection)col, this.getItemList(items));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @DELETE
    @Path(value="/{version}")
    public void deleteModel(@PathParam(value="version") String version) {
        try {
            this.modelService.deleteModel(version);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PUT
    @Path(value="/bpmn")
    @Consumes(value={"application/xml", "application/octet-stream", "text/plain"})
    public Response putBPMNModel(BPMNModel bpmnmodel) {
        try {
            logger.fine("BPMN Model posted... ");
            this.modelService.saveModel(bpmnmodel);
        }
        catch (ModelException e) {
            logger.warning("Unable to update model: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        logger.fine("putBPMNModel finished! ");
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/bpmn")
    @Consumes(value={"application/xml", "application/octet-stream", "text/plain"})
    public Response postBPMNModel(BPMNModel bpmnmodel) {
        return this.putBPMNModel(bpmnmodel);
    }

    @PUT
    @Path(value="/{version}")
    @Consumes(value={"application/xml", "text/xml"})
    public void putModelByVersion(@PathParam(value="version") String _modelVersion, XMLDataCollection ecol) {
        String sModelVersion = _modelVersion;
        try {
            if (ecol.getDocument().length > 0) {
                if (sModelVersion == null) {
                    sModelVersion = "";
                }
                if (!"".equals(sModelVersion)) {
                    this.modelService.removeModel(sModelVersion);
                }
                for (int i = 0; i < ecol.getDocument().length; ++i) {
                    XMLDocument entity = ecol.getDocument()[i];
                    ItemCollection itemCollection = XMLDocumentAdapter.putDocument((XMLDocument)entity);
                    itemCollection.replaceItemValue("$modelVersion", (Object)sModelVersion);
                    this.documentService.save(itemCollection);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @POST
    @Path(value="/{version}")
    @Consumes(value={"application/xml", "text/xml"})
    public void postModelByVersion(@PathParam(value="version") String sModelVersion, XMLDataCollection ecol) {
        this.putModelByVersion(sModelVersion, ecol);
    }

    @PUT
    @Consumes(value={"application/xml", "text/xml"})
    public void putModel(XMLDataCollection ecol) {
        String sModelVersion = null;
        try {
            if (ecol.getDocument().length > 0) {
                XMLDocument entity = ecol.getDocument()[0];
                ItemCollection itemCollection = XMLDocumentAdapter.putDocument((XMLDocument)entity);
                sModelVersion = itemCollection.getItemValueString("$ModelVersion");
                this.putModelByVersion(sModelVersion, ecol);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @POST
    @Consumes(value={"application/xml", "text/xml"})
    public void postModel(XMLDataCollection ecol) {
        this.putModel(ecol);
    }

    private List<String> getItemList(String items) {
        if (items == null || "".equals(items)) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(items, ",");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }
}

