/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.EventLogService;
import org.imixs.workflow.engine.jpa.EventLog;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;

@Path(value="/eventlog")
@Produces(value={"application/xml", "application/json", "text/html", "text/xml"})
@Stateless
public class EventLogRestService {
    @Inject
    private EventLogService eventLogService;
    @Context
    private HttpServletRequest servletRequest;
    private static Logger logger = Logger.getLogger(EventLogRestService.class.getName());

    @GET
    @Path(value="/{topic}")
    public XMLDataCollection getEventLogEntriesByTopic(@PathParam(value="topic") String topic, @DefaultValue(value="99") @QueryParam(value="maxCount") int maxCount) {
        logger.finest("......get eventLogEntry by topic: " + topic);
        String[] topicList = topic.split("~");
        List eventLogEntries = this.eventLogService.findEventsByTopic(maxCount, topicList);
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        for (EventLog eventLog : eventLogEntries) {
            ItemCollection itemColEvent = new ItemCollection();
            itemColEvent.setItemValue("id", (Object)eventLog.getId());
            itemColEvent.setItemValue("ref", (Object)eventLog.getRef());
            itemColEvent.setItemValue("created", (Object)eventLog.getCreated());
            itemColEvent.setItemValue("topic", (Object)eventLog.getTopic());
            itemColEvent.setItemValue("data", (Object)eventLog.getData());
            result.add(itemColEvent);
        }
        return XMLDataCollectionAdapter.getDataCollection(result);
    }

    @DELETE
    @Path(value="/{id}")
    public void deleteEventLogEntry(@PathParam(value="id") String id) {
        this.eventLogService.removeEvent(id);
    }
}

