/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.StreamingOutput;

@Path(value="/")
@Produces(value={"text/html", "application/xml", "application/json", "text/xml"})
@Stateless
public class RootRestService {
    @Context
    private HttpServletRequest servletRequest;
    @Context
    private HttpServletResponse servletResponse;
    private static Logger logger = Logger.getLogger(RootRestService.class.getName());

    @GET
    @Produces(value={"application/xhtml+xml"})
    public StreamingOutput getRoot() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<div class=\"root\">".getBytes());
                out.write("<a href=\"/documents\" type=\"application/xml\" rel=\"documents\"/>".getBytes());
                out.write("<a href=\"/workflow\" type=\"application/xml\" rel=\"workflow\"/>".getBytes());
                out.write("<a href=\"/model\" type=\"application/xml\" rel=\"model\"/>".getBytes());
                out.write("<a href=\"/report\" type=\"application/xml\" rel=\"report\"/>".getBytes());
                out.write("<a href=\"/adminp\" type=\"application/xml\" rel=\"adminp\"/>".getBytes());
                out.write("</div>".getBytes());
            }
        };
    }

    @GET
    @Path(value="/logout")
    public void logout() {
        try {
            this.servletRequest.logout();
            HttpSession session = this.servletRequest.getSession(false);
            if (this.servletRequest.isRequestedSessionIdValid() && session != null) {
                session.invalidate();
            }
        }
        catch (ServletException e) {
            logger.warning("Failed to logout from API endpoint /logout : " + e.getMessage());
            return;
        }
        logger.finest("Logout successfull");
    }
}

