/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.core.UriInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ImixsExceptionHandler;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.jaxrs.DocumentRestService;
import org.imixs.workflow.util.ImixsJSONParser;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Path(value="/workflow")
@Produces(value={"text/html", "application/xml", "application/json", "text/xml"})
@Stateless
public class WorkflowRestService {
    @Inject
    private WorkflowService workflowService;
    @Inject
    private DocumentRestService documentRestService;
    @Context
    private HttpServletRequest servletRequest;
    private static Logger logger = Logger.getLogger(WorkflowRestService.class.getName());

    @GET
    @Produces(value={"text/html"})
    public StreamingOutput getHelpHTML() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 100%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs-Workflow REST Service</h1>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org/doc/restapi/workflowservice.html\" target=\"_blank\">Imixs-Workflow REST API</a> for more information about this Service.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    @GET
    @Path(value="/workitem/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    public Response getWorkItem(@PathParam(value="uniqueid") String uniqueid, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        ItemCollection workitem;
        try {
            workitem = this.workflowService.getWorkItem(uniqueid);
            if (workitem == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            workitem = null;
        }
        return this.documentRestService.convertResult(workitem, items, format);
    }

    @GET
    @Path(value="/workitem/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}/file/{file}")
    public Response getWorkItemFile(@PathParam(value="uniqueid") String uniqueid, @PathParam(value="file") @Encoded String file, @Context UriInfo uriInfo) {
        try {
            ItemCollection workItem = this.workflowService.getWorkItem(uniqueid);
            if (workItem != null) {
                String fileNameUTF8 = URLDecoder.decode(file, "UTF-8");
                String fileNameISO = URLDecoder.decode(file, "ISO-8859-1");
                FileData fileData = null;
                fileData = workItem.getFileData(fileNameUTF8);
                if (fileData == null) {
                    fileData = workItem.getFileData(fileNameISO);
                }
                if (fileData == null) {
                    fileData = workItem.getFileData(file);
                }
                if (fileData != null) {
                    Response.ResponseBuilder builder = Response.ok((Object)fileData.getContent(), (String)fileData.getContentType());
                    return builder.build();
                }
                logger.warning("WorkflowRestService unable to open file: '" + file + "' in workitem '" + uniqueid + "' - error: Filename not found!");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            logger.warning("WorkflowRestService unable to open file: '" + file + "' in workitem '" + uniqueid + "' - error: Workitem not found!");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            logger.severe("WorkflowRestService unable to open file: '" + file + "' in workitem '" + uniqueid + "' - error: " + e.getMessage());
            e.printStackTrace();
            logger.severe("WorkflowRestService unable to open file: '" + file + "' in workitem '" + uniqueid + "'");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="/workitem/events/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    public Response getEvents(@PathParam(value="uniqueid") String uniqueid, @QueryParam(value="format") String format) {
        List result = null;
        try {
            result = this.workflowService.getEvents(this.workflowService.getDocumentService().load(uniqueid));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.documentRestService.convertResultList(result, null, format);
    }

    @GET
    @Path(value="/worklist")
    public Response getWorkList(@QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @DefaultValue(value="10") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="false") @QueryParam(value="sortReverse") Boolean sortReverse, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        return this.getTaskListByOwner(null, type, pageSize, pageIndex, sortBy, sortReverse, items, format);
    }

    @GET
    @Path(value="/tasklist/owner/{owner}")
    public Response getTaskListByOwner(@PathParam(value="owner") String owner, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @DefaultValue(value="10") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="false") @QueryParam(value="sortReverse") Boolean sortReverse, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        List result = null;
        try {
            if ("null".equalsIgnoreCase(owner)) {
                owner = null;
            }
            if (owner != null) {
                owner = URLDecoder.decode(owner, "UTF-8");
            }
            result = this.workflowService.getWorkListByOwner(owner, type, pageSize, pageIndex, sortBy, sortReverse.booleanValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.documentRestService.convertResultList(result, items, format);
    }

    @GET
    @Path(value="/tasklist/author/{user}")
    public Response getTaskListByAuthor(@PathParam(value="user") String user, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @DefaultValue(value="10") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="false") @QueryParam(value="sortReverse") Boolean sortReverse, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        List result = null;
        try {
            if ("null".equalsIgnoreCase(user)) {
                user = null;
            }
            if (user != null) {
                user = URLDecoder.decode(user, "UTF-8");
            }
            result = this.workflowService.getWorkListByAuthor(user, type, pageSize, pageIndex, sortBy, sortReverse.booleanValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.documentRestService.convertResultList(result, items, format);
    }

    @GET
    @Path(value="/tasklist/creator/{creator}")
    public Response getTaskListByCreator(@PathParam(value="creator") String creator, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @DefaultValue(value="10") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="false") @QueryParam(value="sortReverse") Boolean sortReverse, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        List result = null;
        try {
            if ("null".equalsIgnoreCase(creator)) {
                creator = null;
            }
            if (creator != null) {
                creator = URLDecoder.decode(creator, "UTF-8");
            }
            result = this.workflowService.getWorkListByCreator(creator, type, pageSize, pageIndex, sortBy, sortReverse.booleanValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.documentRestService.convertResultList(result, items, format);
    }

    @GET
    @Path(value="/tasklist/processid/{processid}")
    public Response getTaskListByProcessID(@PathParam(value="processid") int processid, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @DefaultValue(value="10") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="false") @QueryParam(value="sortReverse") Boolean sortReverse, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        List result = null;
        try {
            result = this.workflowService.getWorkListByProcessID(processid, type, pageSize, pageIndex, sortBy, sortReverse.booleanValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.documentRestService.convertResultList(result, items, format);
    }

    @GET
    @Path(value="/tasklist/group/{processgroup}")
    public Response getTaskListByGroup(@PathParam(value="processgroup") String processgroup, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @DefaultValue(value="10") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="false") @QueryParam(value="sortReverse") Boolean sortReverse, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        List result = null;
        try {
            if (processgroup != null) {
                processgroup = URLDecoder.decode(processgroup, "UTF-8");
            }
            result = this.workflowService.getWorkListByGroup(processgroup, type, pageSize, pageIndex, sortBy, sortReverse.booleanValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.documentRestService.convertResultList(result, items, format);
    }

    @GET
    @Path(value="/tasklist/ref/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    public Response getTaskListByRef(@PathParam(value="uniqueid") String uniqueid, @QueryParam(value="type") String type, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @DefaultValue(value="10") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="false") @QueryParam(value="sortReverse") Boolean sortReverse, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        List result = null;
        try {
            result = this.workflowService.getWorkListByRef(uniqueid, type, pageSize, pageIndex, sortBy, sortReverse.booleanValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.documentRestService.convertResultList(result, items, format);
    }

    @POST
    @Path(value="/workitem")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postFormWorkitem(InputStream requestBodyStream, @QueryParam(value="items") String items) {
        logger.fine("postFormWorkitem @POST /workitem  method:postWorkitem....");
        ItemCollection workitem = this.parseWorkitem(requestBodyStream);
        return this.processWorkitem(workitem, null, items);
    }

    @POST
    @Path(value="/workitem/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postFormWorkitemByUnqiueID(@PathParam(value="uniqueid") String uid, InputStream requestBodyStream, @QueryParam(value="items") String items) {
        logger.finest("......postFormWorkitem @POST /workitem  method:postWorkitem....");
        ItemCollection workitem = this.parseWorkitem(requestBodyStream);
        return this.processWorkitem(workitem, uid, items);
    }

    @PUT
    @Path(value="/workitem")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response putFormWorkitem(InputStream requestBodyStream, @QueryParam(value="items") String items) {
        logger.fine("putFormWorkitem @POST /workitem  delegate to POST....");
        return this.postFormWorkitem(requestBodyStream, items);
    }

    @POST
    @Path(value="/workitem")
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    public Response postWorkitem(XMLDocument xmlworkitem, @QueryParam(value="items") String items) {
        logger.fine("postWorkitem @POST /workitem  method:postWorkitem....");
        ItemCollection workitem = XMLDocumentAdapter.putDocument((XMLDocument)xmlworkitem);
        return this.processWorkitem(workitem, null, items);
    }

    @PUT
    @Path(value="/workitem")
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    public Response putWorkitem(XMLDocument workitem, @QueryParam(value="items") String items) {
        logger.fine("putWorkitem @PUT /workitem  delegate to POST....");
        return this.postWorkitem(workitem, items);
    }

    @POST
    @Path(value="/workitem/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    public Response postWorkitemByUniqueID(@PathParam(value="uniqueid") String uniqueid, XMLDocument xmlworkitem, @QueryParam(value="items") String items) {
        logger.fine("postWorkitemByUniqueID @POST /workitem/" + uniqueid + "  method:postWorkitemXML....");
        ItemCollection workitem = XMLDocumentAdapter.putDocument((XMLDocument)xmlworkitem);
        return this.processWorkitem(workitem, uniqueid, items);
    }

    @PUT
    @Path(value="/workitem/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    public Response putWorkitemByUniqueID(@PathParam(value="uniqueid") String uniqueid, XMLDocument xmlworkitem, @QueryParam(value="items") String items) {
        logger.fine("putWorkitem @PUT /workitem/{uniqueid}  delegate to POST....");
        return this.postWorkitemByUniqueID(uniqueid, xmlworkitem, items);
    }

    @POST
    @Path(value="/workitems")
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    public Response postWorkitems(XMLDataCollection worklist) {
        logger.fine("postWorkitems @POST /workitems  method:postWorkitems....");
        try {
            for (int i = 0; i < worklist.getDocument().length; ++i) {
                XMLDocument entity = worklist.getDocument()[i];
                ItemCollection itemCollection = XMLDocumentAdapter.putDocument((XMLDocument)entity);
                this.workflowService.processWorkItem(itemCollection);
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }

    @PUT
    @Path(value="/workitems")
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    public Response putWorkitems(XMLDataCollection worklist) {
        logger.fine("pupWorkitems @PUT /workitems  delegate to @POST....");
        return this.postWorkitems(worklist);
    }

    @POST
    @Path(value="/workitem/typed")
    @Produces(value={"application/json", "application/xml", "text/xml"})
    @Consumes(value={"application/json"})
    public Response postTypedWorkitemJSON(InputStream requestBodyStream, @QueryParam(value="error") String error, @QueryParam(value="items") String items) {
        logger.fine("postTypedWorkitemJSON @POST workitem....");
        ItemCollection workitem = null;
        try {
            List result = ImixsJSONParser.parse((InputStream)requestBodyStream);
            if (result != null && result.size() > 0) {
                workitem = (ItemCollection)result.get(0);
            }
        }
        catch (ParseException e) {
            logger.severe("postJSONWorkitem wrong json format!");
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        catch (UnsupportedEncodingException e) {
            logger.severe("postJSONWorkitem wrong json format!");
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        if (workitem == null) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        return this.processWorkitem(workitem, null, items);
    }

    @PUT
    @Path(value="/workitem/typed")
    @Consumes(value={"application/json"})
    public Response putTypedWorkitemJSON(InputStream requestBodyStream, @QueryParam(value="error") String error, @QueryParam(value="items") String items) {
        logger.fine("putTypedWorkitemJSON @PUT /workitem/{uniqueid}  delegate to POST....");
        return this.postTypedWorkitemJSON(requestBodyStream, error, items);
    }

    @POST
    @Path(value="/workitem/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}/typed")
    @Consumes(value={"application/json"})
    public Response postTypedWorkitemJSONByUniqueID(@PathParam(value="uniqueid") String uniqueid, InputStream requestBodyStream, @QueryParam(value="error") String error, @QueryParam(value="items") String items) {
        logger.fine("postJSONWorkitemByUniqueID @POST /workitem/" + uniqueid + "....");
        ItemCollection workitem = null;
        try {
            List result = ImixsJSONParser.parse((InputStream)requestBodyStream);
            if (result != null && result.size() > 0) {
                workitem = (ItemCollection)result.get(0);
            }
        }
        catch (ParseException e) {
            logger.severe("postJSONWorkitemByUniqueID wrong json format!");
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        catch (UnsupportedEncodingException e) {
            logger.severe("postJSONWorkitemByUniqueID wrong json format!");
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        return this.processWorkitem(workitem, uniqueid, items);
    }

    @PUT
    @Path(value="/workitem/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}/typed")
    @Consumes(value={"application/json"})
    public Response putTypedWorkitemJSONByUniqueID(@PathParam(value="uniqueid") String uniqueid, InputStream requestBodyStream, @QueryParam(value="error") String error, @QueryParam(value="items") String items) {
        logger.fine("postJSONWorkitemByUniqueID @PUT /workitem/{uniqueid}  delegate to POST....");
        return this.postTypedWorkitemJSONByUniqueID(uniqueid, requestBodyStream, error, items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemCollection parseWorkitem(InputStream requestBodyStream) {
        Vector<String> vMultiValueFieldNames = new Vector<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(requestBodyStream));
        ItemCollection workitem = new ItemCollection();
        logger.fine("[WorkflowRestService] parseWorkitem....");
        try {
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(inputLine, "&", false);
                while (st.hasMoreTokens()) {
                    String fieldValue = st.nextToken();
                    logger.finest("[WorkflowRestService] parse line:" + fieldValue);
                    try {
                        fieldValue = URLDecoder.decode(fieldValue, "UTF-8");
                        if (!fieldValue.contains("=")) {
                            logger.finest("[WorkflowRestService] line will be skipped");
                            continue;
                        }
                        String fieldName = fieldValue.substring(0, fieldValue.indexOf(61));
                        if (fieldName.contains(":") || fieldName.contains(" ") || fieldName.contains(";")) {
                            logger.finest("[WorkflowRestService] line will be skipped");
                            continue;
                        }
                        if (fieldValue.indexOf(61) == fieldValue.length()) {
                            workitem.replaceItemValue(fieldName, (Object)"");
                            logger.fine("[WorkflowRestService] no value for '" + fieldName + "'");
                            continue;
                        }
                        fieldValue = fieldValue.substring(fieldValue.indexOf(61) + 1);
                        if (vMultiValueFieldNames.indexOf(fieldName = fieldName.toLowerCase()) > -1) {
                            List v = workitem.getItemValue(fieldName);
                            v.add(fieldValue);
                            logger.fine("[WorkflowRestService] multivalue for '" + fieldName + "' = '" + fieldValue + "'");
                            workitem.replaceItemValue(fieldName, (Object)v);
                            continue;
                        }
                        logger.fine("[WorkflowRestService] value for '" + fieldName + "' = '" + fieldValue + "'");
                        workitem.replaceItemValue(fieldName, (Object)fieldValue);
                        vMultiValueFieldNames.add(fieldName);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e1) {
            logger.severe("[WorkflowRestService] Unable to parse workitem data!");
            e1.printStackTrace();
            ItemCollection itemCollection = null;
            return itemCollection;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return workitem;
    }

    private Response processWorkitem(ItemCollection workitem, String uid, String items) {
        if (workitem == null) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        if (!(uid == null || uid.isEmpty() || workitem.getUniqueID().isEmpty() || uid.equals(workitem.getUniqueID()))) {
            logger.severe("@POST/@PUT workitem/" + uid + " : $UNIQUEID did not match, remove $uniqueid to create a new instnace!");
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        if (uid != null && !uid.isEmpty()) {
            workitem.replaceItemValue("$uniqueid", (Object)uid);
        }
        try {
            workitem.removeItem("$error_code");
            workitem.removeItem("$error_message");
            workitem = this.workflowService.processWorkItem(workitem);
        }
        catch (AccessDeniedException e) {
            workitem = ImixsExceptionHandler.addErrorMessage((Exception)((Object)e), (ItemCollection)workitem);
        }
        catch (PluginException e) {
            workitem = ImixsExceptionHandler.addErrorMessage((Exception)((Object)e), (ItemCollection)workitem);
        }
        catch (RuntimeException e) {
            workitem = ImixsExceptionHandler.addErrorMessage((Exception)e, (ItemCollection)workitem);
        }
        catch (ModelException e) {
            workitem = ImixsExceptionHandler.addErrorMessage((Exception)((Object)e), (ItemCollection)workitem);
        }
        try {
            if (workitem.hasItem("$error_code")) {
                logger.severe(workitem.getItemValueString("$error_code") + ": " + workitem.getItemValueString("$error_message"));
                return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem)).status(Response.Status.NOT_ACCEPTABLE).build();
            }
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem, DocumentRestService.getItemList(items))).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }
}

