/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.imixs.workflow.bpmn.BPMNModel;
import org.imixs.workflow.bpmn.BPMNParser;
import org.imixs.workflow.exceptions.ModelException;
import org.xml.sax.SAXException;

@Provider
@Consumes(value={"application/xml", "application/octet-stream", "text/plain"})
public class BPMNUnmarshaller
implements MessageBodyReader<BPMNModel> {
    private static Logger logger = Logger.getLogger(BPMNUnmarshaller.class.getName());

    public boolean isReadable(Class aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return aClass == BPMNModel.class;
    }

    public BPMNModel readFrom(Class aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream bpmnInputStream) throws IOException, WebApplicationException {
        try {
            return BPMNParser.parseModel((InputStream)bpmnInputStream, (String)"UTF-8");
        }
        catch (ModelException e) {
            logger.warning("Invalid Model: " + e.getMessage());
            e.printStackTrace();
        }
        catch (ParseException e) {
            logger.warning("Invalid Model: " + e.getMessage());
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            logger.warning("Invalid Model: " + e.getMessage());
            e.printStackTrace();
        }
        catch (SAXException e) {
            logger.warning("Invalid Model: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }
}

