/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ImixsExceptionHandler;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.jaxrs.RestAPIUtil;
import org.imixs.workflow.xml.XMLCount;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Path(value="/documents")
@Produces(value={"text/html", "application/xml", "application/json", "text/xml"})
@Stateless
public class DocumentRestService {
    @Inject
    private DocumentService documentService;
    @Inject
    private SchemaService schemaService;
    @Context
    private HttpServletRequest servletRequest;
    private static Logger logger = Logger.getLogger(DocumentRestService.class.getName());

    @GET
    @Produces(value={"application/xhtml+xml"})
    public StreamingOutput getRoot() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<div class=\"root\">".getBytes());
                out.write("<a href=\"/{uniqueid}\" type=\"application/xml\" rel=\"{uniqueid}\"/>".getBytes());
                out.write("</div>".getBytes());
            }
        };
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/help")
    public StreamingOutput getHelpHTML() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 100%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs-Document REST Service</h1>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org/xml/restservice/documentservice.html\" target=\"_blank\">Imixs REST Service API</a> for more information about this Service.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    @GET
    @Path(value="/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    public Response getDocument(@PathParam(value="uniqueid") String uniqueid, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        ItemCollection document = null;
        try {
            document = this.documentService.load(uniqueid);
            if (document == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.convertResult(document, items, format);
    }

    @GET
    @Path(value="/search/{query}")
    public Response findDocumentsByQuery(@PathParam(value="query") String query, @DefaultValue(value="-1") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortReverse") boolean sortReverse, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        List result = null;
        try {
            String decodedQuery = URLDecoder.decode(query, "UTF-8");
            result = this.documentService.find(decodedQuery, pageSize, pageIndex, sortBy, sortReverse);
        }
        catch (Exception e) {
            logger.warning("Invalid Search Query: " + e.getMessage());
            ItemCollection error = new ItemCollection();
            error.setItemValue("$error_message", (Object)e.getMessage());
            error.setItemValue("$error_code", (Object)("" + Response.Status.NOT_ACCEPTABLE));
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)error)).status(Response.Status.NOT_ACCEPTABLE).build();
        }
        return this.convertResultList(result, items, format);
    }

    @GET
    @Path(value="/jpql/{query}")
    public Response findDocumentsByJPQL(@PathParam(value="query") String query, @DefaultValue(value="100") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        List result = null;
        try {
            String decodedQuery = URLDecoder.decode(query, "UTF-8");
            int firstResult = pageIndex * pageSize;
            result = this.documentService.getDocumentsByQuery(decodedQuery, firstResult, pageSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.convertResultList(result, items, format);
    }

    @GET
    @Path(value="/count/{query}")
    public Response countTotalHitsByQuery(@PathParam(value="query") String query, @DefaultValue(value="-1") @QueryParam(value="maxResult") int maxResult, @QueryParam(value="format") String format) {
        XMLCount xmlcount = new XMLCount();
        try {
            String decodedQuery = URLDecoder.decode(query, "UTF-8");
            xmlcount.count = this.documentService.count(decodedQuery, maxResult);
        }
        catch (UnsupportedEncodingException | QueryException e) {
            xmlcount.count = 0L;
            logger.severe(e.getMessage());
        }
        if ("json".equals(format)) {
            return Response.ok((Object)xmlcount).header("Content-Type", (Object)"application/json").build();
        }
        if ("xml".equals(format)) {
            return Response.ok((Object)xmlcount).header("Content-Type", (Object)"application/xml").build();
        }
        return Response.ok((Object)xmlcount).build();
    }

    @GET
    @Path(value="/countpages/{query}")
    public Response countTotalPagesByQuery(@PathParam(value="query") String query, @DefaultValue(value="-1") @QueryParam(value="pageSize") int pageSize, @QueryParam(value="format") String format) {
        XMLCount xmlcount = new XMLCount();
        try {
            String decodedQuery = URLDecoder.decode(query, "UTF-8");
            xmlcount.count = this.documentService.countPages(decodedQuery, pageSize);
        }
        catch (UnsupportedEncodingException | QueryException e) {
            xmlcount.count = 0L;
            logger.severe(e.getMessage());
        }
        if ("json".equals(format)) {
            return Response.ok((Object)xmlcount).header("Content-Type", (Object)"application/json").build();
        }
        if ("xml".equals(format)) {
            return Response.ok((Object)xmlcount).header("Content-Type", (Object)"application/xml").build();
        }
        return Response.ok((Object)xmlcount).build();
    }

    @POST
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    public Response postDocument(XMLDocument xmlworkitem, @QueryParam(value="items") String items) {
        if (!this.servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ItemCollection workitem = XMLDocumentAdapter.putDocument((XMLDocument)xmlworkitem);
        if (workitem == null) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        try {
            ItemCollection currentInstance = this.documentService.load(workitem.getItemValueString("$uniqueid"));
            if (currentInstance != null) {
                currentInstance.replaceAllItems(workitem.getAllItems());
                workitem = currentInstance;
            }
            workitem.removeItem("$error_code");
            workitem.removeItem("$error_message");
            workitem = this.documentService.save(workitem);
        }
        catch (AccessDeniedException e) {
            logger.severe(e.getMessage());
            workitem = ImixsExceptionHandler.addErrorMessage((Exception)((Object)e), (ItemCollection)workitem);
        }
        catch (RuntimeException e) {
            logger.severe(e.getMessage());
            workitem = ImixsExceptionHandler.addErrorMessage((Exception)e, (ItemCollection)workitem);
        }
        try {
            if (workitem.hasItem("$error_code")) {
                logger.severe(workitem.getItemValueString("$error_code") + ": " + workitem.getItemValueString("$error_message"));
                return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem), (String)"application/xml").status(Response.Status.NOT_ACCEPTABLE).build();
            }
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem, RestAPIUtil.getItemList(items)), (String)"application/xml").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }

    @PUT
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    public Response putDocument(XMLDocument xmlworkitem, @QueryParam(value="items") String items) {
        logger.finest("putDocument @PUT /  delegate to POST....");
        return this.postDocument(xmlworkitem, items);
    }

    @DELETE
    @Path(value="/{uniqueid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    public Response deleteEntity(@PathParam(value="uniqueid") String uniqueid) {
        if (!this.servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ItemCollection entity = this.documentService.load(uniqueid);
        if (entity != null) {
            this.documentService.remove(entity);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PUT
    @Path(value="/backup/{query}")
    public Response backup(@PathParam(value="query") String query, @QueryParam(value="filepath") String filepath, @QueryParam(value="snapshots") boolean snapshots) {
        if (!this.servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            String decodedQuery = URLDecoder.decode(query, "UTF-8");
            this.documentService.backup(decodedQuery, filepath, snapshots);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (QueryException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/restore")
    public Response restore(@QueryParam(value="filepath") String filepath) {
        if (!this.servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.documentService.restore(filepath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/configuration")
    @Produces(value={"application/xml", "application/json"})
    public Response getConfiguration(@QueryParam(value="format") String format) throws Exception {
        if (!this.servletRequest.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return null;
        }
        ItemCollection config = this.schemaService.getConfiguration();
        return this.convertResult(config, null, format);
    }

    public Response convertResult(ItemCollection workitem, String items, String format) {
        if (workitem == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if ("json".equals(format)) {
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem, RestAPIUtil.getItemList(items))).header("Content-Type", (Object)"application/json").build();
        }
        if ("xml".equals(format)) {
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem, RestAPIUtil.getItemList(items))).header("Content-Type", (Object)"application/xml").build();
        }
        return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem, RestAPIUtil.getItemList(items))).build();
    }

    public Response convertResultList(List<ItemCollection> result, String items, String format) {
        if (result == null) {
            result = new ArrayList<ItemCollection>();
        }
        if ("json".equals(format)) {
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection(result, RestAPIUtil.getItemList(items))).header("Content-Type", (Object)"application/json").build();
        }
        if ("xml".equals(format)) {
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection(result, RestAPIUtil.getItemList(items))).header("Content-Type", (Object)"application/xml").build();
        }
        return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection(result, RestAPIUtil.getItemList(items))).build();
    }
}

