/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.core.UriInfo;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.xml.DocumentTable;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;
import org.imixs.workflow.xml.XSLHandler;

@Path(value="/report")
@Produces(value={"application/xml", "application/json", "text/html", "text/xml"})
@Stateless
public class ReportRestService {
    @Inject
    private DocumentService entityService;
    @Inject
    private ReportService reportService;
    @Context
    private HttpServletRequest servletRequest;
    private static final Logger logger = Logger.getLogger(ReportRestService.class.getName());

    @GET
    @Produces(value={"text/html"})
    public StreamingOutput getHelpHTML() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 100%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs-Workflow REST Service</h1>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org/doc/restapi/reportservice.html\" target=\"_blank\">Imixs-Workflow REST API</a> for more information about this Service.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    @GET
    @Path(value="/definitions")
    public XMLDataCollection getReportsDefinitions() {
        try {
            List col = null;
            col = this.reportService.findAllReports();
            return XMLDataCollectionAdapter.getDataCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XMLDataCollection();
        }
    }

    @GET
    @Path(value="/definitions/{name}")
    public XMLDataCollection getReportDefinition(@PathParam(value="name") String name) {
        try {
            ItemCollection itemCol = this.reportService.findReport(name);
            return XMLDataCollectionAdapter.getDataCollection((ItemCollection)itemCol);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{name}.imixs-report")
    public Response getExcecuteReport(@PathParam(value="name") String reportName, @DefaultValue(value="1000") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortReverse") boolean sortReverse, @DefaultValue(value="") @QueryParam(value="encoding") String encoding, @Context UriInfo uriInfo) {
        List col = null;
        try {
            ItemCollection report = this.reportService.findReport(reportName);
            if (report == null) {
                logger.log(Level.SEVERE, "Report ''{0}'' not defined!", reportName);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            String sXSL = report.getItemValueString("XSL").trim();
            String sContentType = report.getItemValueString("contenttype");
            if ("".equals(sContentType)) {
                sContentType = "text/html";
            }
            if ("".equals(encoding)) {
                encoding = report.getItemValueString("encoding");
            }
            if ("".equals(encoding)) {
                encoding = "UTF-8";
            }
            Map<String, String> params = this.getQueryParams(uriInfo);
            col = this.reportService.getDataSource(report, pageSize, pageIndex, sortBy, sortReverse, params);
            if ("".equals(sXSL)) {
                Response.ResponseBuilder builder = Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((Collection)col), (String)"text/html");
                return builder.build();
            }
            XMLDataCollection xmlCol = XMLDataCollectionAdapter.getDataCollection((Collection)col);
            StringWriter writer = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLDataCollection.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)encoding);
            m.marshal((Object)xmlCol, (Writer)writer);
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                if ("application/pdf".equals(sContentType.toLowerCase())) {
                    this.fopTranformation(writer.toString(), sXSL, encoding, outputStream);
                } else {
                    XSLHandler.transform((String)writer.toString(), (String)sXSL, (String)encoding, (OutputStream)outputStream);
                }
            }
            Response.ResponseBuilder builder = Response.ok((Object)outputStream.toByteArray(), (String)sContentType);
            return builder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{name}.pdf")
    public Response getPdfReport(@PathParam(value="name") String reportName, @DefaultValue(value="1000") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortReverse") boolean sortReverse, @DefaultValue(value="") @QueryParam(value="encoding") String encoding, @Context UriInfo uriInfo) {
        return this.getExcecuteReport(reportName, pageSize, pageIndex, sortBy, sortReverse, encoding, uriInfo);
    }

    @GET
    @Produces(value={"text/html", "application/xhtml+xml"})
    @Path(value="/{name}.html")
    public DocumentTable getHTMLResult(@PathParam(value="name") String reportName, @DefaultValue(value="1000") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortReverse") boolean sortReverse, @DefaultValue(value="") @QueryParam(value="encoding") String encoding, @Context UriInfo uriInfo, @Context HttpServletResponse servlerResponse) {
        List col = null;
        try {
            ItemCollection report = this.reportService.findReport(reportName);
            List attributes = report.getItemValue("attributes");
            ArrayList<String> items = new ArrayList<String>();
            ArrayList<String> labels = new ArrayList<String>();
            for (List attribute : attributes) {
                items.add((String)attribute.get(0));
                String label = (String)attribute.get(0);
                if (attribute.size() >= 2 && !((String)attribute.get(1)).isEmpty()) {
                    label = (String)attribute.get(1);
                }
                labels.add(label);
            }
            Map<String, String> params = this.getQueryParams(uriInfo);
            col = this.reportService.getDataSource(report, pageSize, pageIndex, sortBy, sortReverse, params);
            XMLDataCollection documentCollection = XMLDataCollectionAdapter.getDataCollection((Collection)col);
            DocumentTable documentTable = new DocumentTable(documentCollection.getDocument(), items, labels, encoding);
            if ((encoding == null || "".equals(encoding)) && "".equals(encoding = report.getItemValueString("encoding"))) {
                encoding = "UTF-8";
            }
            logger.log(Level.FINE, "set encoding :{0}", encoding);
            servlerResponse.setContentType("text/html; charset=" + encoding);
            return documentTable;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GET
    @Path(value="/custom/{name}.{s:.*}")
    public Response getCustomResult(@PathParam(value="name") String reportName, @DefaultValue(value="1000") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortReverse") boolean sortReverse, @DefaultValue(value="") @QueryParam(value="encoding") String encoding, @Context UriInfo uriInfo, @Context HttpServletResponse servlerResponse) {
        ItemCollection report = this.reportService.findReport(reportName);
        if (report == null) {
            logger.log(Level.SEVERE, "Report ''{0}'' not defined!", reportName);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        if ((encoding == null || "".equals(encoding)) && "".equals(encoding = report.getItemValueString("encoding"))) {
            encoding = "UTF-8";
        }
        DocumentTable documentTable = this.getHTMLResult(reportName, pageSize, pageIndex, sortBy, sortReverse, encoding, uriInfo, servlerResponse);
        String sContentType = report.getItemValueString("contenttype");
        if (sContentType.isEmpty()) {
            sContentType = "application/xml";
        }
        logger.log(Level.FINE, "set encoding :{0}", encoding);
        servlerResponse.setContentType(sContentType + "; charset=" + encoding);
        return Response.ok((Object)documentTable, (String)sContentType).build();
    }

    @GET
    @Produces(value={"application/xml", "text/xml"})
    @Path(value="/{name}.xml")
    public XMLDataCollection getXMLResult(@PathParam(value="name") String reportName, @DefaultValue(value="100") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortReverse") boolean sortReverse, @DefaultValue(value="") @QueryParam(value="encoding") String encoding, @Context UriInfo uriInfo, @Context HttpServletResponse servlerResponse) throws Exception {
        List col = null;
        try {
            ItemCollection report = this.reportService.findReport(reportName);
            Map<String, String> params = this.getQueryParams(uriInfo);
            col = this.reportService.getDataSource(report, pageSize, pageIndex, sortBy, sortReverse, params);
            if ((encoding == null || "".equals(encoding)) && "".equals(encoding = report.getItemValueString("encoding"))) {
                encoding = "UTF-8";
            }
            logger.log(Level.FINE, "set encoding :{0}", encoding);
            servlerResponse.setContentType("application/xml; charset=" + encoding);
            return XMLDataCollectionAdapter.getDataCollection((Collection)col);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{name}.json")
    public XMLDataCollection getJSONResult(@PathParam(value="name") String name, @DefaultValue(value="-1") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortReverse") boolean sortReverse, @DefaultValue(value="") @QueryParam(value="encoding") String encoding, @Context UriInfo uriInfo, @Context HttpServletResponse servlerResponse) throws Exception {
        XMLDataCollection result = this.getXMLResult(name, pageSize, pageIndex, sortBy, sortReverse, encoding, uriInfo, servlerResponse);
        servlerResponse.setContentType("application/json; charset=" + encoding);
        return result;
    }

    @DELETE
    @Path(value="/reports/{name}")
    public void deleteReport(@PathParam(value="name") String name) {
        try {
            ItemCollection itemCol = this.reportService.findReport(name);
            this.entityService.remove(itemCol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PUT
    @Consumes(value={"application/xml", "application/octet-stream", "text/plain", "text/xml"})
    public void putReport(XMLDocument reportCol) {
        try {
            ItemCollection itemCollection = XMLDocumentAdapter.putDocument((XMLDocument)reportCol);
            this.reportService.updateReport(itemCollection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @POST
    @Consumes(value={"application/xml", "application/octet-stream", "text/plain", "text/xml"})
    public void postReport(XMLDocument reportCol) {
        this.putReport(reportCol);
    }

    public void fopTranformation(String xmlSource, String xslSource, String aEncoding, OutputStream output) throws Exception {
        FopFactory fopFactory = FopFactory.newInstance((URI)new File(".").toURI());
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        Fop fop = fopFactory.newFop("application/pdf", foUserAgent, output);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        ByteArrayInputStream baseXSL = new ByteArrayInputStream(xslSource.getBytes());
        InputStreamReader isReaderXSL = new InputStreamReader((InputStream)baseXSL, aEncoding);
        StreamSource xslSrc = new StreamSource(isReaderXSL);
        Transformer transformer = transformerFactory.newTransformer(xslSrc);
        ByteArrayInputStream baisXML = new ByteArrayInputStream(xmlSource.getBytes());
        InputStreamReader isReaderXML = new InputStreamReader((InputStream)baisXML, aEncoding);
        StreamSource xmlSrc = new StreamSource(isReaderXML);
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        transformer.transform(xmlSrc, res);
    }

    private Map<String, String> getQueryParams(UriInfo uriInfo) {
        MultivaluedMap mvm = uriInfo.getQueryParameters();
        HashMap<String, String> result = new HashMap<String, String>();
        Set keys = mvm.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String sKeyName = ((String)iter.next()).toString();
            result.put(sKeyName, (String)mvm.getFirst((Object)sKeyName));
        }
        return result;
    }
}

