/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.persistence.OptimisticLockException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.EventLogService;
import org.imixs.workflow.engine.jpa.EventLog;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Path(value="/eventlog")
@Produces(value={"application/xml", "application/json", "text/html", "text/xml"})
@Stateless
public class EventLogRestService {
    @Inject
    private EventLogService eventLogService;
    @Context
    private HttpServletRequest servletRequest;
    private static final Logger logger = Logger.getLogger(EventLogRestService.class.getName());

    @GET
    @Path(value="/")
    public XMLDataCollection getAllEventLogEntries(@DefaultValue(value="100") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageIndex") int pageIndex) {
        logger.finest("......get all eventLogEntries");
        int firstResult = pageIndex * pageSize;
        List eventLogEntries = this.eventLogService.findAllEvents(firstResult, pageSize);
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        for (EventLog eventLog : eventLogEntries) {
            result.add(this.buildItemCollection(eventLog));
        }
        return XMLDataCollectionAdapter.getDataCollection(result);
    }

    @GET
    @Path(value="/{topic}")
    public XMLDataCollection getEventLogEntriesByTopic(@PathParam(value="topic") String topic, @DefaultValue(value="99") @QueryParam(value="maxCount") int maxCount) {
        logger.log(Level.FINEST, "......get eventLogEntry by topic: {0}", topic);
        String[] topicList = topic.split("~");
        List eventLogEntries = this.eventLogService.findEventsByTopic(maxCount, topicList);
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        for (EventLog eventLog : eventLogEntries) {
            result.add(this.buildItemCollection(eventLog));
        }
        return XMLDataCollectionAdapter.getDataCollection(result);
    }

    @POST
    @Path(value="/lock/{id}")
    public Response lockEventLogEntry(@PathParam(value="id") String id) {
        EventLog _eventLogEntry = this.eventLogService.getEvent(id);
        if (_eventLogEntry != null) {
            try {
                if (this.eventLogService.lock(_eventLogEntry)) {
                    return Response.status((Response.Status)Response.Status.OK).build();
                }
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            catch (OptimisticLockException e) {
                logger.log(Level.INFO, "...unable to lock EventLock: {0}", e.getMessage());
            }
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).build();
    }

    @POST
    @Path(value="/unlock/{id}")
    public Response unlockEventLogEntry(@PathParam(value="id") String id) {
        EventLog _eventLogEntry = this.eventLogService.getEvent(id);
        if (_eventLogEntry != null) {
            try {
                if (this.eventLogService.unlock(_eventLogEntry)) {
                    return Response.status((Response.Status)Response.Status.OK).build();
                }
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            catch (OptimisticLockException e) {
                logger.log(Level.INFO, "...unable to lock EventLock: {0}", e.getMessage());
            }
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).build();
    }

    @POST
    @Path(value="/release/{interval}/{topic}")
    public void releaseDeadLocks(@PathParam(value="interval") long deadLockInterval, @PathParam(value="topic") String topic) {
        logger.log(Level.FINEST, "......releaseDeadLocks: {0}", topic);
        String[] topicList = topic.split("~");
        this.eventLogService.releaseDeadLocks(deadLockInterval, topicList);
    }

    @DELETE
    @Path(value="/{id}")
    public void deleteEventLogEntry(@PathParam(value="id") String id) {
        this.eventLogService.removeEvent(id);
    }

    @PUT
    @Path(value="/{topic}/{id}")
    public void createEventLogEntry(@PathParam(value="topic") String topic, @PathParam(value="id") String refID, XMLDocument xmlworkitem) {
        if (xmlworkitem != null) {
            this.eventLogService.createEvent(topic, refID, XMLDocumentAdapter.putDocument((XMLDocument)xmlworkitem));
        } else {
            this.eventLogService.createEvent(topic, refID);
        }
    }

    private ItemCollection buildItemCollection(EventLog eventLog) {
        if (eventLog == null) {
            return null;
        }
        ItemCollection itemColEvent = new ItemCollection();
        itemColEvent.setItemValue("id", (Object)eventLog.getId());
        itemColEvent.setItemValue("ref", (Object)eventLog.getRef());
        itemColEvent.setItemValue("created", (Object)eventLog.getCreated());
        itemColEvent.setItemValue("topic", (Object)eventLog.getTopic());
        itemColEvent.setItemValue("data", (Object)eventLog.getData());
        return itemColEvent;
    }
}

