/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jaxrs.XMLItemCollectionWriter;
import org.imixs.workflow.xml.DocumentTable;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Provider
public class DocumentTableWriter
implements MessageBodyWriter<DocumentTable> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DocumentTable.class.isAssignableFrom(type);
    }

    public void writeTo(DocumentTable documentTable, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        boolean trClass = true;
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(entityStream));
        bw.write("<html>");
        XMLItemCollectionWriter.printHead(bw, mediaType.toString(), documentTable.getEncoding());
        bw.write("<body>");
        bw.write("<table><tbody>");
        if (trClass) {
            bw.write("<tr class=\"a\">");
        } else {
            bw.write("<tr class=\"b\">");
        }
        trClass = !trClass;
        for (String label : documentTable.getLabels()) {
            bw.write("<th>" + label + "</th>");
        }
        bw.write("</tr>");
        try {
            for (XMLDocument xmlworkItem : documentTable.getDocument()) {
                if (trClass) {
                    bw.write("<tr class=\"a\">");
                } else {
                    bw.write("<tr class=\"b\">");
                }
                trClass = !trClass;
                ItemCollection itemCol = XMLDocumentAdapter.putDocument((XMLDocument)xmlworkItem);
                for (String itemName : documentTable.getItems()) {
                    List vValues = itemCol.getItemValue(itemName);
                    bw.write("<td>" + XMLItemCollectionWriter.convertValuesToString(vValues) + "</td>");
                }
                bw.write("</tr>");
            }
            bw.write("</tbody></table>");
        }
        catch (Exception e) {
            bw.write("ERROR<br>");
        }
        bw.write("</body>");
        bw.write("</html>");
        bw.flush();
    }

    public long getSize(DocumentTable arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return -1L;
    }
}

