/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import jakarta.ejb.Stateless;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

@Path(value="/")
@Produces(value={"text/html", "application/xml", "application/json", "text/xml"})
@Stateless
public class RootRestService {
    @Context
    private HttpServletRequest servletRequest;
    @Context
    private HttpServletResponse servletResponse;
    private static final Logger logger = Logger.getLogger(RootRestService.class.getName());

    @GET
    @Produces(value={"application/xhtml+xml"})
    public StreamingOutput getRoot() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<div class=\"root\">".getBytes());
                out.write("<a href=\"/documents\" type=\"application/xml\" rel=\"documents\"/>".getBytes());
                out.write("<a href=\"/workflow\" type=\"application/xml\" rel=\"workflow\"/>".getBytes());
                out.write("<a href=\"/model\" type=\"application/xml\" rel=\"model\"/>".getBytes());
                out.write("<a href=\"/report\" type=\"application/xml\" rel=\"report\"/>".getBytes());
                out.write("<a href=\"/adminp\" type=\"application/xml\" rel=\"adminp\"/>".getBytes());
                out.write("<a href=\"/eventlog\" type=\"application/xml\" rel=\"eventlog\"/>".getBytes());
                out.write("</div>".getBytes());
            }
        };
    }

    @GET
    @Path(value="/logout")
    public void logout() {
        try {
            this.servletRequest.logout();
            HttpSession session = this.servletRequest.getSession(false);
            if (this.servletRequest.isRequestedSessionIdValid() && session != null) {
                session.invalidate();
            }
        }
        catch (ServletException e) {
            logger.log(Level.WARNING, "Failed to logout from API endpoint /logout : {0}", e.getMessage());
            return;
        }
        logger.finest("Logout successfull");
    }
}

