/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jaxrs;

import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.bpmn.BPMNEntityBuilder;
import org.imixs.workflow.bpmn.BPMNUtil;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.jaxrs.DocumentRestService;
import org.imixs.workflow.jaxrs.WorkflowRestService;
import org.openbpmn.bpmn.BPMNModel;
import org.openbpmn.bpmn.elements.Activity;
import org.openbpmn.bpmn.elements.BPMNProcess;
import org.openbpmn.bpmn.elements.core.BPMNElementNode;
import org.openbpmn.bpmn.exceptions.BPMNModelException;
import org.openbpmn.bpmn.util.BPMNModelFactory;

@Path(value="/model")
@Produces(value={"text/html", "application/xhtml+xml", "application/xml", "application/json", "text/xml"})
@Stateless
public class ModelRestService {
    private static final Logger logger = Logger.getLogger(ModelRestService.class.getName());
    static List<String> modelEntityTypes = Arrays.asList("WorkflowEnvironmentEntity", "processentity", "activityentity");
    @Inject
    private DocumentService documentService;
    @Inject
    private WorkflowRestService workflowRestService;
    @Inject
    private ModelService modelService;
    @Inject
    private DocumentRestService documentRestService;
    @Context
    private HttpServletRequest servletRequest;

    @GET
    @Produces(value={"text/html"})
    public StreamingOutput getModelOverview() {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                out.write("<html><head>".getBytes());
                out.write("<style>".getBytes());
                out.write("table {padding:0px;width: 75%;margin-left: -2px;margin-right: -2px;}".getBytes());
                out.write("body,td,select,input,li {font-family: Verdana, Helvetica, Arial, sans-serif;font-size: 13px;}".getBytes());
                out.write("table th {color: white;background-color: #bbb;text-align: left;font-weight: bold;}".getBytes());
                out.write("table th,table td {font-size: 12px;}".getBytes());
                out.write("table tr.a {background-color: #ddd;}".getBytes());
                out.write("table tr.b {background-color: #eee;}".getBytes());
                out.write("</style>".getBytes());
                out.write("</head><body>".getBytes());
                out.write("<h1>Imixs-Workflow Model Service</h1>".getBytes());
                out.write("<p>".getBytes());
                ModelRestService.this.printVersionTable(out);
                out.write("</p>".getBytes());
                out.write("<p>See the <a href=\"http://www.imixs.org/doc/restapi/modelservice.html\" target=\"_bank\">Imixs-Workflow REST API</a> for more information.</p>".getBytes());
                out.write("</body></html>".getBytes());
            }
        };
    }

    private void printVersionTable(OutputStream out) {
        try {
            StringBuffer buffer = new StringBuffer();
            String rootContext = this.servletRequest.getContextPath() + this.servletRequest.getServletPath();
            buffer.append("<table>");
            buffer.append("<tr><th>Version</th><th>Uploaded</th><th>Workflow Groups</th></tr>");
            buffer.append(this.modelVersionTableToString(rootContext));
            buffer.append("</table>");
            out.write(buffer.toString().getBytes());
        }
        catch (IOException | ModelException e) {
            try {
                out.write("No model definition found.".getBytes());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @GET
    @Produces(value={"application/xml", "text/xml"})
    public String getModelXML() {
        List col = null;
        StringBuffer sb = new StringBuffer();
        sb.append("<model>");
        try {
            col = this.modelService.getModelManager().getVersions();
            for (String aversion : col) {
                sb.append("<version>" + aversion + "</version>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sb.append("</model>");
        return sb.toString();
    }

    @GET
    @Path(value="/{version}/tasks/")
    public Response findAllTasks(@PathParam(value="version") String version, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        List result = null;
        try {
            BPMNModel model = this.modelService.getModelManager().getModel(version);
            Set activities = model.findAllActivities();
            for (Activity task : activities) {
                if (!BPMNUtil.isImixsTaskElement((BPMNElementNode)task)) continue;
                ItemCollection taskEntity = BPMNEntityBuilder.build((BPMNElementNode)task);
                result.add(taskEntity);
            }
        }
        catch (ModelException e) {
            logger.severe("Unable to find tasks by model: " + e.getMessage());
        }
        return this.documentRestService.convertResultList(result, items, format);
    }

    @GET
    @Path(value="/{version}/bpmn")
    public Response getModelFile(@PathParam(value="version") String version, @Context UriInfo uriInfo) {
        try {
            BPMNModel model = this.modelService.getModelManager().getModel(version);
            if (model != null) {
                StreamingOutput stream = output -> {
                    try {
                        model.writeToOutputStream(model.getDoc(), output);
                    }
                    catch (TransformerException e) {
                        throw new WebApplicationException("Error while transforming BPMN Model to XML", (Throwable)e);
                    }
                };
                return Response.ok((Object)stream).type("application/xml").build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (ModelException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="/{version}/definition")
    public Response getDefiniton(@PathParam(value="version") String version, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        ItemCollection definition = null;
        try {
            BPMNModel model = this.modelService.getModelManager().getModel(version);
            definition = this.modelService.getModelManager().loadDefinition(model);
        }
        catch (Exception e) {
            throw new WebApplicationException("BPMN Model Error: ", (Throwable)e);
        }
        return this.documentRestService.convertResult(definition, items, format);
    }

    @GET
    @Path(value="/{version}/tasks/{taskid}")
    public Response getTask(@PathParam(value="version") String version, @PathParam(value="taskid") int taskID, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        ItemCollection task = null;
        try {
            BPMNModel model = this.modelService.getModelManager().getModel(version);
            task = this.modelService.getModelManager().findTaskByID(model, taskID);
        }
        catch (Exception e) {
            throw new WebApplicationException("BPMN Model Error: ", (Throwable)e);
        }
        return this.documentRestService.convertResult(task, items, format);
    }

    @GET
    @Path(value="/{version}/tasks/{taskid}/events/{eventid}")
    public Response getEvent(@PathParam(value="version") String version, @PathParam(value="taskid") int taskID, @PathParam(value="eventid") int eventID, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        ItemCollection event = null;
        try {
            BPMNModel model = this.modelService.getModelManager().getModel(version);
            event = this.modelService.getModelManager().findEventByID(model, taskID, eventID);
        }
        catch (Exception e) {
            throw new WebApplicationException("BPMN Model Error: ", (Throwable)e);
        }
        return this.documentRestService.convertResult(event, items, format);
    }

    @GET
    @Path(value="/{version}/tasks/{taskid}/events")
    public Response findAllEventsByTask(@PathParam(value="version") String version, @PathParam(value="taskid") int taskID, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        List result = null;
        try {
            BPMNModel model = this.modelService.getModelManager().getModel(version);
            result = this.modelService.getModelManager().findEventsByTask(model, taskID);
        }
        catch (ModelException e) {
            throw new WebApplicationException("BPMN Model Error: ", (Throwable)e);
        }
        return this.documentRestService.convertResultList(result, items, format);
    }

    @GET
    @Path(value="/{version}/groups")
    public Set<String> getGroups(@PathParam(value="version") String version, @QueryParam(value="items") String items) {
        Set col = null;
        try {
            BPMNModel model = this.modelService.getModelManager().getModel(version);
            col = this.modelService.getModelManager().findAllGroupsByModel(model);
            return col;
        }
        catch (ModelException e) {
            throw new WebApplicationException("BPMN Model Error: ", (Throwable)e);
        }
    }

    @GET
    @Path(value="/{version}/groups/{group}")
    public Response findTasksByGroup(@PathParam(value="version") String version, @PathParam(value="group") String group, @QueryParam(value="items") String items, @QueryParam(value="format") String format) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        try {
            BPMNModel model = this.modelService.getModelManager().getModel(version);
            BPMNProcess process = model.findProcessByName(group);
            process.init();
            Set tasks = process.getActivities();
            for (Activity activity : tasks) {
                if (!BPMNUtil.isImixsTaskElement((BPMNElementNode)activity)) continue;
                result.add(BPMNEntityBuilder.build((BPMNElementNode)activity));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.documentRestService.convertResultList(result, items, format);
    }

    @DELETE
    @Path(value="/{version}")
    public void deleteModel(@PathParam(value="version") String version) {
        try {
            this.modelService.deleteModel(version);
        }
        catch (Exception e) {
            throw new WebApplicationException("BPMN Model Error: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/bpmn/{filename}")
    @Consumes(value={"application/octet-stream"})
    public Response putBPMNModel(@PathParam(value="filename") String filename, InputStream inputStream) {
        try {
            logger.fine("BPMN Model file upload started for file: " + filename);
            if (!filename.toLowerCase().endsWith(".bpmn")) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"File must have .bpmn extension").build();
                return response;
            }
            BPMNModel model = BPMNModelFactory.read((InputStream)inputStream);
            this.modelService.saveModel(model, filename);
            logger.fine("BPMN Model file upload completed successfully");
            Response response = Response.status((Response.Status)Response.Status.OK).build();
            return response;
        }
        catch (BPMNModelException e) {
            logger.log(Level.WARNING, "Failed to parse BPMN model file: {0}", e.getMessage());
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid BPMN file format: " + e.getMessage())).build();
            return response;
        }
        catch (ModelException e) {
            logger.log(Level.WARNING, "Failed to save model: {0}", e.getMessage());
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Failed to save model: " + e.getMessage())).build();
            return response;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to close input stream", e);
            }
        }
    }

    @POST
    @Path(value="/bpmn/{filename}")
    @Consumes(value={"application/octet-stream"})
    public Response postBPMNModel(@PathParam(value="filename") String filename, InputStream inputStream) {
        return this.putBPMNModel(filename, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/bpmn")
    @Consumes(value={"application/octet-stream"})
    public Response putBPMNModel(InputStream inputStream) {
        try {
            logger.fine("BPMN Model file upload started... ");
            BPMNModel model = BPMNModelFactory.read((InputStream)inputStream);
            this.modelService.saveModel(model);
            logger.fine("BPMN Model file upload completed successfully");
            Response response = Response.status((Response.Status)Response.Status.OK).build();
            return response;
        }
        catch (BPMNModelException e) {
            logger.log(Level.WARNING, "Failed to parse BPMN model file: {0}", e.getMessage());
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid BPMN file format: " + e.getMessage())).build();
            return response;
        }
        catch (ModelException e) {
            logger.log(Level.WARNING, "Failed to save model: {0}", e.getMessage());
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Failed to save model: " + e.getMessage())).build();
            return response;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to close input stream", e);
            }
        }
    }

    @POST
    @Path(value="/bpmn")
    @Consumes(value={"application/octet-stream"})
    public Response postBPMNModel(InputStream inputStream) {
        return this.putBPMNModel(inputStream);
    }

    private String modelVersionTableToString(String rootContext) throws ModelException {
        List modelVersionList = this.modelService.getModelManager().getVersions();
        StringBuffer buffer = new StringBuffer();
        for (String modelVersion : modelVersionList) {
            this.appendTagsToBuffer(modelVersion, rootContext, buffer);
        }
        return buffer.toString();
    }

    private void appendTagsToBuffer(String modelVersion, String rootContext, StringBuffer buffer) throws ModelException {
        BPMNModel model = this.modelService.getModelManager().getModel(modelVersion);
        ItemCollection modelEntity = this.modelService.loadModel(modelVersion);
        Set groupList = this.modelService.getModelManager().findAllGroupsByModel(model);
        buffer.append("<tr>");
        if (modelEntity != null) {
            buffer.append("<td><a href=\"" + rootContext + "/model/" + modelVersion + "/bpmn\">" + modelVersion + "</a></td>");
            if (modelEntity != null) {
                Date dat = modelEntity.getItemValueDate("$Modified");
                SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                buffer.append("<td>" + formater.format(dat) + "</td>");
            }
        } else {
            buffer.append("<td>" + modelVersion + "</td>");
            buffer.append("<td> - </td>");
        }
        buffer.append("<td>");
        for (String group : groupList) {
            buffer.append("<a href=\"" + rootContext + "/model/" + modelVersion + "/groups/" + group + "\">" + group + "</a></br>");
        }
        buffer.append("</td>");
        buffer.append("</tr>");
    }
}

