/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.ejb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ModelService;
import org.imixs.workflow.jee.ejb.ModelServiceRemote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@Local(value={ModelService.class})
@Remote(value={ModelServiceRemote.class})
public class ModelServiceBean
implements ModelService {
    @EJB
    EntityService entityService;
    @Resource
    SessionContext ctx;

    @PostConstruct
    void initIndex() throws Exception {
        this.entityService.addIndex("numProcessID", 1);
        this.entityService.addIndex("numActivityID", 1);
        this.entityService.addIndex("$modelversion", 0);
        this.entityService.addIndex("Type", 0);
        this.entityService.addIndex("txtname", 0);
    }

    public ItemCollection getActivityEntity(int processid, int activityid) throws Exception {
        return this.findActivityEntity(processid, activityid, this.getLatestVersion());
    }

    public ItemCollection getActivityEntityByVersion(int processid, int activityid, String modelVersion) throws Exception {
        return this.findActivityEntity(processid, activityid, modelVersion);
    }

    public ItemCollection getProcessEntity(int processid) throws Exception {
        return this.findProcessEntity(processid, this.getLatestVersion());
    }

    public ItemCollection getProcessEntityByVersion(int processid, String modelversion) throws Exception {
        return this.findProcessEntity(processid, modelversion);
    }

    public Collection<ItemCollection> getActivityEntityList(int processid) throws Exception {
        String sQuery = null;
        sQuery = "SELECT ";
        sQuery = sQuery + " wi FROM Entity AS wi JOIN wi.integerItems as i1  JOIN wi.integerItems as i2  JOIN wi.textItems AS v WHERE wi.type= 'ActivityEntity'  AND i1.itemName = 'numprocessid' AND i1.itemValue = '" + processid + "' " + " AND i2.itemName = 'numactivityid' " + " AND v.itemName = '$modelversion' AND v.itemValue = '" + this.getLatestVersion() + "'" + " ORDER BY i2.itemValue ASC";
        return this.entityService.findAllEntities(sQuery, 0, -1);
    }

    public Collection<ItemCollection> getActivityEntityListByVersion(int processid, String aModelVersion) throws Exception {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity AS wi JOIN wi.integerItems as i1  JOIN wi.integerItems as i2  JOIN wi.textItems AS v WHERE wi.type= 'ActivityEntity'  AND i1.itemName = 'numprocessid' AND i1.itemValue = '" + processid + "' " + " AND i2.itemName = 'numactivityid' " + " AND v.itemName = '$modelversion' AND v.itemValue = '" + aModelVersion + "'" + " ORDER BY i2.itemValue ASC";
        return this.entityService.findAllEntities(sQuery, 0, -1);
    }

    public Collection<ItemCollection> getProcessEntityList() throws Exception {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity AS wi  JOIN wi.integerItems as i   JOIN wi.textItems AS v WHERE wi.type= 'ProcessEntity'  AND i.itemName = 'numprocessid'  AND v.itemName = '$modelversion' AND v.itemValue = '" + this.getLatestVersion() + "'" + " ORDER BY i.itemValue ASC";
        Collection col = this.entityService.findAllEntities(sQuery, 0, -1);
        return col;
    }

    public Collection<ItemCollection> getProcessEntityListByVersion(String aModelVersion) throws Exception {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity AS wi  JOIN wi.integerItems as i   JOIN wi.textItems AS v WHERE wi.type= 'ProcessEntity'  AND i.itemName = 'numprocessid'  AND v.itemName = '$modelversion' AND v.itemValue = '" + aModelVersion + "'" + " ORDER BY i.itemValue ASC";
        return this.entityService.findAllEntities(sQuery, 0, -1);
    }

    public Collection<ItemCollection> getEnvironmentEntityList() throws Exception {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi  WHERE wi.type= 'WorkflowEnvironmentEntity'";
        return this.entityService.findAllEntities(sQuery, 0, -1);
    }

    public Collection<ItemCollection> getEnvironmentEntityListByVersion(String modelversion) throws Exception {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " environment FROM Entity AS environment  JOIN environment.textItems as v WHERE environment.type = 'WorkflowEnvironmentEntity' AND v.itemName = '$modelversion' AND v.itemValue = '" + modelversion + "'";
        return this.entityService.findAllEntities(sQuery, 0, -1);
    }

    public void saveActivityEntity(ItemCollection ic) throws Exception {
        int processid = ic.getItemValueInteger("numProcessID");
        if (processid <= 0) {
            throw new Exception("invalid ProcessEntity");
        }
        int activityid = ic.getItemValueInteger("numActivityID");
        if (activityid <= 0) {
            throw new Exception("invalid ActivityEntity");
        }
        ic.replaceItemValue("Type", (Object)"ActivityEntity");
        this.entityService.save(ic);
    }

    public void saveProcessEntity(ItemCollection ic) throws Exception {
        int processid = ic.getItemValueInteger("numProcessID");
        if (processid <= 0) {
            throw new Exception("invalid ProcessEntity");
        }
        ic.replaceItemValue("Type", (Object)"ProcessEntity");
        this.entityService.save(ic);
    }

    public void saveEnvironmentEntity(ItemCollection ic) throws Exception {
        ic.replaceItemValue("Type", (Object)"WorkflowEnvironmentEntity");
        this.entityService.save(ic);
    }

    public void removeModelVersion(String modelversion) throws Exception {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = modelversion != null ? sQuery + " entity FROM Entity AS entity  JOIN entity.textItems as v WHERE entity.type IN ('ProcessEntity', 'ActivityEntity', 'WorkflowEnvironmentEntity') AND v.itemName = '$modelversion' AND v.itemValue = '" + modelversion + "'" : sQuery + " entity FROM Entity AS entity  WHERE entity.type IN ('ProcessEntity', 'ActivityEntity', 'WorkflowEnvironmentEntity')";
        Collection col = this.entityService.findAllEntities(sQuery, 0, -1);
        Iterator it = col.iterator();
        while (it.hasNext()) {
            this.entityService.remove((ItemCollection)it.next());
        }
    }

    private ItemCollection findEnvironmentEntity(String name, String modelversion) throws Exception {
        String sQuery = null;
        sQuery = "SELECT";
        Collection col = this.entityService.findAllEntities(sQuery = sQuery + " environment FROM Entity AS environment  JOIN environment.textItems AS n  JOIN environment.textItems as v WHERE environment.type = 'WorkflowEnvironmentEntity' AND n.itemName = 'txtName' and n.itemValue = '" + name + "'" + " AND v.itemName = '$modelversion' AND v.itemValue = '" + modelversion + "'", 0, 1);
        Iterator it = col.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return (ItemCollection)col.iterator().next();
    }

    private ItemCollection findProcessEntity(int processid, String modelversion) throws Exception {
        String sQuery = null;
        sQuery = "SELECT";
        Collection col = this.entityService.findAllEntities(sQuery = sQuery + " process FROM Entity AS process  JOIN process.integerItems AS i  JOIN process.textItems as v WHERE process.type = 'ProcessEntity' AND i.itemName = 'numprocessid' and i.itemValue = '" + processid + "'" + " AND v.itemName = '$modelversion' AND v.itemValue = '" + modelversion + "'", 0, 1);
        Iterator it = col.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return (ItemCollection)col.iterator().next();
    }

    private ItemCollection findActivityEntity(int processid, int activityid, String modelversion) throws Exception {
        String sQuery = null;
        sQuery = "SELECT";
        Collection col = this.entityService.findAllEntities(sQuery = sQuery + " activity FROM Entity as activity  JOIN activity.integerItems as i  JOIN activity.integerItems as i2  JOIN activity.textItems as v WHERE activity.type = 'ActivityEntity' AND i.itemName = 'numprocessid'  AND i.itemValue = '" + processid + "'" + " AND i2.itemName = 'numactivityid' and i2.itemValue = '" + activityid + "' " + " AND v.itemName = '$modelversion' AND v.itemValue = '" + modelversion + "'", 0, 1);
        Iterator it = col.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return (ItemCollection)col.iterator().next();
    }

    public String getLatestVersion() throws Exception {
        String sQuery = "SELECT process FROM Entity AS process JOIN process.textItems as v JOIN process.textItems as n WHERE process.type = 'WorkflowEnvironmentEntity' AND n.itemName = 'txtname' AND n.itemValue = 'environment.profile' AND v.itemName='$modelversion'  ORDER BY v.itemValue DESC";
        Collection col = this.entityService.findAllEntities(sQuery, 0, 1);
        if (col.size() > 0) {
            Iterator iter = col.iterator();
            String sModelVersion = ((ItemCollection)iter.next()).getItemValueString("$modelversion");
            return sModelVersion;
        }
        return "";
    }

    public List<String> getAllModelVersions() {
        ArrayList<String> colVersions = new ArrayList<String>();
        try {
            Collection<ItemCollection> colEntities = this.getEnvironmentEntityList();
            for (ItemCollection aworkitem : colEntities) {
                String sName = aworkitem.getItemValueString("txtName");
                String sVersion = aworkitem.getItemValueString("$modelversion");
                if (!"environment.profile".equals(sName) || colVersions.indexOf(sVersion) != -1) continue;
                colVersions.add(sVersion);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return colVersions;
    }

    public List<ItemCollection> getPublicActivities(int aprocessid) {
        return this.getPublicActivitiesByVersion(aprocessid, null);
    }

    public List<ItemCollection> getPublicActivitiesByVersion(int aprocessid, String version) {
        ArrayList<ItemCollection> colActivities = null;
        try {
            Collection<ItemCollection> colEntities = version != null ? this.getActivityEntityListByVersion(aprocessid, version) : this.getActivityEntityList(aprocessid);
            colActivities = new ArrayList<ItemCollection>();
            for (ItemCollection aworkitem : colEntities) {
                if ("0".equals(aworkitem.getItemValueString("keypublicresult"))) continue;
                colActivities.add(aworkitem);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return colActivities;
    }

    public List<String> getAllWorkflowGroups() {
        ArrayList<String> colGroups = new ArrayList<String>();
        try {
            Collection<ItemCollection> colEntities = this.getProcessEntityList();
            for (ItemCollection aworkitem : colEntities) {
                String sGroup = aworkitem.getItemValueString("txtworkflowgroup");
                if (colGroups.indexOf(sGroup) != -1) continue;
                colGroups.add(sGroup);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return colGroups;
    }

    public List<String> getAllWorkflowGroupsByVersion(String version) {
        ArrayList<String> colGroups = new ArrayList<String>();
        try {
            Collection<ItemCollection> colEntities = this.getProcessEntityListByVersion(version);
            for (ItemCollection aworkitem : colEntities) {
                String sGroup = aworkitem.getItemValueString("txtworkflowgroup");
                if (colGroups.indexOf(sGroup) != -1) continue;
                colGroups.add(sGroup);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return colGroups;
    }

    public List<ItemCollection> getAllStartProcessEntities() {
        return this.getAllStartProcessEntitiesByVersion(null);
    }

    public List<ItemCollection> getAllStartProcessEntitiesByVersion(String version) {
        HashMap<String, ItemCollection> cashBestProcessID = new HashMap<String, ItemCollection>();
        ArrayList<ItemCollection> colStartProcessEntities = new ArrayList<ItemCollection>();
        try {
            Collection<ItemCollection> colEntities = version == null ? this.getProcessEntityList() : this.getProcessEntityListByVersion(version);
            for (ItemCollection processEntity : colEntities) {
                String sGroup = processEntity.getItemValueString("txtworkflowgroup");
                Integer iProcessID = processEntity.getItemValueInteger("numProcessID");
                Integer iBestProcessID = null;
                ItemCollection itemColBestProcess = (ItemCollection)cashBestProcessID.get(sGroup);
                if (itemColBestProcess != null) {
                    iBestProcessID = itemColBestProcess.getItemValueInteger("numProcessID");
                }
                if (iBestProcessID != null && iProcessID >= iBestProcessID) continue;
                cashBestProcessID.put(sGroup, processEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ItemCollection bestProcessEntity : cashBestProcessID.values()) {
            colStartProcessEntities.add(bestProcessEntity);
        }
        Collections.sort(colStartProcessEntities, new ProcessEntityComparator());
        return colStartProcessEntities;
    }

    public List<ItemCollection> getAllProcessEntitiesByGroup(String aGroup) {
        ArrayList<ItemCollection> processList = new ArrayList<ItemCollection>();
        String sQuery = "SELECT DISTINCT process FROM Entity AS process  JOIN process.textItems AS t2 JOIN process.integerItems AS t3 WHERE process.type= 'ProcessEntity' AND t2.itemName = 'txtworkflowgroup'  AND t2.itemValue = '" + aGroup + "' " + " AND t3.itemName = 'numprocessid'" + " ORDER BY t3.itemValue asc";
        Collection col = this.entityService.findAllEntities(sQuery, 0, -1);
        for (ItemCollection aworkitem : col) {
            processList.add(aworkitem);
        }
        return processList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProcessEntityComparator
    implements Comparator<ItemCollection> {
        ProcessEntityComparator() {
        }

        @Override
        public int compare(ItemCollection o1, ItemCollection o2) {
            return o1.getItemValueInteger("numProcessID") - o2.getItemValueInteger("numProcessID");
        }
    }
}

