/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.ejb;

import java.util.Collection;
import java.util.Map;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ReportService;
import org.imixs.workflow.jee.ejb.ReportServiceRemote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@Local(value={ReportService.class})
@Remote(value={ReportServiceRemote.class})
public class ReportServiceBean
implements ReportService {
    @EJB
    EntityService entityService;

    public ItemCollection getReport(String aReportName) throws Exception {
        ItemCollection itemCol = this.findReport(aReportName);
        return itemCol;
    }

    public Collection<ItemCollection> getReportList(int startpos, int count) throws Exception {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi WHERE wi.type = 'ReportEntity'";
        Collection col = this.entityService.findAllEntities(sQuery, startpos, count);
        return col;
    }

    public void updateReport(ItemCollection aReport) throws Exception {
        String sReportName;
        ItemCollection oldReport;
        aReport.replaceItemValue("type", (Object)"ReportEntity");
        String sUniqueID = aReport.getItemValueString("$uniqueID");
        if ("".equals(sUniqueID) && (oldReport = this.findReport(sReportName = aReport.getItemValueString("txtName"))) != null) {
            aReport = this.updateReport(aReport, oldReport);
        }
        this.entityService.save(aReport);
    }

    public Collection<ItemCollection> processReport(String aReportName) throws Exception {
        ItemCollection itemCol = this.findReport(aReportName);
        String sQuery = itemCol.getItemValueString("txtQuery");
        int istartPos = itemCol.getItemValueInteger("numStartPos");
        int imaxcount = itemCol.getItemValueInteger("numMaxCount");
        if (imaxcount == 0) {
            imaxcount = -1;
        }
        Collection col = this.entityService.findAllEntities(sQuery, istartPos, imaxcount);
        return col;
    }

    private ItemCollection findReport(String aid) {
        String sQuery = null;
        sQuery = "SELECT";
        Collection col = this.entityService.findAllEntities(sQuery = sQuery + " wi FROM Entity as wi JOIN wi.textItems as i WHERE i.itemName = 'txtname' AND i.itemValue = '" + aid + "' " + " AND wi.type = 'ReportEntity'", 0, -1);
        if (col.size() > 0) {
            return (ItemCollection)col.iterator().next();
        }
        return null;
    }

    private ItemCollection updateReport(ItemCollection newReport, ItemCollection oldReport) throws Exception {
        for (Map.Entry mapEntry : newReport.getAllItems().entrySet()) {
            String sName = mapEntry.getKey().toString();
            Object o = mapEntry.getValue();
            if (!this.isValidAttributeName(sName)) continue;
            oldReport.replaceItemValue(sName, o);
        }
        return oldReport;
    }

    private boolean isValidAttributeName(String aName) {
        if ("namcreator".equalsIgnoreCase(aName)) {
            return false;
        }
        if ("$created".equalsIgnoreCase(aName)) {
            return false;
        }
        if ("$modified".equalsIgnoreCase(aName)) {
            return false;
        }
        if ("$uniqueID".equalsIgnoreCase(aName)) {
            return false;
        }
        return !"$isAuthor".equalsIgnoreCase(aName);
    }
}

