/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.ejb;

import java.util.Collection;
import java.util.Vector;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import org.imixs.workflow.ExtendedModel;
import org.imixs.workflow.ExtendedWorkflowContext;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidWorkitemException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ModelService;
import org.imixs.workflow.jee.ejb.WorkflowService;
import org.imixs.workflow.jee.ejb.WorkflowServiceRemote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@Local(value={WorkflowService.class})
@Remote(value={WorkflowServiceRemote.class})
public class WorkflowServiceBean
implements WorkflowService,
ExtendedWorkflowContext {
    private ItemCollection profil = null;
    private int DebugLevel = 2;
    @EJB
    EntityService entityService;
    @EJB
    ModelService modelManager;
    @Resource
    SessionContext ctx;

    @PostConstruct
    private void initIndexProperties() throws Exception {
        this.entityService.addIndex("namCreator", 0);
        this.entityService.addIndex("txtWorkflowGroup", 0);
        this.entityService.addIndex("$ProcessID", 1);
        this.entityService.addIndex("$workitemid", 0);
        this.entityService.addIndex("txtname", 0);
    }

    public ItemCollection getWorkItem(String uniqueid) throws Exception {
        return this.entityService.load(uniqueid);
    }

    public Collection<ItemCollection> getWorkList(String name) throws Exception {
        return this.getWorkList(name, 0, -1);
    }

    public Collection<ItemCollection> getWorkList(String name, int startpos, int count) throws Exception {
        if (name == null || "".equals(name)) {
            name = this.ctx.getCallerPrincipal().getName();
        }
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi  JOIN wi.writeAccess as wa JOIN wi.textItems as s WHERE wa.value = '" + name + "'" + " AND s.itemName = '$workitemid' ORDER BY wi.created desc";
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    public Collection<ItemCollection> getWorkListByCreator(String name, int startpos, int count) throws Exception {
        if (name == null || "".equals(name)) {
            name = this.ctx.getCallerPrincipal().getName();
        }
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi JOIN wi.textItems as t JOIN wi.textItems as s WHERE t.itemName = 'namcreator' and t.itemValue = '" + name + "'" + " AND s.itemName = '$workitemid' order by wi.created desc";
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    public Collection<ItemCollection> getWorkListByGroup(String name, int startpos, int count) throws Exception {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi  JOIN wi.textItems as t  JOIN wi.textItems as s WHERE t.itemName = 'txtworkflowgroup' and t.itemValue = '" + name + "'" + " AND s.itemName = '$workitemid' order by wi.created desc";
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    public Collection<ItemCollection> getWorkListByProcessID(int aid, int startpos, int count) throws Exception {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi  JOIN wi.integerItems as t JOIN wi.textItems as s WHERE t.itemName = '$processid' and t.itemValue = '" + aid + "'" + " AND s.itemName = '$workitemid' order by wi.created desc";
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    public Collection<ItemCollection> getWorkListByRef(String aref, int startpos, int count) throws Exception {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi  JOIN wi.textItems as t JOIN wi.textItems as s WHERE t.itemName = '$uniqueIDref' and t.itemValue = '" + aref + "'" + " and s.itemName = '$workitemid' order by wi.created desc";
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    public Collection<ItemCollection> getWorkListByRef(String aref) throws Exception {
        return this.getWorkListByRef(aref, 0, -1);
    }

    public ItemCollection processWorkItem(ItemCollection itemCollection) throws AccessDeniedException, InvalidWorkitemException, ProcessingErrorException {
        int aActivityInstanceID = itemCollection.getItemValueInteger("$activityid");
        if (aActivityInstanceID <= 0) {
            throw new InvalidWorkitemException("$activityid not defined");
        }
        String modelversion = itemCollection.getItemValueString("$modelversion");
        try {
            modelversion = this.updateProfileEntity(modelversion);
        }
        catch (Exception e) {
            throw new InvalidWorkitemException("Invalid ModelVersion");
        }
        WorkflowKernel workflowkernel = new WorkflowKernel((WorkflowContext)this);
        Vector vPlugins = this.profil.getItemValue("txtPlugins");
        for (int i = 0; i < vPlugins.size(); ++i) {
            String sPlugin = (String)vPlugins.elementAt(i);
            try {
                workflowkernel.registerPlugin(sPlugin);
                continue;
            }
            catch (Exception e) {
                throw new ProcessingErrorException("Unable to register Plugin - " + sPlugin);
            }
        }
        try {
            itemCollection.replaceItemValue("$modelversion", (Object)modelversion);
            String name = this.ctx.getCallerPrincipal().getName();
            if (!itemCollection.hasItem("namCreator")) {
                itemCollection.replaceItemValue("namCreator", (Object)name);
            }
            itemCollection.replaceItemValue("namlasteditor", (Object)itemCollection.getItemValueString("namcurrenteditor"));
            itemCollection.replaceItemValue("namcurrenteditor", (Object)name);
            workflowkernel.process(itemCollection);
        }
        catch (Exception e) {
            throw new ProcessingErrorException("Unable to process worktiem");
        }
        if (this.getDebugLevel() == 2) {
            System.out.println("[WorkflowManager] workitem processed sucessfull");
        }
        return this.entityService.save(itemCollection);
    }

    public void removeWorkItem(ItemCollection aworkitem) throws AccessDeniedException, InvalidWorkitemException {
        this.entityService.remove(aworkitem);
    }

    public int getDebugLevel() {
        return this.DebugLevel;
    }

    public Model getModel() {
        return this.modelManager;
    }

    public ExtendedModel getExtendedModel() {
        return this.modelManager;
    }

    public Object getSessionContext() {
        return this.ctx;
    }

    private String updateProfileEntity(String modelversion) throws Exception {
        this.DebugLevel = 2;
        if (modelversion == null || "".equals(modelversion)) {
            modelversion = this.modelManager.getLatestVersion();
        }
        String sQuery = null;
        sQuery = "SELECT";
        Collection col = this.entityService.findAllEntities(sQuery = sQuery + " environment FROM Entity AS environment JOIN environment.textItems as n  JOIN environment.textItems as v WHERE environment.type = 'WorkflowEnvironmentEntity' AND n.itemName = 'txtname' AND n.itemValue = 'environment.profile' AND v.itemName = '$modelversion' AND v.itemValue = '" + modelversion + "'", 0, 1);
        if (col.size() == 0) {
            modelversion = this.modelManager.getLatestVersion();
            sQuery = "SELECT";
            sQuery = sQuery + " environment FROM Entity AS environment JOIN environment.textItems as n  JOIN environment.textItems as v WHERE environment.type = 'WorkflowEnvironmentEntity' AND n.itemName = 'txtname' AND n.itemValue = 'environment.profile' AND v.itemName = '$modelversion' AND v.itemValue = '" + modelversion + "'";
            col = this.entityService.findAllEntities(sQuery, 0, 1);
        }
        if (col.size() > 0) {
            this.profil = (ItemCollection)col.iterator().next();
            String sDebug = this.profil.getItemValueString("keyDebugLevel");
            try {
                int idebug;
                this.DebugLevel = idebug = Integer.parseInt(sDebug);
            }
            catch (Exception e) {
                this.DebugLevel = 2;
            }
            return modelversion;
        }
        throw new Exception("[WorkflowManagerImplemenation] fatal error - now valid model version '" + modelversion + "' found! Verify WorkflowModels.");
    }

    public EntityService getEntityService() throws Exception {
        return this.entityService;
    }
}

