/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.ws;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ModelService;
import org.imixs.workflow.jee.ws.ModelWebService;
import org.imixs.workflow.services.dataobjects.Entity;
import org.imixs.workflow.services.dataobjects.EntityAdapter;
import org.imixs.workflow.services.dataobjects.EntityCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@Remote(value={ModelWebService.class})
@WebService(name="WorkflowModelService", targetNamespace="http://imixs.org/workflow/services", serviceName="WorkflowModelService", portName="WorkflowModelServicePort", wsdlLocation="ix_modelservice.wsdl")
public class ModelWebServiceBean
implements ModelWebService {
    @EJB
    EntityService entityService;
    @EJB
    ModelService modelService;
    @Resource
    SessionContext ctx;

    @WebMethod
    public EntityCollection getEnvironmentList() throws Exception {
        return this.buildEntityCollection(this.modelService.getEnvironmentEntityList());
    }

    @WebMethod
    public EntityCollection getEnvironmentListByVersion(@WebParam(name="modelversion", mode=WebParam.Mode.IN) String modelversion) throws Exception {
        return this.buildEntityCollection(this.modelService.getEnvironmentEntityListByVersion(modelversion));
    }

    @WebMethod
    public EntityCollection getProcessList() throws Exception {
        Collection col = this.modelService.getProcessEntityList();
        return this.buildEntityCollection(col);
    }

    @WebMethod
    public EntityCollection getProcessListByVersion(@WebParam(name="modelversion", mode=WebParam.Mode.IN) String modelversion) throws Exception {
        Collection col = this.modelService.getProcessEntityListByVersion(modelversion);
        return this.buildEntityCollection(col);
    }

    @WebMethod
    public EntityCollection getActivityList(@WebParam(name="processid", mode=WebParam.Mode.IN) int processid) throws Exception {
        Collection col = this.modelService.getActivityEntityList(processid);
        return this.buildEntityCollection(col);
    }

    @WebMethod
    public EntityCollection getActivityListByVersion(@WebParam(name="processid", mode=WebParam.Mode.IN) int processid, @WebParam(name="modelversion", mode=WebParam.Mode.IN) String modelversion) throws Exception {
        Collection col = this.modelService.getActivityEntityListByVersion(processid, modelversion);
        return this.buildEntityCollection(col);
    }

    @WebMethod
    public void removeModelVersion(@WebParam(name="modelversion", mode=WebParam.Mode.IN) String modelversion) throws RemoteException, Exception {
        this.modelService.removeModelVersion(modelversion);
    }

    @WebMethod
    public void updateProcessList(@WebParam(name="processlist", mode=WebParam.Mode.IN) EntityCollection processlist) throws RemoteException, Exception {
        for (int i = 0; i < processlist.getEntities().length; ++i) {
            Entity ent = processlist.getEntities(i);
            ItemCollection ic = EntityAdapter.getItemCollection((Entity)ent);
            this.modelService.saveProcessEntity(ic);
        }
    }

    @WebMethod
    public void updateActivityList(@WebParam(name="processid", mode=WebParam.Mode.IN) int processid, @WebParam(name="activitylist", mode=WebParam.Mode.IN) EntityCollection activitylist) throws RemoteException, Exception {
        for (int i = 0; i < activitylist.getEntities().length; ++i) {
            Entity ent = activitylist.getEntities(i);
            ItemCollection ic = EntityAdapter.getItemCollection((Entity)ent);
            this.modelService.saveActivityEntity(ic);
        }
    }

    @WebMethod
    public void updateEnvironmentList(@WebParam(name="environmentlist", mode=WebParam.Mode.IN) EntityCollection environmentlist) throws RemoteException, Exception {
        for (int i = 0; i < environmentlist.getEntities().length; ++i) {
            Entity ent = environmentlist.getEntities(i);
            ItemCollection ic = EntityAdapter.getItemCollection((Entity)ent);
            this.modelService.saveEnvironmentEntity(ic);
        }
    }

    private EntityCollection buildEntityCollection(Collection<ItemCollection> col) throws Exception {
        EntityCollection wl = new EntityCollection();
        Iterator<ItemCollection> it = col.iterator();
        int max = col.size();
        int i = 0;
        Entity[] entities = new Entity[max];
        while (it.hasNext()) {
            ItemCollection icw = it.next();
            Entity ic2 = new Entity();
            entities[i] = ic2 = EntityAdapter.putItemCollection((ItemCollection)icw);
            ++i;
        }
        if (max > 0) {
            wl.setEntities(entities);
        }
        return wl;
    }
}

