/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.ws;

import java.util.Collection;
import java.util.Iterator;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ReportService;
import org.imixs.workflow.jee.ws.ReportWebService;
import org.imixs.workflow.services.dataobjects.Entity;
import org.imixs.workflow.services.dataobjects.EntityAdapter;
import org.imixs.workflow.services.dataobjects.EntityCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@Remote(value={ReportWebService.class})
@WebService(name="WorkflowReportService", targetNamespace="http://imixs.org/workflow/services", serviceName="WorkflowReportService", portName="WorkflowReportServicePort", wsdlLocation="ix_reportservice.wsdl")
public class ReportWebServiceBean
implements ReportWebService {
    @EJB
    EntityService entityService;
    @EJB
    ReportService reportService;

    @WebMethod
    public Entity getReport(@WebParam(name="reportid", mode=WebParam.Mode.IN) String reportid) throws Exception {
        ItemCollection itemCol = this.reportService.getReport(reportid);
        return EntityAdapter.putItemCollection((ItemCollection)itemCol);
    }

    @WebMethod
    public EntityCollection processQuery(@WebParam(name="reportid", mode=WebParam.Mode.IN) String name) throws Exception {
        Collection col = this.reportService.processReport(name);
        return this.buildEntityCollection(col);
    }

    @WebMethod
    public void updateReport(@WebParam(name="report", mode=WebParam.Mode.IN) Entity aentity) throws Exception {
        ItemCollection itemCol = EntityAdapter.getItemCollection((Entity)aentity);
        this.reportService.updateReport(itemCol);
    }

    @WebMethod
    public EntityCollection getReportList(@WebParam(name="startpos", mode=WebParam.Mode.IN) int startpos, @WebParam(name="count", mode=WebParam.Mode.IN) int count) throws Exception {
        Collection reportCol = this.reportService.getReportList(startpos, count);
        return this.buildEntityCollection(reportCol);
    }

    @WebMethod
    public void updateReportList(@WebParam(name="reportlist", mode=WebParam.Mode.IN) EntityCollection reportlist) throws Exception {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi JOIN wi.textItems as t WHERE t.itemName = 'type' and t.itemValue = 'QueryEntity'";
        Collection col = this.entityService.findAllEntities(sQuery, 0, -1);
        Iterator it = col.iterator();
        while (it.hasNext()) {
            this.entityService.remove((ItemCollection)it.next());
        }
        for (int i = 0; i < reportlist.getEntities().length; ++i) {
            Entity ent = reportlist.getEntities(i);
            ItemCollection ic = EntityAdapter.getItemCollection((Entity)ent);
            this.reportService.updateReport(ic);
        }
    }

    private EntityCollection buildEntityCollection(Collection<ItemCollection> col) throws Exception {
        EntityCollection wl = new EntityCollection();
        Iterator<ItemCollection> it = col.iterator();
        int max = col.size();
        int i = 0;
        Entity[] entities = new Entity[max];
        while (it.hasNext()) {
            Entity entity;
            ItemCollection icw = it.next();
            entities[i] = entity = EntityAdapter.putItemCollection((ItemCollection)icw);
            ++i;
        }
        if (max > 0) {
            wl.setEntities(entities);
        }
        return wl;
    }
}

